/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad;

import com.sanrad.SrTestUtils;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.copy.CopyOperation;
import com.sanrad.util.concurrent.IFuture;
import java.rmi.RemoteException;
import java.util.Vector;
import java.util.concurrent.ExecutionException;

public class SrCopyOpTestUtils {
    public CopyOperation createOfflineCopy(VolumeNode aSource, VolumeNode aDestination) {
        CopyOperation retVal;
        block8: {
            if (aSource == null || aDestination == null) {
                assert (false) : "The parameters are invalid. aSource = " + aSource + "; aTarget = " + aDestination;
                return null;
            }
            retVal = null;
            try {
                IFuture<Void> actionFuture = SrTestUtils.getInstance().getServerLogic().offlineCopy(aSource.getCommKeyClassId(), aDestination.getCommKeyClassId());
                actionFuture.get();
                return this.getCopyOperation(aSource.getCluster(), aSource, aDestination);
            }
            catch (RemoteException e) {
                assert (false) : "Could not execute the offline copy because of the following exception: " + e;
            }
            catch (InterruptedException e) {
                assert (false) : "Could not execute the offline copy because of the following exception: " + e;
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)("Could not execute the offline copy because of the following exception: " + exp));
            }
        }
        return retVal;
    }

    public CopyOperation getCopyOperation(Cluster aCluster, VolumeNode aSource, VolumeNode aDestination) {
        if (aCluster == null || aSource == null || aDestination == null) {
            return null;
        }
        try {
            Vector copyOps = aCluster.getCopyOperManager().getAllCopyOpers();
            for (Object curObj : copyOps) {
                if (!(curObj instanceof CopyOperation)) {
                    throw new IllegalStateException();
                }
                CopyOperation curCopyOp = (CopyOperation)curObj;
                VolumeNode dst = curCopyOp.getCopyDstNode();
                VolumeNode src = curCopyOp.getCopySrcNode();
                if (!aSource.equals(src) || !aDestination.equals(dst)) continue;
                return curCopyOp;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public void removeCopyOperation(CopyOperation aCopyOp) {
        block7: {
            if (aCopyOp == null) assert (false) : "The given copy operation should not be null.";
            try {
                IFuture<Void> actionFuture = SrTestUtils.getInstance().getServerLogic().deleteElement(aCopyOp.getCommKeyClassId());
                actionFuture.get();
            }
            catch (RemoteException e) {
                assert (false) : "Could not remove the copy operation because of the following exception: " + e;
            }
            catch (InterruptedException e) {
                assert (false) : "Could not remove the copy operation because of the following exception: " + e;
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)("Could not remove the copy operation because of the following exception: " + exp));
            }
        }
    }
}

