/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad;

import com.sanrad.SrTestUtils;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.Site;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.util.concurrent.SrExecutionException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class SrClusterTestUtils {
    public ClusterImpl createCluster(String aAlias, Site aSite) {
        block15: {
            try {
                aSite.createCluster(aAlias).get();
            }
            catch (RemoteException exp1) {
                assert (false) : "Could not create the cluster because of a remote error.";
                return null;
            }
            catch (IllegalValueException exp1) {
                assert (false) : "Could not create the cluster because of the following error: " + exp1;
                return null;
            }
            catch (SrExecutionException exp) {
                assert (false) : "Could not create the cluster because of the following error: " + exp;
                return null;
            }
            catch (InterruptedException exp) {
                assert (false) : "Could not create the cluster because of the following error: " + exp;
                return null;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException exp) {
                if ($assertionsDisabled) break block15;
                throw new AssertionError((Object)("Could not create the cluster becasue of the following error: " + exp));
            }
        }
        List<ClusterImpl> clusters = SrTestUtils.getInstance().getClusters();
        for (ClusterImpl curCluster : clusters) {
            if (!curCluster.getAlias().equals(aAlias)) continue;
            while (!curCluster.isDiscoverCompleted()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException exp) {
                    System.err.println("The createCluster method with the parameters aAlias = " + aAlias + "; aSite = " + aSite + " was interrupted while waiting for cluster discovery to complete.");
                }
            }
            return curCluster;
        }
        return null;
    }

    public void removeCluster(Cluster aCluster) {
        block6: {
            try {
                SrTestUtils.getInstance().getServerLogic().deleteElement(aCluster.hashKey()).get();
            }
            catch (RemoteException exp) {
                assert (false) : "Could not remove the cluster because of a remote error.";
            }
            catch (InterruptedException exp) {
                assert (false) : "Could not remove the cluster because the operation was interrupted.";
            }
            catch (ExecutionException exp) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)("Could not remove the cluster because of the following error; " + exp));
            }
        }
    }
}

