/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad;

import com.sanrad.scripts.CliExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class SrCliTestUtils {
    public void cliRemoveNeighbor(String aHost, String aUser, String aPassword, String aNeighborName) {
        String cliCommand = "neighbor remove -nb " + aNeighborName + "\n";
        CliExecutor.getInstance().execCommand(aHost, aUser, aPassword, cliCommand);
    }

    public void cliSetAsNeighbors(String a1stVswitchIP, String a2ndVswitchIP, String aUser, String aPassword) {
        this.cliAddNeighbor(a1stVswitchIP, aUser, aPassword, a2ndVswitchIP, 0);
        this.cliAddNeighbor(a2ndVswitchIP, aUser, aPassword, a1stVswitchIP, 1);
    }

    public void cliAddNeighbor(String aHost, String aUser, String aPassword, String aNeighborIP, int aSwitchID) {
        CliExecutor.getInstance().execCommand(aHost, aUser, aPassword, this.setIdAndAddNeighbor(aNeighborIP, aSwitchID));
    }

    private String setIdAndAddNeighbor(String aNeighborIP, int aId) {
        if (aNeighborIP == null) {
            throw new IllegalArgumentException("The given arguments should not be null. aNeighbor = " + aNeighborIP + "; aId = " + aId);
        }
        StringBuilder retVal = new StringBuilder("device set -id ");
        retVal.append(aId).append("\n");
        retVal.append("neighbor add -nb ").append(aNeighborIP);
        retVal.append(" -ip ").append(aNeighborIP).append("\n");
        return retVal.toString();
    }

    public String cliGetNeighborIP(String aHost, String aUser, String aPassword) {
        List<String> result = this.cliGetNeighbor(aHost, aUser, aPassword);
        if (result != null && result.size() > 1) {
            return result.get(1);
        }
        return null;
    }

    public String cliGetNeighborName(String aHost, String aUser, String aPassword) {
        List<String> result = this.cliGetNeighbor(aHost, aUser, aPassword);
        if (result != null && result.size() > 1) {
            return result.get(0);
        }
        return null;
    }

    private List<String> cliGetNeighbor(String aHost, String aUser, String aPassword) {
        String getNeighborCommand = "neighbor show\n";
        String cliResponse = CliExecutor.getInstance().execCommand(aHost, aUser, aPassword, getNeighborCommand);
        String[] cliLines = cliResponse.split("\\n");
        String resultLine = null;
        String[] nbrTableColumns = new String[]{"Name", "IP Address", "UDP", "SNMP Timeout(msec)", "SNMP # of Retries"};
        block0: for (int i = 0; i < cliLines.length; ++i) {
            for (int j = 0; j < nbrTableColumns.length; ++j) {
                if (cliLines[i].indexOf(nbrTableColumns[j]) < 0) continue block0;
            }
            resultLine = cliLines[i + 1];
        }
        if (resultLine == null || resultLine.trim().length() == 0) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(resultLine, " ");
        ArrayList<String> cliGetNbrResult = null;
        while (tokenizer.hasMoreTokens()) {
            String curToken = tokenizer.nextToken().trim();
            if (curToken == null || curToken.equals("")) continue;
            if (cliGetNbrResult == null) {
                cliGetNbrResult = new ArrayList<String>();
            }
            cliGetNbrResult.add(curToken);
        }
        return cliGetNbrResult;
    }
}

