/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.wizard;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.comm.CommunicationErrorEvent;
import com.sanrad.nms.client.comm.CommunicationErrorListener;
import com.sanrad.nms.client.comm.CommunicationEventService;
import com.sanrad.nms.client.comm.ConnectionException;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.cluster.ClusterEvent;
import com.sanrad.nms.client.event.cluster.ClusterListener;
import com.sanrad.nms.client.event.vswitch.VSwitchEvent;
import com.sanrad.nms.client.event.vswitch.VSwitchListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.swing.ImageObject;
import com.sanrad.swing.PropertyPanelValidationEvent;
import com.sanrad.swing.PropertyPanelValidationListener;
import com.sanrad.swing.SrComponentStatusBarInterface;
import com.sanrad.swing.SrComponentStatusBarPanel;
import com.sanrad.swing.SrOptionPan;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.wizard.SrWizardPanel;
import com.sanrad.util.BundleKeysInterface;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import jwf.Wizard;
import jwf.WizardListener;
import jwf.WizardPanel;
import jwf.WizardTransaction;
import jwf.WizardTransactionMonitor;

public abstract class SrWizardFrame
extends JFrame
implements WizardListener,
SrComponentStatusBarInterface,
PropertyPanelValidationListener,
CommunicationErrorListener,
VSwitchListener,
ClusterListener {
    public static final int HEIGHT_EXTENSION = 15;
    private static final ArrayList runningWizards = new ArrayList();
    private Wizard m_wiz;
    private SrWizardPanel m_firstPanel;
    protected String m_wizTitle;
    protected SrComponentStatusBarPanel m_statusPanel;
    private SrWizardFrameTransactionMonitor m_transactionMonitor = new SrWizardFrameTransactionMonitor();
    private MouseAdapter emptyMouseListener = new MouseAdapter(){};
    private static final String SPACE = " ";
    private static final String STEP = ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.WIZARD_STEP);
    public static final String OWNER_KEY = "Owner";
    private ArrayList m_involvedClusterList = new ArrayList();

    protected SrWizardFrame(final JFrame owner, String wizTitle, SrWizardPanel panel) {
        this.setIconImage(ImageObject.APP_ICON.getImageIcon().getImage());
        this.m_firstPanel = panel;
        this.setResizable(false);
        try {
            CommunicationEventService.getInstance().addCommunicationErrorListener((CommunicationErrorListener)this);
        }
        catch (ConnectionException e) {
            ClientLoader.logger.error((Throwable)e);
        }
        VSwitchManager.getInstance().addVSwitchListener((VSwitchListener)this);
        ClusterManager.getInstance().addClusterListener((ClusterListener)this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                SrWizardFrame.this.onWizardWindowClose();
            }
        });
        this.m_wiz = new Wizard();
        this.m_statusPanel = this.m_wiz.getStatusBarPanel();
        this.m_wiz.addWizardListener((WizardListener)this);
        this.setContentPane((Container)this.m_wiz);
        this.m_wiz.setTransactionMonitor((WizardTransactionMonitor)this.m_transactionMonitor);
        this.m_wizTitle = String.valueOf(wizTitle) + SPACE;
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SrWizardFrame.this.setSize(SrWizardFrame.this.getWidth() + SrWizardFrame.this.m_wiz.getSummaryListPanelWidth(), SrWizardFrame.this.getHeight() + 15);
                Rectangle abounds = SrWizardFrame.this.getBounds();
                Dimension backScreenDim = null;
                backScreenDim = owner != null ? owner.getSize() : Toolkit.getDefaultToolkit().getScreenSize();
                SrWizardFrame.this.setLocation((backScreenDim.width - abounds.width) / 2, (backScreenDim.height - abounds.height) / 2);
            }
        });
    }

    public void runWizard() {
        runningWizards.add(this.getClass());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SrWizardFrame.this.setVisible(true);
            }
        });
        this.m_wiz.start((WizardPanel)this.m_firstPanel, this);
    }

    protected void onWizardWindowClose() {
        this.verifyClose();
    }

    public void wizardCancelled(Wizard wizard) {
        this.verifyClose();
    }

    private void verifyClose() {
        int answer = SrOptionPan.showYesNoConfirmDialog(this, this.getClosingMessage(), this.getTitle());
        if (answer == 0) {
            this.dispose();
        }
    }

    protected abstract String getClosingMessage();

    protected abstract String getFinishMessage();

    public void wizardFinished(Wizard wizard) {
        this.dispose();
    }

    public void wizardPanelChanged(Wizard wizard) {
        if (wizard.getCurrentPanel() != null) {
            this.setTitle(this.m_wizTitle);
            this.m_statusPanel.setStatusStr("");
        }
    }

    public SrComponentStatusBarPanel getStatusBarPanel() {
        return this.m_statusPanel;
    }

    public void onPanelPropertyChanged(PropertyPanelValidationEvent e) {
        if (e == null) {
            this.m_statusPanel.setStatusStr("");
        } else {
            Vector nonValidFields = e.getNonValidFields();
            boolean valid = nonValidFields.isEmpty();
            if (valid) {
                this.m_statusPanel.setStatusStr("");
            } else {
                this.m_statusPanel.setStatusStr("Please fill the missing data marked by the red asterisks");
            }
        }
    }

    public void addParticipatingCluster(ClusterNode cluster) {
        if (cluster != null && !this.m_involvedClusterList.contains(cluster)) {
            this.m_involvedClusterList.add(cluster);
        }
    }

    public void removeParticipatingCluster(ClusterNode cluster) {
        this.m_involvedClusterList.remove(cluster);
    }

    public void clearParticipatingClusters() {
        this.m_involvedClusterList.clear();
    }

    private void checkClusterConnectivity(VSwitchNode vs) {
        boolean clusterForVSFound = false;
        int i = this.m_involvedClusterList.size();
        while (i-- > 0) {
            ClusterNode cluster = (ClusterNode)this.m_involvedClusterList.get(i);
            if (!cluster.getClusterVSwitches().contains(vs) || !cluster.allAvailableVSwitchesDisconnected()) continue;
            clusterForVSFound = true;
            this.errorOccured(ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_WIZ_CLUSTER_DISCONNECTED, new String[]{cluster.toString()}));
            break;
        }
        if (!clusterForVSFound && !vs.isConnected()) {
            this.errorOccured(ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_WIZ_CLUSTER_DISCONNECTED, new String[]{vs.toString()}));
        }
    }

    public void setWaitCursor() {
        this.getGlassPane().addMouseListener(this.emptyMouseListener);
        this.getGlassPane().setVisible(true);
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void setDefaultCursor() {
        this.getGlassPane().removeMouseListener(this.emptyMouseListener);
        this.getGlassPane().setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void errorOccured(String errorMsg) {
        this.m_transactionMonitor.wizardTransactionEndedSuccessfully = false;
        this.m_transactionMonitor.stopTransaction();
        this.m_wiz.getCurrentPanel().setCancelButtonEnabled(true);
        this.setDefaultCursor();
        if (errorMsg != null) {
            JOptionPane.showMessageDialog(this, errorMsg, "", 0);
        }
    }

    public void dispose() {
        runningWizards.remove(this.getClass());
        this.m_wiz.getCurrentPanel().removeListeners();
        VSwitchManager.getInstance().removeVSwitchListener((VSwitchListener)this);
        ClusterManager.getInstance().removeClusterListener((ClusterListener)this);
        try {
            CommunicationEventService.getInstance().removeCommunicationErrorListener((CommunicationErrorListener)this);
        }
        catch (ConnectionException e) {
            ClientLoader.logger.error((Throwable)e);
        }
        super.dispose();
    }

    public static boolean isAlreadyRunningWizard(Class wizClass) {
        return runningWizards.contains(wizClass);
    }

    public void configurationError(CommunicationErrorEvent e) {
        this.errorOccured(null);
    }

    public void eventSynchronizationError(CommunicationErrorEvent e) {
        this.errorOccured(null);
    }

    public void fatalConfigurationError(CommunicationErrorEvent e) {
        this.errorOccured(null);
    }

    public void serverWasShutdown(CommunicationErrorEvent e) {
        this.errorOccured(null);
    }

    public void snmpError(CommunicationErrorEvent e) {
        this.errorOccured(null);
    }

    public void resetVSwitchStarted(VSwitchEvent e) {
        this.checkClusterConnectivity((VSwitchNode)SystemRootNode.getInstance().getRefByStub(e.getStub()));
    }

    public void vSwitchCreated(VSwitchEvent e) {
    }

    public void vSwitchPropertiesChanged(VSwitchEvent e) {
        this.checkClusterConnectivity((VSwitchNode)SystemRootNode.getInstance().getRefByStub(e.getStub()));
    }

    public void vSwitchRediscovered(VSwitchEvent e) {
        this.checkClusterConnectivity((VSwitchNode)SystemRootNode.getInstance().getRefByStub(e.getStub()));
    }

    public void vSwitchRemoved(VSwitchEvent e) {
        this.checkClusterConnectivity((VSwitchNode)SystemRootNode.getInstance().getRefByStub(e.getStub()));
    }

    public void clusterCreated(ClusterEvent event) {
    }

    public void clusterPropertiesChanged(ClusterEvent event) {
    }

    public void clusterRemoved(ClusterEvent event) {
        ClusterNode cluster = event.getClusterNode();
        if (this.m_involvedClusterList.contains(cluster)) {
            this.errorOccured(ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_WIZ_CLUSTER_DELETED, new String[]{cluster.getAlias()}));
            this.dispose();
        }
    }

    public void clusterStatusChanged(ClusterEvent event) {
    }

    public void discoverCompleted(ClusterEvent event) {
    }

    public void discoverStarted(ClusterEvent event) {
        ClusterNode cluster = event.getClusterNode();
        if (this.m_involvedClusterList.contains(cluster)) {
            this.errorOccured(ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_WIZ_CLUSTER_REDISCOVERING, new String[]{cluster.getAlias()}));
            this.dispose();
        }
    }

    public void refreshCluster(ClusterEvent event) {
    }

    public void fail(String message) {
        StatusPanel.getInstance().setText(message, StatusPanel.ERROR, this);
        this.errorOccured(null);
    }

    public void inProccess(String message) {
        StatusPanel.getInstance().setText(message, StatusPanel.INFO, this);
    }

    public void success() {
    }

    public String getStatusStr() {
        return this.m_statusPanel.getStatusStr();
    }

    public void setStatusStr(String statusStr) {
        this.m_statusPanel.setStatusStr(statusStr);
    }

    private class SrWizardFrameTransactionMonitor
    implements WizardTransactionMonitor {
        WizardTransaction transaction = null;
        private boolean wizardTransactionEndedSuccessfully = true;

        SrWizardFrameTransactionMonitor() {
        }

        public boolean wizardTransactionEndedSuccessfully() {
            return this.wizardTransactionEndedSuccessfully;
        }

        public void wizardTransactionStarted(WizardTransaction transaction) {
            this.transaction = transaction;
            this.wizardTransactionEndedSuccessfully = true;
            SrWizardFrame.this.setWaitCursor();
        }

        public void wizardTransactionStopped() {
            SrWizardFrame.this.setDefaultCursor();
        }

        public void stopTransaction() {
            if (this.transaction != null) {
                this.transaction.stop();
            }
        }
    }
}

