/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.text;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LengthLimitedDocument
extends PlainDocument {
    public static final int NO_LIMIT = -1;
    protected int limit;

    public LengthLimitedDocument(int limit) {
        this.limit = limit;
    }

    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str != null && (this.limit == -1 || this.getLength() + str.length() <= this.limit)) {
            super.insertString(offset, str, attr);
        } else if (str != null && this.limit != -1 && str.length() > this.limit) {
            super.insertString(offset, str.substring(0, this.limit), attr);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public int getLimit() {
        return this.limit;
    }
}

