/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.table;

import com.sanrad.swing.table.ColumnGroup;
import com.sanrad.swing.table.GroupableTableHeaderUI;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class GroupableTableHeader
extends JTableHeader {
    private static final String uiClassID = "GroupableTableHeaderUI";
    protected Vector columnGroups = null;

    public GroupableTableHeader(TableColumnModel model) {
        super(model);
        this.setUI(new GroupableTableHeaderUI());
        this.setReorderingAllowed(false);
    }

    public void setReorderingAllowed(boolean b) {
        this.reorderingAllowed = false;
    }

    public void addColumnGroup(ColumnGroup g) {
        if (this.columnGroups == null) {
            this.columnGroups = new Vector();
        }
        this.columnGroups.addElement(g);
    }

    public ColumnGroup getGroupByName(String groupName) {
        ColumnGroup returnGroup = null;
        int i = 0;
        while (i < this.columnGroups.size()) {
            ColumnGroup g = (ColumnGroup)this.columnGroups.get(i);
            if (g.getHeaderValue().equals(groupName)) {
                returnGroup = g;
                break;
            }
            ++i;
        }
        return returnGroup;
    }

    public Enumeration getColumnGroups(TableColumn col) {
        if (this.columnGroups == null) {
            return null;
        }
        Enumeration enumeration = this.columnGroups.elements();
        while (enumeration.hasMoreElements()) {
            ColumnGroup cGroup = (ColumnGroup)enumeration.nextElement();
            Vector v_ret = cGroup.getColumnGroups(col, new Vector());
            if (v_ret == null) continue;
            return v_ret.elements();
        }
        return null;
    }

    public void setColumnMargin() {
        if (this.columnGroups == null) {
            return;
        }
        int columnMargin = this.getColumnModel().getColumnMargin() - 1;
        Enumeration enumeration = this.columnGroups.elements();
        while (enumeration.hasMoreElements()) {
            ColumnGroup cGroup = (ColumnGroup)enumeration.nextElement();
            cGroup.setColumnMargin(columnMargin);
        }
    }
}

