/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.components.SrComponent;
import java.awt.Component;
import java.awt.event.FocusListener;
import java.util.EventListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;

public class SrTextField
extends JTextField
implements SrComponent {
    private String m_enabledtoolTip = null;
    private String m_disabledtoolTip = null;

    public SrTextField() {
        this.init();
    }

    public SrTextField(String text) {
        super(text);
        this.init();
    }

    public SrTextField(int cols) {
        super(cols);
        this.init();
    }

    public SrTextField(boolean editable) {
        this.setEditable(false);
        this.init();
    }

    private void init() {
        this.setFont(LookAndFill.GENERAL_FONT);
    }

    public Object getValue() {
        return this.getText();
    }

    public void setValue(Object value) {
        Object val = value != null ? value : "";
        this.setText(val.toString());
    }

    public Component getComponent() {
        return this;
    }

    public void setEnableComponent(boolean enable) {
        this.setEnabled(enable);
    }

    public boolean isComponentEnabled() {
        return this.isEnabled();
    }

    public boolean isComponentValid() {
        String txt = this.getText();
        return txt != null && txt.length() > 0;
    }

    public void addComponentFocusListener(FocusListener fl) {
        this.addFocusListener(fl);
    }

    public void addComponentValidListener(EventListener l) {
        if (l instanceof DocumentListener) {
            this.getDocument().addDocumentListener((DocumentListener)l);
        }
    }

    public void removeComponentFocusListener(FocusListener fl) {
        this.removeFocusListener(fl);
    }

    public void removeComponentValidListener(EventListener l) {
        if (l instanceof DocumentListener) {
            this.getDocument().removeDocumentListener((DocumentListener)l);
        }
    }

    public int compareTo(SrComponent com) {
        int answer = -1;
        if (com instanceof SrTextField) {
            String myLbl = (String)this.getValue();
            String comLbl = (String)com.getValue();
            answer = myLbl.compareTo(comLbl);
        }
        return answer;
    }

    public void setEnabledToolTip(String tip) {
        this.m_enabledtoolTip = tip;
    }

    public void setDisabledToolTip(String tip) {
        this.m_disabledtoolTip = tip;
    }

    public String getEnabledToolTip() {
        return this.m_enabledtoolTip;
    }

    public String getDisabledToolTip() {
        return this.m_disabledtoolTip;
    }

    public void setToolTip(boolean enabled) {
        String toolTip = enabled ? this.getEnabledToolTip() : this.getDisabledToolTip();
        this.setToolTipText(toolTip);
    }

    public void setEnabled(boolean enabled) {
        this.setToolTip(enabled);
        super.setEnabled(enabled);
    }
}

