/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.components.SrComponent;
import java.awt.Component;
import java.awt.event.FocusListener;
import java.util.EventListener;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class SrTextAreaField
extends JScrollPane
implements SrComponent {
    private JTextArea m_textArea;
    private String m_enabledtoolTip = null;
    private String m_disabledtoolTip = null;

    public SrTextAreaField() {
        this(8, 10);
        this.init();
    }

    public SrTextAreaField(String text) {
        this(null, text, 8, 10);
        this.init();
    }

    public SrTextAreaField(int rows, int columns) {
        this(null, "", rows, columns);
        this.init();
    }

    public SrTextAreaField(String text, int rows, int columns) {
        this(null, text, rows, columns);
        this.init();
    }

    public SrTextAreaField(Document doc) {
        this(doc, "", 8, 10);
        this.init();
    }

    public SrTextAreaField(Document doc, String text, int rows, int columns) {
        this.m_textArea = new JTextArea(doc, text, rows, columns);
        this.m_textArea.setFont(LookAndFill.GENERAL_FONT);
        this.setViewportView(this.m_textArea);
    }

    private void init() {
        this.setFont(LookAndFill.GENERAL_FONT);
    }

    public JTextArea getTextArea() {
        return this.m_textArea;
    }

    public Object getValue() {
        return this.m_textArea.getText();
    }

    public void setValue(Object value) {
        this.m_textArea.setText((String)value);
    }

    public Component getComponent() {
        return this;
    }

    public void setEnableComponent(boolean enable) {
        this.setEnabled(enable);
        this.m_textArea.setEditable(enable);
        this.m_textArea.setEnabled(enable);
    }

    public boolean isComponentEnabled() {
        return this.isEnabled();
    }

    public boolean isComponentValid() {
        boolean valid = false;
        String txt = this.m_textArea.getText();
        if (txt != null && txt.length() > 0) {
            valid = true;
        }
        return valid;
    }

    public void addComponentFocusListener(FocusListener fl) {
        this.m_textArea.addFocusListener(fl);
    }

    public void addComponentValidListener(EventListener l) {
        if (l instanceof DocumentListener) {
            this.m_textArea.getDocument().addDocumentListener((DocumentListener)l);
        }
    }

    public void removeComponentFocusListener(FocusListener fl) {
        this.m_textArea.removeFocusListener(fl);
    }

    public void removeComponentValidListener(EventListener l) {
        if (l instanceof DocumentListener) {
            this.m_textArea.getDocument().removeDocumentListener((DocumentListener)l);
        }
    }

    public int compareTo(SrComponent com) {
        int answer = -1;
        if (com instanceof SrTextAreaField) {
            String myLbl = (String)this.getValue();
            String comLbl = (String)com.getValue();
            answer = myLbl.compareTo(comLbl);
        }
        return answer;
    }

    public void setEnabledToolTip(String tip) {
        this.m_enabledtoolTip = tip;
    }

    public void setDisabledToolTip(String tip) {
        this.m_disabledtoolTip = tip;
    }

    public String getEnabledToolTip() {
        return this.m_enabledtoolTip;
    }

    public String getDisabledToolTip() {
        return this.m_disabledtoolTip;
    }

    public void setToolTip(boolean enabled) {
        String toolTip = enabled ? this.getEnabledToolTip() : this.getDisabledToolTip();
        this.setToolTipText(toolTip);
    }

    public void setEnabled(boolean enabled) {
        this.setToolTip(enabled);
        super.setEnabled(enabled);
    }

    public void setLineWrap(boolean wrap) {
        this.m_textArea.setLineWrap(wrap);
        this.m_textArea.setWrapStyleWord(wrap);
    }

    public void setEditable(boolean editable) {
        this.m_textArea.setEditable(editable);
    }
}

