/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrRadioButton;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class SrRadioButtonsPanel
extends JPanel
implements SrComponent {
    private ButtonGroup m_bttGroup = new ButtonGroup();
    private boolean m_firstBtt = true;

    public SrRadioButtonsPanel() {
        super(new FlowLayout(0));
    }

    public void addRadio(String des) {
        SrRadioButton radio = new SrRadioButton(des);
        if (this.m_firstBtt) {
            radio.setSelected(this.m_firstBtt);
            this.m_firstBtt = false;
        }
        this.m_bttGroup.add(radio);
        this.add(radio);
    }

    public void setTitle(String title) {
        this.setBorder(new TitledBorder(null, title, 0, 0, LookAndFill.GENERAL_FONT));
    }

    public void removeRadio(String des) {
        SrRadioButton foundBtt = null;
        Enumeration<AbstractButton> enumeration = this.m_bttGroup.getElements();
        while (enumeration.hasMoreElements()) {
            SrRadioButton radio = (SrRadioButton)enumeration.nextElement();
            String name = radio.getText();
            if (!name.equals(des)) continue;
            foundBtt = radio;
            break;
        }
        if (foundBtt != null) {
            this.m_bttGroup.remove(foundBtt);
            this.remove(foundBtt);
        }
    }

    public Object getValue() {
        String answer = null;
        Enumeration<AbstractButton> enumeration = this.m_bttGroup.getElements();
        while (enumeration.hasMoreElements()) {
            SrRadioButton radio = (SrRadioButton)enumeration.nextElement();
            if (!radio.isSelected()) continue;
            answer = radio.getText();
            break;
        }
        return answer;
    }

    public void setValue(Object value) {
        Enumeration<AbstractButton> enumeration = this.m_bttGroup.getElements();
        while (enumeration.hasMoreElements()) {
            SrRadioButton radio = (SrRadioButton)enumeration.nextElement();
            if (!value.equals(radio.getText())) continue;
            radio.setSelected(true);
            this.m_bttGroup.setSelected(this.m_bttGroup.getSelection(), true);
        }
    }

    public Component getComponent() {
        return this;
    }

    public void setEnableComponent(boolean enable) {
        Enumeration<AbstractButton> enumeration = this.m_bttGroup.getElements();
        while (enumeration.hasMoreElements()) {
            SrRadioButton radio = (SrRadioButton)enumeration.nextElement();
            radio.setEnabled(enable);
        }
    }

    public boolean isComponentEnabled() {
        return ((SrRadioButton)this.m_bttGroup.getElements().nextElement()).isEnabled();
    }

    public boolean isComponentValid() {
        return true;
    }

    public void addComponentFocusListener(FocusListener fl) {
        Enumeration<AbstractButton> enumeration = this.m_bttGroup.getElements();
        while (enumeration.hasMoreElements()) {
            SrRadioButton radio = (SrRadioButton)enumeration.nextElement();
            radio.addComponentFocusListener(fl);
        }
    }

    public void addComponentValidListener(EventListener l) {
        Enumeration<AbstractButton> enumeration = this.m_bttGroup.getElements();
        while (enumeration.hasMoreElements()) {
            SrRadioButton radio = (SrRadioButton)enumeration.nextElement();
            radio.addComponentValidListener(l);
        }
    }

    public void removeComponentFocusListener(FocusListener fl) {
        Enumeration<AbstractButton> enumeration = this.m_bttGroup.getElements();
        while (enumeration.hasMoreElements()) {
            SrRadioButton radio = (SrRadioButton)enumeration.nextElement();
            radio.removeComponentFocusListener(fl);
        }
    }

    public void removeComponentValidListener(EventListener l) {
        Enumeration<AbstractButton> enumeration = this.m_bttGroup.getElements();
        while (enumeration.hasMoreElements()) {
            SrRadioButton radio = (SrRadioButton)enumeration.nextElement();
            radio.removeComponentValidListener(l);
        }
    }

    public int compareTo(SrComponent com) {
        int answer = -1;
        if (com instanceof SrRadioButtonsPanel) {
            String myLbl = (String)this.getValue();
            String comLbl = (String)com.getValue();
            answer = myLbl.compareTo(comLbl);
        }
        return answer;
    }

    public String getDisabledToolTip() {
        return null;
    }

    public String getEnabledToolTip() {
        return null;
    }

    public void setDisabledToolTip(String tip) {
    }

    public void setEnabledToolTip(String tip) {
    }

    public void setToolTip(boolean enabled) {
    }
}

