/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusListener;
import java.util.EventListener;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeListener;

public class SrRadioButton
extends JRadioButton
implements SrComponent {
    private String m_enabledtoolTip = null;
    private String m_disabledtoolTip = null;

    public SrRadioButton() {
        this.init();
    }

    public SrRadioButton(String text) {
        this();
        this.setText(text);
    }

    public SrRadioButton(Action act) {
        this();
        this.setAction(act);
    }

    protected void init() {
        this.setFont(Font.decode(SrResourceBundle.getInstance((String)"defaultUI", (Locale)Locale.US).getString((BundleKeysInterface)SrDefaultUIBundleKeys.GENERAL_FONT)));
        this.setBackground(new Color(Integer.parseInt(SrResourceBundle.getInstance((String)"defaultUI", (Locale)Locale.US).getString((BundleKeysInterface)SrDefaultUIBundleKeys.DIALOG_COLOR))));
    }

    public Object getValue() {
        return Boolean.toString(this.isSelected());
    }

    public void setValue(Object value) {
        this.setSelected(Boolean.getBoolean((String)value));
    }

    public Component getComponent() {
        return this;
    }

    public void setEnableComponent(boolean enable) {
        this.setEnabled(enable);
    }

    public boolean isComponentEnabled() {
        return this.isEnabled();
    }

    public boolean isComponentValid() {
        return true;
    }

    public void addComponentFocusListener(FocusListener fl) {
        this.addFocusListener(fl);
    }

    public void addComponentValidListener(EventListener l) {
        if (l instanceof ChangeListener) {
            this.getModel().addChangeListener((ChangeListener)l);
        }
    }

    public void removeComponentFocusListener(FocusListener fl) {
        this.removeFocusListener(fl);
    }

    public void removeComponentValidListener(EventListener l) {
        if (l instanceof ChangeListener) {
            this.getModel().removeChangeListener((ChangeListener)l);
        }
    }

    public int compareTo(SrComponent com) {
        int answer = -1;
        if (com instanceof SrRadioButton) {
            String myLbl = (String)this.getValue();
            String comLbl = (String)com.getValue();
            answer = myLbl.compareTo(comLbl);
        }
        return answer;
    }

    public void setEnabledToolTip(String tip) {
        this.m_enabledtoolTip = tip;
    }

    public void setDisabledToolTip(String tip) {
        this.m_disabledtoolTip = tip;
    }

    public String getEnabledToolTip() {
        return this.m_enabledtoolTip;
    }

    public String getDisabledToolTip() {
        return this.m_disabledtoolTip;
    }

    public void setToolTip(boolean enabled) {
        String toolTip = enabled ? this.getEnabledToolTip() : this.getDisabledToolTip();
        this.setToolTipText(toolTip);
    }

    public void setEnabled(boolean enabled) {
        this.setToolTip(enabled);
        super.setEnabled(enabled);
    }
}

