/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.swing.components.SrLengthLimitedTextField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.swing.text.LengthLimitedDocument;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventListener;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentListener;

public class SrMultiTextField
extends JPanel
implements SrComponent {
    protected String delimiter;
    protected String[] delimiters;
    protected SrLabelField[] delimiterLabels;
    protected SrTextField[] textFields;
    private String m_enabledtoolTip = null;
    private String m_disabledtoolTip = null;

    public SrMultiTextField(SrTextField[] textFields, String delimiter) {
        this(delimiter);
        this.initMultiTextFields(textFields);
        this.initDelimitersWithSingleDelimiter(delimiter);
    }

    public SrMultiTextField(SrTextField[] textFields, String[] delimiters) {
        this("\t");
        this.delimiters = new String[textFields.length];
        int i = 0;
        while (i < textFields.length) {
            this.delimiters[i] = i < delimiters.length ? delimiters[i] : "";
            ++i;
        }
        this.initMultiTextFields(textFields);
    }

    protected SrMultiTextField(String delimiter) {
        this.delimiter = delimiter;
        this.setLayout(new FlowLayout(0, 1, 0));
    }

    public void addNotify() {
        Container parent = this.getParent();
        this.setBackground(parent.getBackground());
        super.addNotify();
    }

    protected void initMultiTextFields(SrTextField[] textFields) {
        this.textFields = textFields;
        if (this.delimiters == null) {
            this.initDelimitersWithSingleDelimiter(this.delimiter);
        }
        this.delimiterLabels = new SrLabelField[textFields.length];
        int i = 0;
        while (i < textFields.length) {
            if (i < this.delimiterLabels.length) {
                this.delimiterLabels[i] = new SrLabelField(this.delimiters[i]);
                this.add((Component)this.delimiterLabels[i], null);
            }
            textFields[i].addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    SrMultiTextField.this.textField_keyReleased(e);
                }
            });
            this.add((Component)textFields[i], null);
            ++i;
        }
    }

    private void initDelimitersWithSingleDelimiter(String delimiter) {
        this.delimiters = new String[this.textFields.length];
        this.delimiters[0] = "";
        int i = this.delimiters.length;
        while (i-- > 1) {
            this.delimiters[i] = delimiter;
        }
    }

    private int getFocusedTextFieldIndex() {
        int i = 0;
        while (i < this.textFields.length) {
            if (this.textFields[i].hasFocus()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void setFocusToNextTextField() {
        int nextFocusIndex = this.getFocusedTextFieldIndex() + 1;
        if (nextFocusIndex < this.textFields.length) {
            this.textFields[nextFocusIndex].requestFocus();
        }
    }

    private void textField_keyReleased(KeyEvent e) {
        if (!e.isActionKey() && e.getKeyCode() != 16) {
            LengthLimitedDocument document;
            int maxLength;
            if (String.valueOf(e.getKeyChar()).equals(this.delimiter)) {
                if (!this.textFields[this.getFocusedTextFieldIndex()].getText().equals("")) {
                    this.setFocusToNextTextField();
                }
            } else if (this.textFields[this.getFocusedTextFieldIndex()] instanceof SrLengthLimitedTextField && (maxLength = (document = (LengthLimitedDocument)this.textFields[this.getFocusedTextFieldIndex()].getDocument()).getLimit()) != -1 && maxLength == this.textFields[this.getFocusedTextFieldIndex()].getText().length()) {
                this.setFocusToNextTextField();
            }
        }
    }

    public void setText(String text) {
        StringTokenizer fullText = new StringTokenizer(text, this.delimiter);
        int i = 0;
        while (fullText.hasMoreElements()) {
            String textField = (String)fullText.nextElement();
            this.textFields[i++].setText(textField);
        }
    }

    public String getText() {
        StringBuffer fullText = new StringBuffer();
        if (this.isTextSet()) {
            int i = 0;
            while (i < this.textFields.length) {
                if (i < this.delimiters.length) {
                    fullText.append(this.delimiters[i]);
                }
                fullText.append(this.textFields[i].getText());
                ++i;
            }
        }
        return fullText.toString();
    }

    public String getText(int fieldIndex) {
        return this.textFields[fieldIndex].getText();
    }

    protected int getFirstEmptyIndex() {
        int i = 0;
        while (i < this.textFields.length) {
            if (this.textFields[i].getText().trim().equals("")) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void requestFocus() {
        int index = this.getFirstEmptyIndex();
        if (index < 0) {
            index = 0;
        }
        this.textFields[index].requestFocus();
    }

    protected boolean isTextSet() {
        return this.getFirstEmptyIndex() < 0;
    }

    public boolean isTextSetCorrectly() {
        int i = 0;
        while (i < this.textFields.length) {
            if (!this.textFields[i].getText().trim().equals("")) {
                return this.isTextSet();
            }
            ++i;
        }
        return true;
    }

    public void setBackground(Color color) {
        if (this.delimiterLabels != null) {
            int i = 0;
            while (i < this.delimiterLabels.length) {
                this.delimiterLabels[i].setBackground(color);
                ++i;
            }
        }
    }

    public void setForeground(Color color) {
        int i;
        if (this.textFields != null) {
            i = 0;
            while (i < this.textFields.length) {
                this.textFields[i].setForeground(color);
                ++i;
            }
        }
        if (this.delimiterLabels != null) {
            i = 0;
            while (i < this.delimiterLabels.length) {
                this.delimiterLabels[i].setForeground(color);
                ++i;
            }
        }
    }

    public void setFont(Font font) {
        int i;
        if (this.textFields != null) {
            i = 0;
            while (i < this.textFields.length) {
                this.textFields[i].setFont(font);
                ++i;
            }
        }
        if (this.delimiterLabels != null) {
            i = 0;
            while (i < this.delimiterLabels.length) {
                this.delimiterLabels[i].setFont(font);
                ++i;
            }
        }
    }

    public void setEditable(boolean enable) {
        if (this.textFields != null) {
            int i = 0;
            while (i < this.textFields.length) {
                this.textFields[i].setEditable(enable);
                ++i;
            }
        }
    }

    public void setEnabled(boolean enable) {
        int i;
        if (this.textFields != null) {
            i = 0;
            while (i < this.textFields.length) {
                this.textFields[i].setEnabled(enable);
                ++i;
            }
        }
        if (this.delimiterLabels != null) {
            i = 0;
            while (i < this.delimiterLabels.length) {
                this.delimiterLabels[i].setEnabled(enable);
                ++i;
            }
        }
    }

    public Object getValue() {
        return this.getText();
    }

    public void setValue(Object value) {
        this.setText((String)value);
    }

    public Component getComponent() {
        return this;
    }

    public void setEnableComponent(boolean enable) {
        int i = 0;
        while (i < this.textFields.length) {
            SrTextField txt = this.textFields[i];
            ((JComponent)txt).setEnabled(enable);
            ++i;
        }
    }

    public boolean isComponentEnabled() {
        return this.textFields[0].isEnabled();
    }

    public boolean isComponentValid() {
        boolean valid = true;
        int i = 0;
        while (i < this.textFields.length) {
            SrTextField srComp = this.textFields[i];
            if (!srComp.isComponentValid()) {
                valid = false;
                break;
            }
            ++i;
        }
        return valid;
    }

    public void addComponentFocusListener(FocusListener fl) {
        int i = 0;
        while (i < this.textFields.length) {
            SrTextField txt = this.textFields[i];
            txt.addFocusListener(fl);
            ++i;
        }
    }

    public void addComponentValidListener(EventListener l) {
        if (l instanceof DocumentListener) {
            int i = 0;
            while (i < this.textFields.length) {
                SrTextField txt = this.textFields[i];
                txt.getDocument().addDocumentListener((DocumentListener)l);
                ++i;
            }
        }
    }

    public void removeComponentFocusListener(FocusListener fl) {
        int i = 0;
        while (i < this.textFields.length) {
            SrTextField txt = this.textFields[i];
            txt.removeFocusListener(fl);
            ++i;
        }
    }

    public void removeComponentValidListener(EventListener l) {
        if (l instanceof DocumentListener) {
            int i = 0;
            while (i < this.textFields.length) {
                SrTextField txt = this.textFields[i];
                txt.getDocument().removeDocumentListener((DocumentListener)l);
                ++i;
            }
        }
    }

    public int compareTo(SrComponent com) {
        int answer = -1;
        if (com instanceof SrMultiTextField) {
            String myLbl = (String)this.getValue();
            String comLbl = (String)com.getValue();
            answer = myLbl.compareTo(comLbl);
        }
        return answer;
    }

    public void setEnabledToolTip(String tip) {
        this.m_enabledtoolTip = tip;
    }

    public void setDisabledToolTip(String tip) {
        this.m_disabledtoolTip = tip;
    }

    public String getEnabledToolTip() {
        return this.m_enabledtoolTip;
    }

    public String getDisabledToolTip() {
        return this.m_disabledtoolTip;
    }

    public void setToolTip(boolean enabled) {
    }
}

