/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.swing.text.LengthLimitedDocument;
import java.awt.Component;
import java.awt.event.FocusListener;
import java.util.EventListener;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class SrLengthLimitedTextField
extends SrTextField
implements SrComponent {
    protected static final int MAX_COLUMN_NUMBER = 25;
    protected int limit;

    public SrLengthLimitedTextField() {
        this(-1);
    }

    public SrLengthLimitedTextField(int limit) {
        this.setLimit(limit);
        this.init();
    }

    public void setLimit(int limit) {
        if (limit > 25) {
            this.setColumns(25);
        } else if (limit == -1) {
            this.setColumns(10);
        } else {
            this.setColumns(limit);
        }
        this.limit = limit;
        this.setDocument();
    }

    protected void init() {
        this.setFont(LookAndFill.GENERAL_FONT);
    }

    protected void setDocument() {
        this.setDocument(new LengthLimitedDocument(this.limit));
    }

    public Object getValue() {
        return this.getText();
    }

    public void setValue(Object value) {
        try {
            Document doc = this.getDocument();
            doc.remove(0, doc.getLength());
            doc.insertString(0, (String)value, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public Component getComponent() {
        return this;
    }

    public void setEnableComponent(boolean enable) {
        this.setEnabled(enable);
    }

    public boolean isComponentEnabled() {
        return this.isEnabled();
    }

    public boolean isComponentValid() {
        boolean valid = false;
        String txt = this.getText();
        if (txt != null && txt.length() > 0) {
            valid = true;
        }
        return valid;
    }

    public void addComponentFocusListener(FocusListener fl) {
        this.addFocusListener(fl);
    }

    public void addComponentValidListener(EventListener l) {
        if (l instanceof DocumentListener) {
            this.getDocument().addDocumentListener((DocumentListener)l);
        }
    }

    public void removeComponentFocusListener(FocusListener fl) {
        this.removeFocusListener(fl);
    }

    public void removeComponentValidListener(EventListener l) {
        if (l instanceof DocumentListener) {
            this.getDocument().removeDocumentListener((DocumentListener)l);
        }
    }

    public int compareTo(SrComponent com) {
        int answer = -1;
        if (com instanceof SrLengthLimitedTextField) {
            String myLbl = (String)this.getValue();
            String comLbl = (String)com.getValue();
            answer = myLbl.compareTo(comLbl);
        }
        return answer;
    }
}

