/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrResourceBundle;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JLabel;

public class SrLabelField
extends JLabel
implements SrComponent {
    private static final String START_HTML = "<html><body>";
    private static final String END_HTML = "</body></html>";
    private String m_enabledtoolTip = null;
    private String m_disabledtoolTip = null;
    private boolean m_htmlMode = true;

    public SrLabelField(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.init();
    }

    public SrLabelField(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.init();
    }

    public SrLabelField(String text) {
        super(text);
        this.init();
    }

    public SrLabelField(Icon icon, int horizontalAlignment) {
        super(icon, horizontalAlignment);
        this.init();
    }

    public SrLabelField(Icon icon) {
        super(icon);
        this.init();
    }

    public SrLabelField() {
        this("");
    }

    protected void init() {
        this.setFont(Font.decode(SrResourceBundle.getInstance((String)"defaultUI", (Locale)Locale.US).getString((BundleKeysInterface)SrDefaultUIBundleKeys.LABEL_FONT)));
    }

    public void setText(String text) {
        if (text != null) {
            if (this.m_htmlMode) {
                text = text.replaceAll("\n", "<br>");
                super.setText(START_HTML + text + END_HTML);
            } else {
                super.setText(text);
            }
        } else {
            super.setText("");
        }
    }

    public void setHtmlMode(boolean isHTMLMode) {
        String prevText = this.getValue().toString();
        this.m_htmlMode = isHTMLMode;
        this.setText(prevText);
    }

    public boolean isHTMLMode() {
        return this.m_htmlMode;
    }

    public Object getValue() {
        String text = null;
        StringBuffer textBuffer = new StringBuffer(super.getText());
        int indexOfHtmlStartTag = textBuffer.indexOf(START_HTML);
        int indexOfHtmlEndTag = textBuffer.indexOf(END_HTML);
        if (indexOfHtmlStartTag == 0 && indexOfHtmlEndTag + END_HTML.length() == textBuffer.length()) {
            textBuffer.delete(indexOfHtmlEndTag, textBuffer.length());
            textBuffer.delete(0, START_HTML.length());
            text = textBuffer.toString().replaceAll("<br>", "\n");
        } else {
            text = super.getText();
        }
        return text;
    }

    public void setValue(Object value) {
        this.setText(value.toString());
    }

    public Component getComponent() {
        return this;
    }

    public void setEnableComponent(boolean enable) {
        this.setEnabled(enable);
    }

    public boolean isComponentEnabled() {
        return this.isEnabled();
    }

    public boolean isComponentValid() {
        return true;
    }

    public void addComponentFocusListener(FocusListener fl) {
        this.addFocusListener(fl);
    }

    public void addComponentValidListener(EventListener l) {
        if (l instanceof PropertyChangeListener) {
            this.addPropertyChangeListener((PropertyChangeListener)l);
        }
    }

    public void removeComponentFocusListener(FocusListener fl) {
        this.removeFocusListener(fl);
    }

    public void removeComponentValidListener(EventListener l) {
        if (l instanceof PropertyChangeListener) {
            this.removePropertyChangeListener((PropertyChangeListener)l);
        }
    }

    public int compareTo(SrComponent com) {
        int answer = -1;
        if (com instanceof SrLabelField) {
            String myLbl = (String)this.getValue();
            String comLbl = (String)com.getValue();
            answer = myLbl.compareTo(comLbl);
        }
        return answer;
    }

    public void setEnabledToolTip(String tip) {
        this.m_enabledtoolTip = tip;
    }

    public void setDisabledToolTip(String tip) {
        this.m_disabledtoolTip = tip;
    }

    public String getEnabledToolTip() {
        return this.m_enabledtoolTip;
    }

    public String getDisabledToolTip() {
        return this.m_disabledtoolTip;
    }

    public void setToolTip(boolean enabled) {
        String toolTip = enabled ? this.getEnabledToolTip() : this.getDisabledToolTip();
        this.setToolTipText(toolTip);
    }

    public void setEnabled(boolean enabled) {
        this.setToolTip(enabled);
        super.setEnabled(enabled);
    }
}

