/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.components.SrLengthLimitedTextField;
import com.sanrad.swing.text.IntegerDocument;
import javax.swing.event.DocumentListener;

public class SrIntegerTextField
extends SrLengthLimitedTextField {
    private int minValue = 0;

    public SrIntegerTextField() {
        this.init();
    }

    public SrIntegerTextField(int length) {
        super(length);
        this.init();
    }

    public SrIntegerTextField(int length, int maxValue) {
        this(length);
        this.setMaxValue(maxValue);
    }

    public SrIntegerTextField(int length, int minValue, int maxValue) {
        this(length, maxValue);
        this.minValue = minValue;
    }

    protected void setDocument() {
        this.setDocument(new IntegerDocument(this.limit));
    }

    public void setMaxValue(int maxLimit) {
        ((IntegerDocument)this.getDocument()).setMaxValue(maxLimit);
    }

    public void setMinValue(int minLimit) {
        ((IntegerDocument)this.getDocument()).setMinValue(minLimit);
    }

    public void setDocumentListener(DocumentListener listener) {
        this.getDocument().addDocumentListener(listener);
    }

    public int intValue() {
        return Integer.parseInt(this.getText());
    }

    public boolean isComponentValid() {
        String txt = this.getText();
        return txt != null && txt.length() > 0 && Integer.parseInt(txt) >= this.minValue;
    }
}

