/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.components.SrIntegerTextField;
import com.sanrad.swing.components.SrMultiTextField;
import com.sanrad.swing.components.SrTextField;

public class SrIPTextField
extends SrMultiTextField {
    private static final int MAX_FIELD_LIMIT = 255;
    private static final int IP_VER4 = 4;
    private static final int MAX_DIGITS_PER_FIELD = 3;
    private static final String IP_DELIMITER = ".";

    public SrIPTextField() {
        super(IP_DELIMITER);
        SrTextField[] textFields = new SrIntegerTextField[4];
        int i = 0;
        while (i < 4) {
            textFields[i] = new SrIntegerTextField(3){

                public String getText() {
                    String text = super.getText();
                    while (text.length() > 1 && text.startsWith("0")) {
                        text = text.substring(1);
                    }
                    return text;
                }
            };
            ((SrIntegerTextField)textFields[i]).setMaxValue(255);
            ++i;
        }
        this.initMultiTextFields(textFields);
        this.initView();
    }

    protected void initView() {
        this.setFont(LookAndFill.GENERAL_FONT);
    }

    public boolean isComponentValid() {
        boolean valid = true;
        int i = 0;
        while (i < this.textFields.length) {
            SrTextField txt = this.textFields[i];
            String str = txt.getText();
            if (str == null) {
                valid = false;
                break;
            }
            ++i;
        }
        return valid;
    }
}

