/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.components.SrHexTextField;
import com.sanrad.swing.components.SrMultiTextField;
import com.sanrad.swing.components.SrTextField;

public class SrHexAddressTextField
extends SrMultiTextField {
    private static final int MAX_DIGITS_PER_FIELD = 2;
    private static final int NUM_OF_FIELDS = 8;
    private static final String DELIMITER = ":";

    public SrHexAddressTextField() {
        super(DELIMITER);
        SrTextField[] textFields = new SrHexTextField[8];
        int i = 0;
        while (i < 8) {
            SrHexTextField txt = new SrHexTextField(2);
            textFields[i] = txt;
            ++i;
        }
        this.initMultiTextFields(textFields);
    }

    public String getText(String delimiter) {
        String hex = "";
        if (this.isTextSet()) {
            int i = 0;
            while (i < this.textFields.length) {
                String text = this.textFields[i].getText();
                hex = String.valueOf(hex) + (text.length() == 1 ? "0" + text : text);
                hex = String.valueOf(hex) + (i < this.textFields.length - 1 ? delimiter : "");
                ++i;
            }
        }
        return hex;
    }

    public String getText() {
        return this.getText(this.delimiter);
    }

    public String toHexString() {
        return this.getText("");
    }

    public boolean isComponentValid() {
        boolean valid = true;
        int i = 0;
        while (i < this.textFields.length) {
            SrTextField txt = this.textFields[i];
            String str = txt.getText();
            if (str == null || str.length() < 2) {
                valid = false;
                break;
            }
            ++i;
        }
        return valid;
    }

    public byte[] getBytes() {
        byte[] ret = new byte[this.textFields.length];
        int i = 0;
        while (i < this.textFields.length) {
            int fieldVal = ((SrHexTextField)this.textFields[i]).intValue();
            ret[i] = fieldVal < 128 ? (byte)fieldVal : (byte)(fieldVal - 256);
            ++i;
        }
        return ret;
    }
}

