/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrComboSetPanel;
import com.sanrad.swing.components.SrComponent;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JComboBox;

public class SrDateField
extends SrComboSetPanel {
    private JComboBox m_days;
    private JComboBox m_months;
    private JComboBox m_years;
    private String m_enabledtoolTip = null;
    private String m_disabledtoolTip = null;
    public static final String SEPARATOR = "-";
    public static final String[] DAYS = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
    public static final String[] MONTHS = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    public static final String[] YEARS = new String[]{"2004", "2005", "2006", "2007", "2008", "2009", "2010", "2011", "2012", "2013", "2014", "2015", "2016", "2017", "2018", "2019", "2020", "2021", "2022", "2023", "2024", "2025", "2026", "2027", "2028", "2029", "2030"};
    private static final Object[][] COMBO_VALUES = new String[][]{DAYS, MONTHS, YEARS};

    public SrDateField() {
        GregorianCalendar cal = new GregorianCalendar();
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        this.init(day, month, year);
    }

    public SrDateField(int day, int month, int year) {
        this.init(day, month, year);
    }

    private void init(int day, int month, int year) {
        this.getComboByIndex(0).setSelectedItem(this.getDayVal(day));
        this.getComboByIndex(1).setSelectedIndex(month);
        this.getComboByIndex(2).setSelectedItem(String.valueOf(year));
    }

    private String getDayVal(int val) {
        String str = String.valueOf(val);
        if (val < 10 && str.length() == 1) {
            str = "0" + str;
        }
        return str;
    }

    protected Object[][] getComboValues() {
        return COMBO_VALUES;
    }

    protected String getSeparator() {
        return SEPARATOR;
    }

    public int compareTo(SrComponent com) {
        int answer = -1;
        if (com instanceof SrDateField) {
            String myObj = (String)this.getValue();
            String[] ddmmyy = myObj.split(SEPARATOR);
            int month = this.getMonth(ddmmyy[1]);
            GregorianCalendar myCal = new GregorianCalendar(Integer.parseInt(ddmmyy[2]), month, Integer.parseInt(ddmmyy[0]));
            Date myDate = myCal.getTime();
            String comObj = (String)com.getValue();
            ddmmyy = comObj.split(SEPARATOR);
            month = this.getMonth(ddmmyy[1]);
            GregorianCalendar comCal = new GregorianCalendar(Integer.parseInt(ddmmyy[2]), month, Integer.parseInt(ddmmyy[0]));
            Date comDate = comCal.getTime();
            answer = myDate.compareTo(comDate);
        }
        return answer;
    }

    private int getMonth(String monthStr) {
        int month = -1;
        int i = 0;
        while (i < MONTHS.length) {
            if (monthStr.equals(MONTHS[i])) {
                month = i;
                break;
            }
            ++i;
        }
        return month;
    }

    public Object getValue() {
        SrComboBox day = (SrComboBox)this.m_combos.get(0);
        SrComboBox month = (SrComboBox)this.m_combos.get(1);
        SrComboBox year = (SrComboBox)this.m_combos.get(2);
        return SrDateField.getDateString((String)year.getSelectedItem(), (String)month.getSelectedItem(), (String)day.getSelectedItem());
    }

    public void setValue(Object value) {
        if (value instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)value);
            this.init(cal.get(5), cal.get(2), cal.get(1));
        } else {
            String newVal = ((String)value).trim();
            String[] arr = newVal.split(this.getSeparator());
            SrComboBox day = (SrComboBox)this.m_combos.get(0);
            SrComboBox month = (SrComboBox)this.m_combos.get(1);
            SrComboBox year = (SrComboBox)this.m_combos.get(2);
            month.setSelectedItem(arr[0]);
            day.setSelectedItem(arr[1]);
            year.setSelectedItem(arr[2]);
        }
    }

    public static String getDateString(String year, String month, String day) {
        StringBuffer buff = new StringBuffer();
        buff.append(month);
        buff.append(SEPARATOR);
        buff.append(day);
        buff.append(SEPARATOR);
        buff.append(year);
        return buff.toString();
    }

    public void setEnabledToolTip(String tip) {
        this.m_enabledtoolTip = tip;
    }

    public void setDisabledToolTip(String tip) {
        this.m_disabledtoolTip = tip;
    }

    public String getEnabledToolTip() {
        return this.m_enabledtoolTip;
    }

    public String getDisabledToolTip() {
        return this.m_disabledtoolTip;
    }

    public void setToolTip(boolean enabled) {
        String toolTip = enabled ? this.getEnabledToolTip() : this.getDisabledToolTip();
        this.setToolTipText(toolTip);
    }

    public void setEnabled(boolean enabled) {
        this.setToolTip(enabled);
        super.setEnabled(enabled);
    }

    public int[] getCurrentDateValue() {
        String myObj = (String)this.getValue();
        String[] ddmmyy = myObj.split(SEPARATOR);
        int month = this.getMonth(ddmmyy[0]);
        int[] myCal = new int[]{Integer.parseInt(ddmmyy[1]), month, Integer.parseInt(ddmmyy[2])};
        return myCal;
    }

    public void setDate(long date) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(date);
        this.init(c.get(5), c.get(2), c.get(1));
    }
}

