/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.SrPanel;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrLabelField;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.FocusListener;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.ListDataListener;

abstract class SrComboSetPanel
extends SrPanel
implements SrComponent {
    protected Vector m_combos;

    public SrComboSetPanel() {
        super(new FlowLayout(0, 0, 0));
        this.initComponents();
    }

    public SrComboBox getComboByIndex(int index) {
        SrComboBox combo = null;
        if (this.m_combos != null && index < this.m_combos.size()) {
            combo = (SrComboBox)this.m_combos.get(index);
        }
        return combo;
    }

    private void initComponents() {
        if (this.sanity()) {
            Object[][] comboValues = this.getComboValues();
            String separator = this.getSeparator();
            this.m_combos = new Vector(comboValues.length);
            int i = 0;
            while (i < comboValues.length) {
                SrComboBox combo = new SrComboBox(comboValues[i]);
                if (i < comboValues.length - 1) {
                    SrLabelField sep = new SrLabelField(separator);
                    this.add(combo);
                    this.add(sep);
                } else {
                    this.add(combo);
                }
                this.m_combos.add(combo);
                ++i;
            }
        }
    }

    protected Object[][] getComboValues() {
        return null;
    }

    protected String getSeparator() {
        return null;
    }

    private boolean sanity() {
        boolean ok = false;
        if (this.getSeparator() != null && this.getComboValues() != null && this.getComboValues().length > 1) {
            ok = true;
        }
        return ok;
    }

    public void setEnabled(boolean b) {
        this.setEnableComponent(b);
        super.setEnabled(b);
    }

    public Object getValue() {
        StringBuffer buff = new StringBuffer();
        Iterator iter = this.m_combos.iterator();
        while (iter.hasNext()) {
            SrComboBox element = (SrComboBox)iter.next();
            buff.append(element.getSelectedItem());
            if (!iter.hasNext()) continue;
            buff.append(this.getSeparator());
        }
        return buff.toString();
    }

    public void setValue(Object value) {
        String newVal = ((String)value).trim();
        String[] arr = newVal.split(this.getSeparator());
        if (arr.length == this.m_combos.size()) {
            int i = 0;
            while (i < arr.length) {
                SrComboBox combo = (SrComboBox)this.m_combos.get(i);
                combo.setSelectedItem(arr[i]);
                ++i;
            }
        }
    }

    public Component getComponent() {
        return this;
    }

    public void setEnableComponent(boolean enable) {
        Iterator iter = this.m_combos.iterator();
        while (iter.hasNext()) {
            SrComboBox element = (SrComboBox)iter.next();
            element.setEnableComponent(enable);
        }
    }

    public boolean isComponentEnabled() {
        return ((SrComboBox)this.m_combos.iterator().next()).isComponentEnabled();
    }

    public boolean isComponentValid() {
        return true;
    }

    public void addComponentFocusListener(FocusListener fl) {
        int i = 0;
        while (i < this.m_combos.size()) {
            SrComboBox combo = (SrComboBox)this.m_combos.get(i);
            combo.addFocusListener(fl);
            ++i;
        }
    }

    public void addComponentValidListener(EventListener l) {
        if (l instanceof ListDataListener) {
            int i = 0;
            while (i < this.m_combos.size()) {
                SrComboBox combo = (SrComboBox)this.m_combos.get(i);
                combo.getModel().addListDataListener((ListDataListener)l);
                ++i;
            }
        }
    }

    public void removeComponentFocusListener(FocusListener fl) {
        int i = 0;
        while (i < this.m_combos.size()) {
            SrComboBox combo = (SrComboBox)this.m_combos.get(i);
            combo.removeFocusListener(fl);
            ++i;
        }
    }

    public void removeComponentValidListener(EventListener l) {
        if (l instanceof ListDataListener) {
            int i = 0;
            while (i < this.m_combos.size()) {
                SrComboBox combo = (SrComboBox)this.m_combos.get(i);
                combo.getModel().removeListDataListener((ListDataListener)l);
                ++i;
            }
        }
    }

    public int compareTo(SrComponent com) {
        return 0;
    }

    public String getDisabledToolTip() {
        return null;
    }

    public String getEnabledToolTip() {
        return null;
    }

    public void setDisabledToolTip(String tip) {
    }

    public void setEnabledToolTip(String tip) {
    }

    public void setToolTip(boolean enabled) {
    }
}

