/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.components.SrComponent;
import java.awt.Component;
import java.awt.event.FocusListener;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.event.ListDataListener;

public class SrComboBox
extends JComboBox
implements SrComponent {
    private String m_enabledtoolTip = null;
    private String m_disabledtoolTip = null;

    public SrComboBox() {
        this.init();
    }

    public SrComboBox(Object[] items) {
        super(items);
        this.init();
    }

    public SrComboBox(Vector items) {
        super(items);
        this.init();
    }

    protected void init() {
        this.setFont(LookAndFill.GENERAL_FONT);
    }

    public Object getValue() {
        return this.getSelectedItem();
    }

    public void setValue(Object value) {
        this.setSelectedItem(value);
    }

    public Component getComponent() {
        return this;
    }

    public void setEnableComponent(boolean enable) {
        this.setEnabled(enable);
    }

    public boolean isComponentEnabled() {
        return this.isEnabled();
    }

    public boolean isComponentValid() {
        return true;
    }

    public void addComponentFocusListener(FocusListener fl) {
        this.addFocusListener(fl);
    }

    public void addComponentValidListener(EventListener l) {
        if (l instanceof ListDataListener) {
            this.getModel().addListDataListener((ListDataListener)l);
        }
    }

    public void removeComponentFocusListener(FocusListener fl) {
        this.removeFocusListener(fl);
    }

    public void removeComponentValidListener(EventListener l) {
        if (l instanceof ListDataListener) {
            this.getModel().removeListDataListener((ListDataListener)l);
        }
    }

    public int compareTo(SrComponent com) {
        int answer = -1;
        if (com instanceof SrComboBox) {
            Object mySel = this.getValue();
            Object compSel = com.getValue();
            if (mySel instanceof String && compSel instanceof String) {
                answer = ((String)mySel).compareTo((String)compSel);
            }
        }
        return answer;
    }

    public void setEnabledToolTip(String tip) {
        this.m_enabledtoolTip = tip;
    }

    public void setDisabledToolTip(String tip) {
        this.m_disabledtoolTip = tip;
    }

    public String getEnabledToolTip() {
        return this.m_enabledtoolTip;
    }

    public String getDisabledToolTip() {
        return this.m_disabledtoolTip;
    }

    public void setToolTip(boolean enabled) {
        String toolTip = enabled ? this.getEnabledToolTip() : this.getDisabledToolTip();
        this.setToolTipText(toolTip);
    }

    public void setEnabled(boolean enabled) {
        this.setToolTip(enabled);
        super.setEnabled(enabled);
    }
}

