/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing.components;

import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.components.SrComponent;
import java.awt.Component;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.JCheckBox;

public class SrCheckbox
extends JCheckBox
implements SrComponent {
    private String m_enabledtoolTip = null;
    private String m_disabledtoolTip = null;

    public SrCheckbox() {
        this.init();
    }

    public SrCheckbox(String name) {
        super(name);
        this.init();
    }

    protected void init() {
        this.setBackground(LookAndFill.DIALOG_COLOR);
        this.setFont(LookAndFill.GENERAL_FONT);
    }

    public Object getValue() {
        return String.valueOf(this.isSelected());
    }

    public void setValue(Object value) {
        boolean bool = false;
        bool = value instanceof Boolean ? (Boolean)value : Boolean.getBoolean((String)value);
        this.setSelected(bool);
    }

    public Component getComponent() {
        return this;
    }

    public void setEnableComponent(boolean enable) {
        this.setEnabled(enable);
    }

    public boolean isComponentEnabled() {
        return this.isEnabled();
    }

    public boolean isComponentValid() {
        return true;
    }

    public void addComponentFocusListener(FocusListener fl) {
        this.addFocusListener(fl);
    }

    public void addComponentValidListener(EventListener l) {
        if (l instanceof ItemListener) {
            this.addItemListener((ItemListener)l);
        }
    }

    public int compareTo(SrComponent com) {
        int answer = -1;
        if (com instanceof SrCheckbox) {
            String mySel = (String)this.getValue();
            String compSel = (String)com.getValue();
            answer = mySel.compareTo(compSel);
        }
        return answer;
    }

    public void removeComponentFocusListener(FocusListener fl) {
        this.removeFocusListener(fl);
    }

    public void removeComponentValidListener(EventListener l) {
        if (l instanceof ItemListener) {
            this.removeItemListener((ItemListener)l);
        }
    }

    public void setEnabledToolTip(String tip) {
        this.m_enabledtoolTip = tip;
    }

    public void setDisabledToolTip(String tip) {
        this.m_disabledtoolTip = tip;
    }

    public String getEnabledToolTip() {
        return this.m_enabledtoolTip;
    }

    public String getDisabledToolTip() {
        return this.m_disabledtoolTip;
    }

    public void setToolTip(boolean enabled) {
        String toolTip = enabled ? this.getEnabledToolTip() : this.getDisabledToolTip();
        this.setToolTipText(toolTip);
    }

    public void setEnabled(boolean enabled) {
        this.setToolTip(enabled);
        super.setEnabled(enabled);
    }
}

