/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.ImageObject;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.ToolBarListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class ToolBarPanel
extends JPanel {
    protected Vector listeners = new Vector();
    private static final Font font = LookAndFill.GENERAL_FONT;
    private static final Color foreGround = new Color(113, 131, 155);
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanel1 = new JPanel();
    private JPanel jPanel2 = new JPanel();
    private JLabel jLabel1 = new JLabel();
    private FlowLayout flowLayout1 = new FlowLayout();
    private FlowLayout flowLayout2 = new FlowLayout();

    public ToolBarPanel() {
        try {
            this.jbInit();
            this.addSeperator();
            this.jLabel1.setIcon(ImageObject.BORDER_LINE.getImageIcon());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setBackground(Color.white);
        this.jPanel2.setLayout(this.flowLayout1);
        this.jPanel2.setBackground(Color.white);
        this.flowLayout1.setAlignment(0);
        this.jPanel1.setLayout(this.flowLayout2);
        this.jPanel1.setBackground(Color.white);
        this.flowLayout2.setAlignment(0);
        this.add((Component)this.jPanel1, "North");
        this.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.jLabel1, null);
    }

    public void addToolBarListener(ToolBarListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeToolBarListener(ToolBarListener listener) {
        this.listeners.removeElement(listener);
    }

    private void addSeperator() {
        JLabel seperator = new JLabel();
        seperator.setIcon(ImageObject.TOOL_BAR_SEPERATOR.getImageIcon());
        this.jPanel1.add((Component)seperator, null);
    }

    protected void addSpace() {
        JLabel space = new JLabel();
        Dimension size = new Dimension(50, space.getPreferredSize().height);
        space.setPreferredSize(size);
        this.jPanel1.add((Component)space, null);
        this.addSeperator();
    }

    private void addButtonComponent(JComponent button) {
        button.setFont(font);
        button.setForeground(foreGround);
        button.setBackground(Color.WHITE);
        button.setCursor(new Cursor(12));
        this.jPanel1.add((Component)button, null);
        this.addSeperator();
    }

    protected void addButton(JLabel button, ImageIcon icon) {
        this.addButtonComponent(button);
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        button.setIcon(icon);
        button.setIconTextGap(0);
    }

    protected void addButton(JButton button, ImageIcon icon) {
        this.addButtonComponent(button);
        button.setVerticalTextPosition(3);
        button.setFocusPainted(false);
        button.setRequestFocusEnabled(false);
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setHorizontalTextPosition(0);
        button.setIcon(icon);
        button.setIconTextGap(0);
    }
}

