/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrScrollPane;
import com.sanrad.swing.SrTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public abstract class TableViewPanel
extends JPanel {
    private BorderLayout borderLayout2 = new BorderLayout();
    private SrScrollPane tableScrollPanel = new SrScrollPane();
    protected SrTablePanel m_tablePanel;
    private JPanel tableTitlePanel = new JPanel();
    private FlowLayout flowLayout1 = new FlowLayout();
    private JLabel tableTitleLabel = new JLabel();
    private String title;
    private JTable table = null;
    private JPanel totalLinesPanel = new JPanel();
    private FlowLayout flowLayout4 = new FlowLayout();
    private JLabel totalLinesLabel = new JLabel();
    private TableModelListener tableModelListener = null;
    protected ClusterNode m_workingCluster;

    protected TableViewPanel(String title) {
        this(title, null);
    }

    protected TableViewPanel(String title, ClusterNode workingCluster) {
        try {
            this.title = title;
            this.m_workingCluster = workingCluster;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout2);
        this.m_tablePanel = this.getTablePanel();
        if (this.m_tablePanel == null) {
            this.tableScrollPanel.getViewport().setBackground(LookAndFill.TABLE_SCROLL_BACKGROUND_COLOR);
            this.add((Component)this.tableScrollPanel, "Center");
        } else {
            this.add((Component)this.m_tablePanel, "Center");
        }
        this.tableTitlePanel.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.add((Component)this.tableTitlePanel, "North");
        this.tableTitlePanel.add((Component)this.tableTitleLabel, null);
        this.tableTitleLabel.setFont(LookAndFill.PANEL_TITLE_LABEL_FONT);
        this.tableTitleLabel.setForeground(LookAndFill.PANEL_TITLE_LABEL_FOREGROUND);
        this.tableTitleLabel.setText(this.title);
        this.totalLinesPanel.setLayout(this.flowLayout4);
        this.flowLayout4.setAlignment(0);
        this.add((Component)this.totalLinesPanel, "South");
        this.totalLinesPanel.add((Component)this.totalLinesLabel, null);
    }

    protected SrTablePanel getTablePanel() {
        return null;
    }

    protected void submitTablePanel() {
        this.setStatusMessage();
        this.addNewTableModelListener(this.m_tablePanel.getModel());
    }

    protected void addTable(JTable table) {
        this.table = table;
        this.setStatusMessage();
        this.addNewTableModelListener(table.getModel());
    }

    protected void removeOldTableModelListener() {
        if (this.tableModelListener != null) {
            if (this.m_tablePanel != null) {
                this.m_tablePanel.getModel().removeTableModelListener(this.tableModelListener);
            } else {
                this.table.getModel().removeTableModelListener(this.tableModelListener);
            }
            this.tableModelListener = null;
        }
    }

    protected void addNewTableModelListener(TableModel dataModel) {
        this.tableModelListener = new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                TableViewPanel.this.setStatusMessage();
                TableViewPanel.this.m_tablePanel.tableChanged(e);
            }
        };
        dataModel.addTableModelListener(this.tableModelListener);
    }

    public JTable getTable() {
        if (this.table != null) {
            return this.table;
        }
        return this.m_tablePanel.getTable();
    }

    public SrTablePanel getCurrentTablePanel() {
        return this.m_tablePanel;
    }

    private void setStatusMessage() {
        if (this.m_tablePanel != null) {
            this.totalLinesLabel.setFont(LookAndFill.STATUSBAR_LABEL_FONT);
            this.totalLinesLabel.setForeground(LookAndFill.STATUSBAR_LABEL_FOREGROUND);
            this.totalLinesLabel.setText("Total " + this.m_tablePanel.getTable().getRowCount() + " items");
        }
    }
}

