/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.ImageObject;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrComponentStatusBarInterface;
import com.sanrad.swing.components.SrLabelField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StatusPanel
extends JPanel {
    private static StatusPanel instance;
    private SrLabelField statusLabel;
    private JLabel constantStatusLabel;
    public static final String READY = "Ready";
    public static final String CONNECTING_TO_SERVER = "Connecting to server...";
    public static Level WARNING;
    public static Level INFO;
    public static Level ERROR;
    public static Level NO_INFO;
    private JLabel left;
    private JLabel mid;
    private JLabel right;
    private ImageIcon redIcon = ImageObject.RED_LIGHT.getImageIcon();
    private ImageIcon greenIcon = ImageObject.GREEN_LIGHT.getImageIcon();
    private ImageIcon grayIcon = ImageObject.GRAY_LIGHT.getImageIcon();
    private ImageIcon yellowIcon = ImageObject.YELLOW_LIGHT.getImageIcon();
    private static final String DIALOG_STATUS_START_ERROR_MSG_STRING = "<font color=red>";
    private static final String DIALOG_STATUS_END_ERROR_MSG_STRING = "</font>";

    private StatusPanel() {
        this.init();
        WARNING = new Level("WARNING", 0);
        INFO = new Level("INFO", 1);
        ERROR = new Level("ERROR", 2);
        NO_INFO = new Level("NO_INFO", 3);
    }

    private void init() {
        this.statusLabel = new SrLabelField();
        this.constantStatusLabel = new JLabel();
        this.setLayout(new BorderLayout(10, 0));
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusLabel.setFont(LookAndFill.STATUSBAR_LABEL_FONT);
        this.statusLabel.setForeground(LookAndFill.STATUSBAR_LABEL_FOREGROUND);
        this.constantStatusLabel.setFont(LookAndFill.STATUSBAR_LABEL_FONT);
        this.constantStatusLabel.setForeground(Color.RED);
        this.add((Component)this.statusLabel, "West");
        this.add((Component)this.constantStatusLabel, "Center");
        this.add((Component)this.initLightPanel(), "East");
    }

    private JPanel initLightPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        this.left = new JLabel(ImageObject.GRAY_LIGHT.getImageIcon());
        this.mid = new JLabel(ImageObject.GRAY_LIGHT.getImageIcon());
        this.right = new JLabel(ImageObject.GRAY_LIGHT.getImageIcon());
        panel.add(this.left);
        panel.add(this.mid);
        panel.add(this.right);
        return panel;
    }

    public static StatusPanel getInstance() {
        if (instance == null) {
            instance = new StatusPanel();
        }
        return instance;
    }

    public void setText(String msg, Level level, Object owner) {
        if (owner instanceof SrComponentStatusBarInterface) {
            this.setComponentStatusBar(msg, level, (SrComponentStatusBarInterface)owner);
        } else {
            this.setLevel(level);
            this.statusLabel.setText(msg);
            if (level.equals(ERROR)) {
                this.statusLabel.setForeground(Color.RED);
            } else {
                this.statusLabel.setForeground(Color.BLACK);
            }
        }
    }

    public void setText(String msg, Object owner) {
        this.setText(msg, NO_INFO, owner);
    }

    private void setComponentStatusBar(String msg, Level level, SrComponentStatusBarInterface owner) {
        owner.setStatusStr(this.buildStatusBarString(msg, level));
    }

    private String buildStatusBarString(String msg, Level level) {
        StringBuffer statusStr = new StringBuffer();
        if (level.equals(WARNING) || level.equals(ERROR)) {
            statusStr.append(DIALOG_STATUS_START_ERROR_MSG_STRING);
            statusStr.append(msg);
            statusStr.append(DIALOG_STATUS_END_ERROR_MSG_STRING);
        } else {
            statusStr.append(msg);
        }
        return statusStr.toString();
    }

    public String getStatusBarString() {
        String msg = null;
        msg = this.right.getIcon() == this.redIcon ? this.buildStatusBarString(this.statusLabel.getText(), ERROR) : this.buildStatusBarString(this.statusLabel.getText(), NO_INFO);
        return msg;
    }

    public void setConstantText(String msg) {
        this.constantStatusLabel.setText(msg);
    }

    public void setLevel(Level l) {
        if (l.equals(NO_INFO)) {
            this.left.setIcon(this.grayIcon);
            this.mid.setIcon(this.yellowIcon);
            this.right.setIcon(this.grayIcon);
        } else if (l.equals(INFO)) {
            this.left.setIcon(this.greenIcon);
            this.mid.setIcon(this.grayIcon);
            this.right.setIcon(this.grayIcon);
        } else if (l.equals(WARNING) || l.equals(ERROR)) {
            this.left.setIcon(this.grayIcon);
            this.mid.setIcon(this.grayIcon);
            this.right.setIcon(this.redIcon);
        }
    }

    public String getText() {
        return this.statusLabel.getText();
    }

    public void append(String msg) {
        this.statusLabel.setText(String.valueOf(this.statusLabel.getText()) + msg);
    }

    public class Level {
        private int id;
        private String level;

        private Level(String level, int id) {
            this.id = id;
            this.level = level;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Level) {
                return ((Level)obj).id == this.id;
            }
            return false;
        }

        public String toString() {
            return this.level;
        }
    }
}

