/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.SrPopupMenu;
import com.sanrad.swing.SrTree;
import com.sanrad.swing.SrTreeExpandSelectionRestorer;
import com.sanrad.swing.SrTreeModel;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrLabelField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SrTreePanel
extends JPanel {
    private JScrollPane m_treeView;
    protected SrTree m_tree;
    protected SrPopupMenu m_popup;
    private SrTreeMouseListener m_listener;
    private TreeSelectionListener m_selListener;

    public SrTreePanel(DefaultMutableTreeNode root) {
        this(new SrTreeModel(root));
    }

    public SrTreePanel(SrTreeModel model) {
        super(new BorderLayout());
        this.m_tree = this.getTreeInstance(model);
        this.m_tree.getSelectionModel().setSelectionMode(4);
        SrTreeExpandSelectionRestorer selExpRestorer = new SrTreeExpandSelectionRestorer((JTree)this.m_tree, SrTreeExpandSelectionRestorer.SELECTION_BY_ROW);
        model.setSelectionExpandRestorer(selExpRestorer);
        this.m_selListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent event) {
                SrTreePanel.this.onTreeSelectionEvent(event);
            }
        };
        this.m_tree.addTreeSelectionListener(this.m_selListener);
        this.m_listener = new SrTreeMouseListener();
        this.m_tree.addMouseListener(this.m_listener);
        this.m_tree.setRootVisible(false);
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setInvokesStopCellEditing(true);
        this.m_treeView = new JScrollPane(this.m_tree);
        this.add((Component)this.m_treeView, "Center");
        this.m_tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.getModifiers() == 2 && e.getKeyCode() == 89) {
                    Rectangle cellBounds = SrTreePanel.this.m_tree.getPathBounds(SrTreePanel.this.m_tree.getSelectionPath());
                    MouseEvent mouseEvent = new MouseEvent(SrTreePanel.this.m_tree, 500, e.getWhen(), 0, cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2, 1, true, 3);
                    MouseListener[] listeners = SrTreePanel.this.m_tree.getMouseListeners();
                    int i = listeners.length;
                    while (i-- > 0) {
                        listeners[i].mouseReleased(mouseEvent);
                    }
                }
            }

            public void keyTyped(KeyEvent e) {
            }
        });
    }

    protected SrTree getTreeInstance(SrTreeModel model) {
        return new SrTree(model);
    }

    public JScrollPane getPanelScrollPane() {
        return this.m_treeView;
    }

    public SrTree getTreeObject() {
        return this.m_tree;
    }

    public SrTreeModel getTreeModel() {
        return (SrTreeModel)this.m_tree.getModel();
    }

    public void setTreePopupMenu(SrPopupMenu menu) {
        this.m_popup = menu;
    }

    public SrPopupMenu getTreePopupMenu() {
        return this.m_popup;
    }

    public TreePath[] getSelectionPaths() {
        return this.m_tree.getSelectionPaths();
    }

    public void setTreeSelection(int mode) {
        this.m_tree.getSelectionModel().setSelectionMode(mode);
    }

    public DefaultMutableTreeNode addNode(SrComponent newComponent, DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode newNode = this.addNode(newComponent, parent, parent.getChildCount());
        return newNode;
    }

    public DefaultMutableTreeNode addNode(SrComponent newComponent, DefaultMutableTreeNode parent, int position) {
        DefaultMutableTreeNode newNode = null;
        if (position >= 0 && position <= parent.getChildCount()) {
            newNode = new DefaultMutableTreeNode(newComponent);
            ((SrTreeModel)this.m_tree.getModel()).insertNodeInto(newNode, parent, position);
        }
        return newNode;
    }

    public void addTreeBranch(DefaultMutableTreeNode parentNode, Vector nodes, boolean insertAsSort, boolean sortAsc) {
        ((SrTreeModel)this.m_tree.getModel()).setSortAsc(sortAsc);
        ((SrTreeModel)this.m_tree.getModel()).addTreeBranch(parentNode, nodes, insertAsSort);
    }

    public void addTreeBranch(SrComponent parent, Vector nodes, boolean insertAsSort, boolean sortAsc) {
        ((SrTreeModel)this.m_tree.getModel()).setSortAsc(sortAsc);
        ((SrTreeModel)this.m_tree.getModel()).addTreeBranch(parent, nodes, insertAsSort);
    }

    public void clearTree() {
        ((SrTreeModel)this.m_tree.getModel()).setRoot(null);
    }

    public void removeNode(DefaultMutableTreeNode node) {
        if (node != null) {
            ((SrTreeModel)this.m_tree.getModel()).removeNodeFromParent(node);
        }
    }

    public void removeNode(SrComponent com) {
        DefaultMutableTreeNode parentNode = this.searchNode(com);
        if (parentNode != null) {
            ((SrTreeModel)this.m_tree.getModel()).removeNodeFromParent(parentNode);
        }
    }

    public void searchNode(SrComponent searchObj, Vector resultPaths) {
        ((SrTreeModel)this.m_tree.getModel()).searchNode(searchObj, resultPaths);
    }

    public void collapseTree() {
        this.m_tree.collapsePath(new TreePath(((SrTreeModel)this.m_tree.getModel()).getRoot()));
    }

    public void collapseTreeNode(TreePath path) {
        this.m_tree.collapsePath(path);
    }

    public void collapseTreeNode(SrComponent com) {
        Vector paths = new Vector();
        this.searchNode(com, paths);
        if (paths.size() > 0) {
            TreePath path = (TreePath)paths.get(0);
            this.collapseTreeNode(path);
        }
    }

    public void expandTree() {
        int row = 0;
        while (row < this.m_tree.getRowCount()) {
            this.m_tree.expandRow(row);
            ++row;
        }
    }

    public void expandAndSelectNode(SrComponent com) {
        Vector paths = new Vector();
        this.searchNode(com, paths);
        if (paths.size() > 0) {
            TreePath[] selects = new TreePath[paths.size()];
            int i = 0;
            this.m_tree.clearSelection();
            Iterator iter = paths.iterator();
            while (iter.hasNext()) {
                TreePath path = (TreePath)iter.next();
                this.m_tree.expandPath(path);
                TreePath savedPath = path;
                while ((path = path.getParentPath()) != null) {
                    this.m_tree.expandPath(path);
                }
                selects[i++] = savedPath;
            }
            this.m_tree.setSelectionPaths(selects);
        }
    }

    public void expandAndSelectNode(TreePath path) {
        this.m_tree.expandPath(path);
        this.m_tree.addSelectionPath(path);
    }

    public void rebuildTree() {
        TreePath[] paths = this.m_tree.getSelectionPaths();
        Enumeration<TreePath> enumeration = this.m_tree.getExpandedDescendants(new TreePath(((SrTreeModel)this.m_tree.getModel()).getRoot()));
        ((SrTreeModel)this.m_tree.getModel()).reload((DefaultMutableTreeNode)((SrTreeModel)this.m_tree.getModel()).getRoot());
        this.m_tree.setSelectionPaths(paths);
        while (enumeration.hasMoreElements()) {
            this.m_tree.expandPath(enumeration.nextElement());
        }
    }

    public DefaultMutableTreeNode searchNode(SrComponent com) {
        return ((SrTreeModel)this.m_tree.getModel()).searchNode(com);
    }

    public void insertInPosition(DefaultMutableTreeNode parent, DefaultMutableTreeNode newNode) {
        ((SrTreeModel)this.m_tree.getModel()).insertInPosition(parent, newNode);
    }

    public void sortTree(boolean sortAsc) {
        ((SrTreeModel)this.m_tree.getModel()).setSortAsc(sortAsc);
        ((SrTreeModel)this.m_tree.getModel()).sortTree();
    }

    public void sortBranch(DefaultMutableTreeNode parent, boolean sortAsc) {
        ((SrTreeModel)this.m_tree.getModel()).setSortAsc(sortAsc);
        ((SrTreeModel)this.m_tree.getModel()).sortBranch(parent);
    }

    public void sortBranch(SrComponent parent, boolean sortAsc) {
        ((SrTreeModel)this.m_tree.getModel()).setSortAsc(sortAsc);
        ((SrTreeModel)this.m_tree.getModel()).sortBranch(parent);
    }

    protected void onTreeSelectionEvent(TreeSelectionEvent event) {
    }

    public void reloadTree() {
        TreePath[] selectedpaths = this.m_tree.getSelectionPaths();
        this.getTreeModel().reload();
        this.expandTree();
        if (selectedpaths != null && selectedpaths.length > 0) {
            this.m_tree.setSelectionPaths(selectedpaths);
            this.m_tree.requestFocus();
        }
    }

    public TreePath[] getPaths() {
        TreeNode root = (TreeNode)this.m_tree.getModel().getRoot();
        ArrayList list = new ArrayList();
        this.getPaths(new TreePath(root), list);
        return list.toArray(new TreePath[list.size()]);
    }

    public void getPaths(TreePath parent, List list) {
        if (!this.m_tree.isVisible(parent)) {
            return;
        }
        list.add(parent);
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.getPaths(path, list);
            }
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Vector<Serializable> vec = new Vector<Serializable>();
        Vector<SrLabelField> vec1 = new Vector<SrLabelField>();
        Vector<SrLabelField> vec2 = new Vector<SrLabelField>();
        vec.add(new SrLabelField("10", new ImageIcon("D:/development/NewUI/config/up.gif"), 4));
        vec.add(new SrLabelField("9"));
        vec.add(new SrLabelField("8"));
        vec.add(vec1);
        vec1.add(new SrLabelField("7"));
        vec1.add(new SrLabelField("6"));
        vec1.add(new SrLabelField("5"));
        vec1.add(new SrLabelField("4"));
        vec.add(vec2);
        vec2.add(new SrLabelField("3"));
        vec2.add(new SrLabelField("2"));
        vec2.add(new SrLabelField("10"));
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new SrLabelField("root"));
        SrTreeModel model = new SrTreeModel(root, vec, true);
        final SrTreePanel pan = new SrTreePanel(model);
        pan.expandTree();
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)pan, "South");
        p.add(new JButton(new AbstractAction("Test"){

            public void actionPerformed(ActionEvent e) {
                pan.sortTree(false);
            }
        }));
        JDialog dlg = new JDialog(null, "SrTablePanel Show", true);
        dlg.getContentPane().add(p);
        dlg.setSize(p.getPreferredSize());
        dlg.show();
        System.exit(0);
    }

    class SrTreeMouseListener
    extends MouseAdapter {
        SrTreeMouseListener() {
        }

        public void mouseReleased(MouseEvent e) {
            Point p = e.getPoint();
            TreePath path = SrTreePanel.this.m_tree.getPathForLocation(p.x, p.y);
            if (path == null || path.getPathCount() == 0) {
                SrTreePanel.this.m_tree.getSelectionModel().clearSelection();
            }
            if (SwingUtilities.isRightMouseButton(e) && path != null && path.getPathCount() > 0) {
                if (!SrTreePanel.this.m_tree.getSelectionModel().isPathSelected(path)) {
                    SrTreePanel.this.m_tree.getSelectionModel().setSelectionPath(path);
                } else {
                    SrTreePanel.this.m_tree.getSelectionModel().addSelectionPath(path);
                }
                if (SrTreePanel.this.m_popup != null) {
                    SrTreePanel.this.m_popup.show(e);
                }
            }
        }
    }
}

