/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SrTreeExpandSelectionRestorer {
    public static final SelectionType SELECTION_BY_PATH = new SelectionType("SelectionByPath");
    public static final SelectionType SELECTION_BY_ROW = new SelectionType("SelectionByRow");
    private List expandedPaths;
    private int[] selectionRows;
    private JTree tree;
    private SelectionType selectionType;

    public SrTreeExpandSelectionRestorer(JTree tree, SelectionType selectionType) {
        this(tree, false);
    }

    public SrTreeExpandSelectionRestorer(JTree tree, boolean clearSelection) {
        this.tree = tree;
        this.save();
        if (clearSelection) {
            this.clearSelection();
        }
    }

    public void save() {
        this.saveSelection();
        this.saveExpandedState();
    }

    public void update(TreeNode target, TreePath old, TreePath nw) {
        TreePath[] tp = this.expandedPaths.toArray(new TreePath[0]);
        int i = 0;
        while (i < tp.length) {
            Object[] objs = tp[i].getPath();
            int j = 0;
            while (j < objs.length) {
                if (objs[j] == target) {
                    Object[] newPath = new Object[objs.length - old.getPathCount() + nw.getPathCount()];
                    System.arraycopy(nw.getPath(), 0, newPath, 0, nw.getPathCount());
                    System.arraycopy(objs, j, newPath, nw.getPathCount(), objs.length - j);
                    tp[i] = new TreePath(newPath);
                }
                ++j;
            }
            ++i;
        }
    }

    public void remove(TreePath tp) {
        Iterator iterator = this.expandedPaths.iterator();
        while (iterator.hasNext()) {
            TreePath path = (TreePath)iterator.next();
            if (!tp.isDescendant(path)) continue;
            iterator.remove();
        }
        int i = this.tree.getRowForPath(tp);
        int j = 0;
        while (j < this.selectionRows.length) {
            int row = this.selectionRows[j];
            if (row == i) {
                this.selectionRows = this.createNewArray(this.selectionRows, j);
            } else if (row > i) {
                int n = j;
                this.selectionRows[n] = this.selectionRows[n] - 1;
            }
            ++j;
        }
    }

    private int[] createNewArray(int[] arr, int removeIndex) {
        int[] newArr = new int[arr.length - 1];
        int newInxed = 0;
        int i = 0;
        while (i < arr.length) {
            if (i != removeIndex) {
                newArr[newInxed++] = arr[i];
            }
            ++i;
        }
        return newArr;
    }

    public void restore(SelectionType selectionType) {
        this.restoreExpandedState();
        this.restoreSelections(selectionType);
    }

    public void clearSelection() {
        this.selectionRows = new int[0];
    }

    public void setSelection(TreePath path) {
        this.selectionRows = new int[1];
        this.selectionRows[0] = this.tree.getRowForPath(path);
    }

    public void addSelection(TreePath path) {
        int[] newRows = new int[this.selectionRows.length + 1];
        int i = 0;
        while (i < this.selectionRows.length) {
            newRows[i] = this.selectionRows[i];
            ++i;
        }
        newRows[this.selectionRows.length] = this.tree.getRowForPath(path);
        this.selectionRows = newRows;
    }

    private void restoreSelections(SelectionType selectionType) {
        if (selectionType == SELECTION_BY_ROW) {
            if (this.selectionRows == null) {
                return;
            }
            int i = 0;
            while (i < this.selectionRows.length) {
                int selectionRow = this.selectionRows[i];
                this.selectionRows[i] = Math.min(selectionRow, this.tree.getRowCount() - 1);
                ++i;
            }
            this.tree.setSelectionRows(this.selectionRows);
        } else {
            this.tree.setSelectionPaths(this.expandedPaths.toArray(new TreePath[0]));
        }
    }

    public void addExpandedState(TreePath path) {
        if (path != null) {
            this.expandedPaths.add(path);
        }
    }

    private void restoreExpandedState() {
        Iterator iterator = this.expandedPaths.iterator();
        while (iterator.hasNext()) {
            TreePath path = (TreePath)iterator.next();
            this.tree.expandPath(path);
        }
    }

    private void saveExpandedState() {
        this.expandedPaths = new ArrayList();
        TreeNode root = (TreeNode)this.tree.getModel().getRoot();
        if (root != null) {
            TreePath rootPath = new TreePath(root);
            Enumeration<TreePath> enumeration = this.tree.getExpandedDescendants(rootPath);
            while (enumeration != null && enumeration.hasMoreElements()) {
                this.expandedPaths.add(enumeration.nextElement());
            }
        }
    }

    private void saveSelection() {
        TreePath[] tp = this.tree.getSelectionPaths();
        if (tp != null) {
            this.selectionRows = new int[tp.length];
            int i = 0;
            while (i < tp.length) {
                TreePath treePath = tp[i];
                this.selectionRows[i] = this.tree.getRowForPath(treePath);
                ++i;
            }
        } else {
            this.selectionRows = null;
        }
    }

    private void print() {
        if (this.selectionRows == null) {
            return;
        }
        StringBuffer buffer = new StringBuffer("selection rows are: ");
        int length = this.selectionRows.length;
        int i = 0;
        while (i < length) {
            int selectionRow = this.selectionRows[i];
            buffer.append(String.valueOf(selectionRow) + (i == length - 1 ? "." : ", "));
            ++i;
        }
    }

    private static class SelectionType {
        private String type;

        SelectionType(String type) {
            this.type = type;
        }
    }
}

