/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.ImageObject;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrCellEditor;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrPopupMenu;
import com.sanrad.swing.SrSwingUtils;
import com.sanrad.swing.SrTable;
import com.sanrad.swing.SrTableCellRenderer;
import com.sanrad.swing.SrTableColumns;
import com.sanrad.swing.SrTableModel;
import com.sanrad.swing.TableSelectionSaveListener;
import com.sanrad.swing.components.SrCheckbox;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrDateField;
import com.sanrad.swing.components.SrHexAddressTextField;
import com.sanrad.swing.components.SrHexTextField;
import com.sanrad.swing.components.SrIPTextField;
import com.sanrad.swing.components.SrIntegerTextField;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.swing.components.SrPasswordTextField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.swing.components.SrTimeField;
import com.sanrad.swing.components.SrWidget;
import com.sanrad.swing.table.ColumnGroup;
import com.sanrad.swing.table.GroupableTableHeader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SrTablePanel
extends SrPanel
implements ListSelectionListener,
TableSelectionSaveListener {
    protected SrTable m_table;
    private SrTableColumns m_tableCols;
    private int m_selMode;
    private HeaderSortListener m_hsl;
    private JScrollPane m_scrollPane;
    private SrPopupMenu m_popup;
    private int[] m_selSet;
    private SrTableMouseAdapter m_mouseListener;
    private static final String ROW_DEL = "\n";
    private static final String COLUMN_DEL = "\t";

    public SrTablePanel(SrTableModel model) {
        this(model, true);
    }

    public SrTablePanel(SrTableModel model, boolean sort) {
        super(new BorderLayout());
        this.m_tableCols = model.getTableColumnsObject();
        this.m_table = new SrTable(model){

            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                if (c != null && c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    Object val = this.getValueAt(rowIndex, vColIndex);
                    String value = null;
                    if (val != null) {
                        value = val.toString();
                        jc.setToolTipText(value);
                    }
                }
                return c;
            }

            protected JTableHeader createDefaultTableHeader() {
                return new GroupableTableHeader(this.columnModel);
            }
        };
        this.m_selMode = 0;
        this.m_table.setSelectionMode(this.m_selMode);
        this.m_table.setRowHeight(this.m_table.getRowHeight() + 4);
        this.m_hsl = new HeaderSortListener();
        this.m_table.getTableHeader().addMouseListener(this.m_hsl);
        this.m_table.getTableHeader().addMouseMotionListener(this.m_hsl);
        SrComponent[] defVals = this.m_tableCols.getColumnObjects();
        int cols = model.getColumnCount();
        int i = 0;
        while (i < cols) {
            TableColumn tc = this.m_table.getColumnModel().getColumn(i);
            if (defVals != null && i < defVals.length) {
                tc.setHeaderRenderer(new AlignedHeaderCellRenderer(0.0f));
                if (!(defVals[i] instanceof SrCheckbox)) {
                    tc.setCellRenderer(new SrTableCellRenderer());
                }
            }
            ++i;
        }
        if (defVals != null) {
            i = 0;
            while (i < defVals.length) {
                if (defVals[i] instanceof SrCheckbox) {
                    model.setDefaults(i, defVals[i]);
                } else {
                    TableColumn myColumn = this.m_table.getColumnModel().getColumn(i);
                    Component c = myColumn.getHeaderRenderer().getTableCellRendererComponent(this.m_table, myColumn.getHeaderValue(), false, false, -1, i);
                    int headerWidth = c.getPreferredSize().width + 1;
                    myColumn.setPreferredWidth(headerWidth);
                    if (!(defVals[i] instanceof SrLabelField)) {
                        myColumn.setCellEditor(new SrCellEditor(myColumn, defVals[i], headerWidth));
                    }
                    model.setDefaults(i, defVals[i]);
                }
                ++i;
            }
        }
        this.m_table.setShowVerticalLines(true);
        this.m_table.setRowSelectionAllowed(true);
        this.m_mouseListener = new SrTableMouseAdapter();
        this.m_table.addMouseListener(this.m_mouseListener);
        this.m_table.setAutoResizeMode(0);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.m_scrollPane = new JScrollPane(this.m_table);
        this.m_scrollPane.getViewport().setBackground(LookAndFill.TABLE_SCROLL_BACKGROUND_COLOR);
        this.add((Component)this.m_scrollPane, "Center");
        this.m_scrollPane.addMouseListener(this.m_mouseListener);
        if (sort) {
            this.invokeColumnSortOnStartup(0, true);
        }
        model.addSelSaveListeners(this);
        this.m_table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.getModifiers() == 2 && e.getKeyCode() == 89) {
                    Rectangle cellLocation = SrTablePanel.this.m_table.getCellRect(SrTablePanel.this.m_table.getSelectedRow(), 0, false);
                    MouseEvent event = new MouseEvent(SrTablePanel.this.m_table, 500, e.getWhen(), 0, cellLocation.x + cellLocation.width / 2, cellLocation.y + cellLocation.height / 2, 1, true, 3);
                    SrTablePanel.this.m_mouseListener.mouseClicked(event);
                }
            }

            public void keyTyped(KeyEvent e) {
            }
        });
    }

    public void tableChanged(TableModelEvent e) {
    }

    public void setTablePanelCellRenderer(SrTableCellRenderer renderer) {
        int cols = this.m_table.getColumnModel().getColumnCount();
        int i = 0;
        while (i < cols) {
            TableColumn tc = this.m_table.getColumnModel().getColumn(i);
            tc.setCellRenderer(renderer);
            ++i;
        }
    }

    public void saveTableSelectionSet() {
        this.m_selSet = this.m_table.getSelectedRows();
    }

    public void restoreTableSelectionSet() {
        if (this.m_selSet != null && this.m_selSet.length > 0) {
            this.m_table.setRowSelectionInterval(this.m_selSet[0], this.m_selSet[this.m_selSet.length - 1]);
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting() && event.getSource() == this.m_table.getSelectionModel() && event.getFirstIndex() >= 0) {
            if (this.m_table.getColumnSelectionAllowed() && !this.m_table.getRowSelectionAllowed()) {
                int[] colIndices = this.m_table.getSelectedColumns();
                this.columnSelectionChanged(colIndices);
            } else if (!this.m_table.getColumnSelectionAllowed() && this.m_table.getRowSelectionAllowed()) {
                int[] rowIndices = this.m_table.getSelectedRows();
                this.rowSelectionChanged(rowIndices);
            }
        }
    }

    protected void rowSelectionChanged(int[] rowIndices) {
    }

    protected void columnSelectionChanged(int[] colIndices) {
    }

    public void setTablePopUpMenuObject(SrPopupMenu menu) {
        this.m_popup = menu;
    }

    public SrPopupMenu getTablePopUpMenuObject() {
        return this.m_popup;
    }

    public void setColumnSortComparator(Comparator comp) {
        ((SrTableModel)this.m_table.getModel()).setSortComperator(comp);
    }

    public SrTable getTable() {
        return this.m_table;
    }

    public SrTableModel getModel() {
        return (SrTableModel)this.m_table.getModel();
    }

    public void addRow(Object[] row) {
        ((SrTableModel)this.m_table.getModel()).addRow(row);
    }

    public void setCellValue(Object value, int row, int col) {
        this.m_table.getModel().setValueAt(value, row, col);
    }

    public void removeRow(int rowId) {
        ((SrTableModel)this.m_table.getModel()).removeRow(rowId);
    }

    public void removeAllRows() {
        SrTableModel model = (SrTableModel)this.m_table.getModel();
        int size = model.getRowCount();
        int i = 0;
        while (i < size) {
            model.removeRow(0);
            ++i;
        }
    }

    public Vector getRow(int rowId) {
        return ((SrTableModel)this.m_table.getModel()).getRow(rowId);
    }

    public Vector getAllRows() {
        Vector rows = new Vector();
        SrTableModel model = (SrTableModel)this.m_table.getModel();
        int i = 0;
        while (i < model.getRowCount()) {
            Vector<String> ar = new Vector<String>();
            int j = 0;
            while (j < this.m_table.getModel().getColumnCount()) {
                Object o = model.getValueAt(i, j);
                String val = String.valueOf(o);
                ar.add(val);
                ++j;
            }
            rows.add(ar);
            ++i;
        }
        return rows;
    }

    public void forceInvalidate() {
        super.invalidate();
    }

    public int getSelectedRow() {
        return this.m_table.getSelectedRow();
    }

    public int[] getSelectedRows() {
        return this.m_table.getSelectedRows();
    }

    public int getSelectedColumn() {
        return this.m_table.getSelectedColumn();
    }

    public String exportTable() {
        return this.exportTable(true, ROW_DEL, COLUMN_DEL);
    }

    public String exportTable(boolean useHeader) {
        return this.exportTable(useHeader, ROW_DEL, COLUMN_DEL);
    }

    public String exportTable(boolean useHeader, String rowDel, String colDel) {
        int i;
        StringBuffer line = new StringBuffer();
        SrTableModel model = (SrTableModel)this.m_table.getModel();
        if (useHeader) {
            i = 0;
            while (i < model.getColumnCount()) {
                String defColName = ((SrTableModel)this.m_table.getModel()).getColumnName(i);
                if (i == 0) {
                    line.append(defColName);
                } else {
                    line.append(String.valueOf(colDel) + defColName);
                }
                ++i;
            }
            line.append(rowDel);
        }
        i = 0;
        while (i < model.getRowCount()) {
            Vector row = model.getRow(i);
            Object[] arr = row.toArray();
            int j = 0;
            while (j < arr.length) {
                Object o = arr[j];
                String item = o.toString();
                if (j == 0) {
                    line.append(item);
                } else {
                    line.append(String.valueOf(colDel) + item);
                }
                ++j;
            }
            line.append(rowDel);
            ++i;
        }
        return line.toString();
    }

    public SrComponent[] getDefaults() {
        return ((SrTableModel)this.m_table.getModel()).getDefaults();
    }

    public void setSelectionMode(int selectionMode) {
        if (selectionMode != this.m_selMode) {
            this.m_selMode = selectionMode;
            this.m_table.setSelectionMode(this.m_selMode);
        }
    }

    public void setRowSelectionSet(int first, int second) {
        this.m_table.clearSelection();
        this.m_table.getSelectionModel().setSelectionInterval(first, second);
    }

    public void scrollToRow(int row) {
        this.m_table.scrollRectToVisible(this.m_table.getCellRect(row, 0, true));
    }

    private void resizeColumnAccordingToLargestCell(TableColumn tableCol, int colIndex) {
        if (colIndex != -1 && tableCol != null) {
            Component h = tableCol.getHeaderRenderer().getTableCellRendererComponent(this.m_table, tableCol.getHeaderValue(), false, false, 0, 0);
            int max = h.getPreferredSize().width;
            SrTableModel model = (SrTableModel)this.m_table.getModel();
            SrComponent colDef = model.getDefault(colIndex);
            if (!(colDef instanceof SrCheckbox)) {
                int i = 0;
                while (i < model.getRowCount()) {
                    Object o = model.getValueAt(i, colIndex);
                    Component com = tableCol.getCellRenderer().getTableCellRendererComponent(this.m_table, o, false, false, i, colIndex);
                    int w = com.getPreferredSize().width;
                    max = Math.max(max, w);
                    ++i;
                }
            }
            if (max != -1) {
                tableCol.setPreferredWidth(max + 20);
            }
        }
    }

    private void setBackSelection(Vector selRows) {
        if (selRows.size() > 0) {
            int[] newIndex = new int[selRows.size()];
            int index = 0;
            SrTableModel model = (SrTableModel)this.m_table.getModel();
            int i = 0;
            while (i < model.getRowCount()) {
                if (selRows.contains(model.getRow(i).toString())) {
                    newIndex[index++] = i;
                    if (index == selRows.size()) break;
                }
                ++i;
            }
            this.m_table.clearSelection();
            i = 0;
            while (i < newIndex.length) {
                this.m_table.addRowSelectionInterval(newIndex[i], newIndex[i]);
                ++i;
            }
        }
    }

    public SrTableColumns getTableCols() {
        return this.m_tableCols;
    }

    public JScrollPane getScrollPane() {
        return this.m_scrollPane;
    }

    public void enableSort(boolean allowSort) {
        SrTableModel model = (SrTableModel)this.m_table.getModel();
        model.enableSort(allowSort);
        if (!allowSort) {
            TableColumn column = this.m_table.getColumnModel().getColumn(0);
            String name = model.getColumnName(column.getModelIndex());
            column.setHeaderValue(name);
        }
    }

    public void invokeColumnSortOnStartup(Vector colSet) {
        SrTableModel model = (SrTableModel)this.m_table.getModel();
        model.m_sortColVec.clear();
        model.m_sortColVec.addAll(colSet);
        if (model.isSortAllowed() && model.getRowCount() > 0) {
            this.sort(model);
        }
    }

    public void invokeColumnSortOnStartup(int colsIndex, boolean asc) {
        Vector<int[]> colSet = new Vector<int[]>(1);
        int order = 1;
        if (!asc) {
            order = 0;
        }
        colSet.add(new int[]{colsIndex, order});
        this.invokeColumnSortOnStartup(colSet);
    }

    public void addNewColumnGroup(String groupName, int[] listOfColumnIndexes) {
        if (listOfColumnIndexes.length > 0) {
            TableColumnModel cm = this.m_table.getColumnModel();
            ColumnGroup group = new ColumnGroup(groupName);
            int i = 0;
            while (i < listOfColumnIndexes.length) {
                group.add(cm.getColumn(listOfColumnIndexes[i]));
                ++i;
            }
            GroupableTableHeader header = (GroupableTableHeader)this.m_table.getTableHeader();
            header.addColumnGroup(group);
        }
    }

    public void hideTableColumn(int column) {
        if (this.m_table.getColumnModel().getColumn(column) != null) {
            this.m_table.getColumnModel().getColumn(column).setMinWidth(0);
            this.m_table.getColumnModel().getColumn(column).setMaxWidth(0);
        }
    }

    public void hideTableColumn(String columnName) {
        int colIndex = ((SrTableModel)this.m_table.getModel()).getColumnIndex(columnName);
        if (colIndex != -1) {
            this.hideTableColumn(colIndex);
        }
    }

    public void showHiddenTableColumn(int column) {
        TableColumn myColumn = this.m_table.getColumnModel().getColumn(column);
        if (myColumn != null && myColumn.getMaxWidth() == 0) {
            Component c = myColumn.getHeaderRenderer().getTableCellRendererComponent(this.m_table, myColumn.getHeaderValue(), false, false, -1, column);
            int headerWidth = c.getPreferredSize().width + 1;
            myColumn.setMaxWidth(Integer.MAX_VALUE);
            myColumn.setPreferredWidth(headerWidth);
            myColumn.setMinWidth(15);
        }
    }

    public void showHiddenTableColumn(String columnName) {
        int colIndex = ((SrTableModel)this.m_table.getModel()).getColumnIndex(columnName);
        if (colIndex != -1) {
            this.showHiddenTableColumn(colIndex);
        }
    }

    public void changeGroupHeaderName(String oldGroupName, String newGroupName) {
        ColumnGroup g = ((GroupableTableHeader)this.m_table.getTableHeader()).getGroupByName(oldGroupName);
        Vector cols = g.getGroupTableColumns();
        int i = 0;
        while (i < cols.size()) {
            TableColumn col = (TableColumn)cols.get(i);
            String colName = (String)col.getHeaderValue();
            if (colName.indexOf(oldGroupName) != -1) {
                String newColName = colName.replaceAll(oldGroupName, "").trim();
                StringBuffer buff = new StringBuffer(newGroupName);
                buff.append(" ");
                buff.append(newColName);
                this.getModel().setColumnName(colName, buff.toString());
                col.setHeaderValue(buff.toString());
            }
            ++i;
        }
        g.setHeaderValue(newGroupName);
        this.m_table.getTableHeader().repaint();
    }

    private void sort(SrTableModel model) {
        Vector colSet = model.m_sortColVec;
        int i = 0;
        while (i < model.getColumnCount()) {
            TableColumn column = this.m_table.getColumnModel().getColumn(i);
            String name = model.getColumnName(column.getModelIndex());
            JLabel lbl = null;
            int rec = this.findColInSet(colSet, i);
            if (rec != -1) {
                int[] param = (int[])colSet.get(rec);
                lbl = new JLabel();
                ImageIcon icon = null;
                icon = param[1] == 1 ? ImageObject.UP_ARROW.getImageIcon() : ImageObject.DOWN_ARROW.getImageIcon();
                if (colSet.size() > 1) {
                    lbl.setIcon(SrSwingUtils.drawStringOnIcon(icon, new Font("Courier New", 0, 9), Color.BLACK, String.valueOf(rec + 1), 7, 1));
                } else {
                    lbl.setIcon(icon);
                }
                lbl.setText(name);
            }
            if (lbl != null) {
                column.setHeaderValue(lbl);
                Component c = column.getHeaderRenderer().getTableCellRendererComponent(this.m_table, column.getHeaderValue(), false, false, -1, i);
                int newSize = c.getPreferredSize().width + 1;
                if (newSize > column.getPreferredWidth()) {
                    column.setPreferredWidth(newSize);
                }
            } else {
                column.setHeaderValue(name);
            }
            ++i;
        }
        this.m_table.getTableHeader().repaint();
        model.sortColumn();
    }

    private int findColInSet(Vector v, int index) {
        int found = -1;
        int i = 0;
        while (i < v.size()) {
            int[] arr = (int[])v.get(i);
            if (arr[0] == index) {
                found = i;
                break;
            }
            ++i;
        }
        return found;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        SrWidget w1 = new SrWidget("HexField", new SrHexTextField());
        SrWidget w2 = new SrWidget("DateField", new SrDateField());
        SrWidget w3 = new SrWidget("ComboField", new SrComboBox(new Object[]{"1", "2", "3"}));
        SrWidget w4 = new SrWidget("CheckBoxField", new SrCheckbox());
        SrWidget w5 = new SrWidget("SrHexAddressTextField", new SrHexAddressTextField());
        SrWidget w6 = new SrWidget("SrIntegerTextField", new SrIntegerTextField());
        SrWidget w7 = new SrWidget("SrIPTextField", new SrIPTextField());
        SrWidget w8 = new SrWidget("SrLabelField", new SrLabelField("hello"));
        SrWidget w9 = new SrWidget("SrPasswordTextField", new SrPasswordTextField());
        SrWidget w11 = new SrWidget("SrTextField", new SrTextField());
        SrWidget w12 = new SrWidget("SrTimeField", new SrTimeField());
        Vector<SrWidget> vec = new Vector<SrWidget>(4);
        vec.add(w1);
        vec.add(w2);
        vec.add(w3);
        vec.add(w5);
        vec.add(w6);
        vec.add(w7);
        vec.add(w8);
        SrTableColumns cols = new SrTableColumns(vec);
        SrTableModel model = new SrTableModel(cols);
        model.addRow(new Object[]{"1", "5", "1", "", "", "", "", ""});
        model.addRow(new Object[]{"2", "4", "2", "", "", "", "", ""});
        model.addRow(new Object[]{"3", "3", "3", "", "", "", "", ""});
        model.addRow(new Object[]{"3", "2", "4", "", "", "", "", ""});
        model.addRow(new Object[]{"4", "1", "5", "", "", "", "", ""});
        model.addRow(new Object[]{"5", "6", "7", "", "", "", "", ""});
        model.addRow(new Object[]{"5", "7", "6", "", "", "", "", ""});
        final SrTablePanel tbl = new SrTablePanel(model);
        tbl.addNewColumnGroup("cg1", new int[]{1, 2});
        tbl.addNewColumnGroup("cg2", new int[]{3, 4});
        tbl.addNewColumnGroup("cg3", new int[]{5, 6});
        tbl.setSelectionMode(2);
        SrPopupMenu popup = new SrPopupMenu(tbl.getTable());
        Vector<AbstractAction> acts = new Vector<AbstractAction>(2);
        AbstractAction act1 = new AbstractAction("Hide"){

            public void actionPerformed(ActionEvent e) {
                tbl.hideTableColumn("ComboField");
            }
        };
        acts.add(act1);
        AbstractAction act2 = new AbstractAction("show"){

            public void actionPerformed(ActionEvent e) {
                tbl.showHiddenTableColumn("ComboField");
            }
        };
        acts.add(act2);
        popup.attachActions(acts);
        tbl.setTablePopUpMenuObject(popup);
        JDialog dlg = new JDialog(null, "SrTablePanel Show", true);
        dlg.getContentPane().add(tbl);
        dlg.setSize(tbl.getPreferredSize());
        dlg.show();
        System.exit(0);
    }

    protected void finalize() throws Throwable {
        this.m_table.removeMouseListener(this.m_mouseListener);
        this.m_scrollPane.removeMouseListener(this.m_mouseListener);
        this.m_table.getTableHeader().removeMouseListener(this.m_hsl);
        this.m_table.getTableHeader().removeMouseMotionListener(this.m_hsl);
        this.getModel().removeSelSaveListeners(this);
        super.finalize();
    }

    public void removeListeners() {
    }

    class HeaderSortListener
    extends MouseInputAdapter {
        private boolean m_ctrlDown = false;

        HeaderSortListener() {
        }

        public void mouseEntered(MouseEvent e) {
            this.checkCursor(e);
        }

        public void mouseExited(MouseEvent e) {
            this.removeSortCursor();
        }

        public void mouseMoved(MouseEvent e) {
            this.checkCursor(e);
        }

        private void checkCursor(MouseEvent e) {
            if (e.isControlDown()) {
                this.m_ctrlDown = true;
            } else {
                this.removeSortCursor();
            }
        }

        private void removeSortCursor() {
            if (this.m_ctrlDown) {
                SrTablePanel.this.m_table.getTableHeader().setCursor(Cursor.getDefaultCursor());
                this.m_ctrlDown = false;
            }
        }

        public void mouseClicked(MouseEvent e) {
            Cursor cursor = e.getComponent().getCursor();
            if (cursor.equals(Cursor.getPredefinedCursor(11)) || cursor.equals(Cursor.getPredefinedCursor(10))) {
                int columnModelIndex;
                TableColumnModel colModel;
                TableColumn tableCol;
                int modelIndex;
                if (e.getClickCount() == 2 && (modelIndex = (tableCol = (colModel = SrTablePanel.this.m_table.getColumnModel()).getColumn(columnModelIndex = colModel.getColumnIndexAtX(e.getX() - 5))).getModelIndex()) != -1) {
                    SrTablePanel.this.resizeColumnAccordingToLargestCell(tableCol, modelIndex);
                }
            } else {
                SrTableModel model = (SrTableModel)SrTablePanel.this.m_table.getModel();
                if (model.isSortAllowed() && e.getClickCount() == 1 && model.getRowCount() > 0) {
                    int columnModelIndex;
                    int[] rows = SrTablePanel.this.m_table.getSelectedRows();
                    Vector<String> selRows = new Vector<String>(rows.length);
                    int i = 0;
                    while (i < rows.length) {
                        Vector rowVec;
                        if (rows[i] != -1 && (rowVec = model.getRow(rows[i])) != null) {
                            selRows.add(rowVec.toString());
                        }
                        ++i;
                    }
                    TableColumnModel colModel = SrTablePanel.this.m_table.getColumnModel();
                    int modelIndex = colModel.getColumn(columnModelIndex = colModel.getColumnIndexAtX(e.getX())).getModelIndex();
                    if (modelIndex < 0) {
                        return;
                    }
                    boolean isControlDown = e.isControlDown();
                    int colIndex = Math.abs(columnModelIndex);
                    Vector colSet = model.m_sortColVec;
                    int colListSize = colSet.size();
                    if (!isControlDown && colSet.size() >= 1) {
                        int[] sortParam = (int[])colSet.get(0);
                        int newOrder = sortParam[1];
                        if (sortParam[0] == colIndex) {
                            newOrder ^= 1;
                        }
                        colSet.clear();
                        colSet.addElement(new int[]{colIndex, newOrder});
                    } else if (colListSize == 0) {
                        colSet.addElement(new int[]{colIndex, 1});
                    } else if (isControlDown) {
                        if (colListSize >= 1) {
                            int rec = SrTablePanel.this.findColInSet(colSet, colIndex);
                            if (rec != -1) {
                                int[] sortParam = (int[])colSet.get(rec);
                                sortParam[1] = sortParam[1] ^ 1;
                            } else {
                                int[] lastSortParam = (int[])colSet.get(colListSize - 1);
                                colSet.addElement(new int[]{colIndex, lastSortParam[1]});
                            }
                        }
                    } else {
                        return;
                    }
                    SrTablePanel.this.sort(model);
                    SrTablePanel.this.setBackSelection(selRows);
                }
            }
        }
    }

    public class AlignedHeaderCellRenderer
    implements TableCellRenderer {
        float m_alignment;

        public AlignedHeaderCellRenderer(float alignment) {
            this.m_alignment = alignment;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            GroupableTableHeader th = (GroupableTableHeader)table.getTableHeader();
            TableCellRenderer dtcr = th.getDefaultRenderer();
            Component dcmp = dtcr.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Color bgColor = dcmp.getBackground();
            Color fgColor = dcmp.getForeground();
            Font font = dcmp.getFont();
            String name = SrTablePanel.this.getModel().getColumnName(column);
            TableColumn col = table.getColumnModel().getColumn(column);
            Enumeration enumeration = th.getColumnGroups(col);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    ColumnGroup group = (ColumnGroup)enumeration.nextElement();
                    String groupName = (String)group.getHeaderValue();
                    name = name.replaceAll(groupName, "").trim();
                }
            }
            JLabel lbl = new JLabel();
            lbl.setHorizontalTextPosition(2);
            lbl.setVerticalTextPosition(3);
            lbl.setIconTextGap(10);
            lbl.setFont(font);
            lbl.setForeground(fgColor);
            lbl.setBackground(bgColor);
            if (value instanceof JLabel) {
                lbl.setIcon(((JLabel)value).getIcon());
            }
            lbl.setText(name);
            if (dcmp instanceof JComponent) {
                lbl.setBorder(((JComponent)dcmp).getBorder());
            }
            return lbl;
        }
    }

    class SrTableMouseAdapter
    extends MouseAdapter {
        SrTableMouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            int row = SrTablePanel.this.m_table.rowAtPoint(e.getPoint());
            if (row == -1) {
                SrTablePanel.this.m_table.clearSelection();
            } else if (SwingUtilities.isRightMouseButton(e)) {
                if (SrTablePanel.this.m_table.getSelectedRowCount() == 0 || !SrTablePanel.this.m_table.getSelectionModel().isSelectedIndex(row)) {
                    SrTablePanel.this.m_table.getSelectionModel().setSelectionInterval(row, row);
                }
                if (SrTablePanel.this.m_popup != null) {
                    SrTablePanel.this.m_popup.show(e);
                }
            }
        }
    }
}

