/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.SrTableColumns;
import com.sanrad.swing.TableSelectionSaveListener;
import com.sanrad.swing.components.SrComponent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class SrTableModel
extends AbstractTableModel
implements Comparator {
    Vector m_defVals;
    Vector m_columns;
    protected Vector m_data;
    boolean[] m_readOnly;
    boolean m_allowSort;
    private SrTableColumns m_cols;
    private Comparator m_comp;
    private Vector m_selSaveListeners = new Vector();
    protected int m_sortColumn;
    protected int m_sortOrder;
    protected int m_runningIndex;
    public Vector m_sortColVec;
    static /* synthetic */ Class class$0;

    public SrTableModel(SrTableColumns cols) {
        String[] columns = cols.getColumnNames();
        SrComponent[] defs = cols.getColumnObjects();
        this.m_defVals = new Vector(columns.length);
        this.m_columns = new Vector(columns.length);
        this.m_data = new Vector();
        this.m_comp = this;
        this.enableSort(true);
        int i = 0;
        while (i < columns.length) {
            this.m_columns.add(i, columns[i]);
            this.m_defVals.add(i, defs[i]);
            ++i;
        }
        this.m_readOnly = cols.getColumnReadOnlyPermission();
        this.m_cols = cols;
        this.m_sortColVec = new Vector();
    }

    public void addRow(Object[] row) {
        this.addRow(row, -1);
    }

    public void addRow(Object[] row, int place) {
        this.addRowQuetly(row, place);
        if (place >= 0 && place < this.m_data.size()) {
            this.fireTableRowsInserted(place, place);
        } else {
            this.fireTableRowsInserted(this.m_data.size() - 1, this.m_data.size() - 1);
        }
    }

    protected void addRowQuetly(Object[] row, int place) {
        int cols = this.m_columns.size();
        if (row.length < cols) {
            System.out.println("Error: not enough data, received: " + row.length + " expected: " + cols);
            return;
        }
        Vector<Object> newRow = new Vector<Object>(cols);
        int i = 0;
        while (i < cols) {
            newRow.add(i, row[i]);
            ++i;
        }
        if (place >= 0) {
            this.m_data.insertElementAt(newRow, place);
        } else {
            this.m_data.add(newRow);
        }
    }

    public void editRow(int selectedRow, Object[] row) {
        int i = row.length;
        while (i-- > 0) {
            this.setValueAt(row[i], selectedRow, i);
        }
        this.fireTableRowsUpdated(selectedRow, selectedRow);
    }

    public boolean isCellEditable(int row, int col) {
        return this.m_readOnly == null || col >= this.m_readOnly.length || !this.m_readOnly[col];
    }

    public Class getColumnClass(int c) {
        Object o = this.getValueAt(0, c);
        if (o != null) {
            return o.getClass();
        }
        if (this.m_defVals.get(c) != null) {
            return this.m_defVals.get(c).getClass();
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public int getColumnCount() {
        return this.m_columns.size();
    }

    public int getRowCount() {
        return this.m_data.size();
    }

    public int getLastRowIndex() {
        int size = this.m_data.size() - 1;
        if (size < 0) {
            size = 0;
        }
        return size;
    }

    public Vector getTableData() {
        return this.m_data;
    }

    public String getColumnName(int col) {
        String name = null;
        if (col < this.m_columns.size() && col >= 0) {
            name = (String)this.m_columns.get(col);
        }
        return name;
    }

    public void setColumnName(String oldName, String newName) {
        int index = this.m_columns.indexOf(oldName);
        if (index != -1) {
            this.m_columns.setElementAt(newName, index);
        }
    }

    public int getColumnIndex(String name) {
        return this.m_columns.indexOf(name);
    }

    public SrComponent[] getDefaults() {
        return (SrComponent[])this.m_defVals.toArray();
    }

    public SrComponent getDefault(int col) {
        return (SrComponent)this.m_defVals.get(col);
    }

    public void setDefaults(int col, SrComponent obj) {
        this.m_defVals.add(col, obj);
    }

    public Vector getRow(int row) {
        Vector v = null;
        if (row < this.getRowCount() && row >= 0) {
            v = (Vector)this.m_data.get(row);
        }
        return v;
    }

    public Object getValueAt(int row, int col) {
        Object obj = null;
        if (row >= 0 && row < this.getRowCount()) {
            Vector v = null;
            try {
                v = (Vector)this.m_data.get(row);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (v != null) {
                if (col >= 0 && col < this.getColumnCount()) {
                    obj = v.get(col);
                } else {
                    System.out.println(this.getClass() + " getValueAt() Trying to access non-existent cell, row:  " + row + " col: " + col);
                }
            }
        }
        return obj;
    }

    public void setValueAt(Object value, int row, int col) {
        ((Vector)this.m_data.get(row)).set(col, value);
        this.fireTableCellUpdated(row, col);
    }

    public void removeRow(int row) {
        if (row < this.getRowCount() && row >= 0) {
            this.m_data.remove(row);
            this.fireTableRowsDeleted(row, row);
        }
    }

    public void removeRowQuetly(int row) {
        if (row < this.getRowCount() && row >= 0) {
            this.m_data.remove(row);
        }
    }

    public void removeAllRows() {
        int size = this.getRowCount();
        int i = 0;
        while (i < size) {
            this.m_data.remove(0);
            ++i;
        }
        if (size > 0) {
            this.fireTableRowsDeleted(0, size);
        }
    }

    public Object[] getColumns() {
        return this.m_columns.toArray();
    }

    public SrTableColumns getTableColumnsObject() {
        return this.m_cols;
    }

    public void enableSort(boolean sort) {
        this.m_allowSort = sort;
    }

    public boolean isSortAllowed() {
        return this.m_allowSort;
    }

    public void sortColumn() {
        this.m_runningIndex = 0;
        this.m_sortColumn = ((int[])this.m_sortColVec.get(this.m_runningIndex))[0];
        this.m_sortOrder = ((int[])this.m_sortColVec.get(this.m_runningIndex))[1];
        Collections.sort(this.m_data, this.m_comp);
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    public void setSortComperator(Comparator comp) {
        this.m_comp = comp;
    }

    public void addSelSaveListeners(TableSelectionSaveListener l) {
        this.m_selSaveListeners.add(l);
    }

    public void removeSelSaveListeners(TableSelectionSaveListener l) {
        this.m_selSaveListeners.remove(l);
    }

    public int compare(Object o1, Object o2) {
        Object col2;
        Object col1;
        block10: {
            Object obj2;
            block9: {
                if (o1 == null && this.m_sortOrder == 0) {
                    return this.order(-1);
                }
                if (o2 == null) {
                    return this.order(1);
                }
                Vector vect1 = (Vector)o1;
                Vector vect2 = (Vector)o2;
                Object obj1 = vect1.get(this.m_sortColumn);
                obj2 = vect2.get(this.m_sortColumn);
                col1 = null;
                try {
                    col1 = (Comparable)obj1;
                }
                catch (ClassCastException cce) {
                    if (obj1 == null) break block9;
                    col1 = obj1.toString();
                }
            }
            col2 = null;
            try {
                col2 = (Comparable)obj2;
            }
            catch (ClassCastException cce) {
                if (obj2 == null) break block10;
                col2 = obj2.toString();
            }
        }
        if (col1 == null) {
            return this.order(-1);
        }
        if (col2 == null) {
            return this.order(1);
        }
        int result = this.order(col1.compareTo(col2));
        if (result == 0 && this.m_sortColVec.size() > this.m_runningIndex + 1) {
            ++this.m_runningIndex;
            int saveSortCol = this.m_sortColumn;
            int saveSortOrder = this.m_sortOrder;
            this.m_sortColumn = ((int[])this.m_sortColVec.get(this.m_runningIndex))[0];
            this.m_sortOrder = ((int[])this.m_sortColVec.get(this.m_runningIndex))[1];
            result = this.compare(o1, o2);
            this.m_sortColumn = saveSortCol;
            this.m_sortOrder = saveSortOrder;
            --this.m_runningIndex;
        }
        return result;
    }

    protected int order(int i) {
        if (this.m_sortOrder == 0) {
            return -i;
        }
        return i;
    }

    public void removeListeners() {
    }
}

