/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.nms.client.gui.ClientImageObject;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public class SrSwingUtils {
    private static final Font STRIGN_FONT = new Font("Courier New", 1, 12);

    public static ImageIcon drawStringOnIcon(ImageIcon icon, Font font, Color color, String str) {
        return SrSwingUtils.drawStringOnIcon(icon, font, color, str, 0, 0);
    }

    public static ImageIcon drawStringOnIcon(ImageIcon icon, Font font, Color color, String str, int xOffset, int yOffset) {
        ImageIcon newIcon = null;
        int iconW = icon.getIconWidth();
        int iconH = icon.getIconHeight();
        BufferedImage bi = new BufferedImage(iconW, iconH, 2);
        Graphics2D g = bi.createGraphics();
        g.drawImage(icon.getImage(), 0, 0, iconW, iconH, null);
        g.setColor(color);
        g.setFont(font);
        int strH = g.getFontMetrics().getHeight();
        int strW = g.getFontMetrics().stringWidth(str);
        if (strW > iconW || strH > iconH) {
            return newIcon;
        }
        int strXcord = iconW / 2 - strW / 2;
        int strYcord = iconH / 2 + strH / 4;
        ((Graphics)g).drawString(str, strXcord + xOffset, strYcord + yOffset);
        g.dispose();
        newIcon = new ImageIcon(bi);
        return newIcon;
    }

    public static ImageIcon verticallyJoinTwoIcons(ImageIcon leftIcon, ImageIcon rightIcon, int wDistance) {
        ImageIcon newIcon = null;
        int leftIconW = leftIcon.getIconWidth();
        int leftIconH = leftIcon.getIconHeight();
        int rightIconW = rightIcon.getIconWidth();
        int rightIconH = rightIcon.getIconHeight();
        int maxH = leftIconH > rightIconH ? leftIconH : rightIconH;
        BufferedImage bi = new BufferedImage(leftIconW + rightIconW + wDistance, maxH, 2);
        Graphics2D g = bi.createGraphics();
        int leftIconHOffset = leftIconH < rightIconH ? (rightIconH - leftIconH) / 2 : 0;
        g.drawImage(leftIcon.getImage(), 0, leftIconHOffset, leftIconW, leftIconH, null);
        int rightIconHOffset = 0;
        if (leftIconHOffset == 0) {
            rightIconHOffset = (leftIconH - rightIconH) / 2;
        }
        g.drawImage(rightIcon.getImage(), leftIconW + wDistance, rightIconHOffset, rightIconW, rightIconH, null);
        g.dispose();
        newIcon = new ImageIcon(bi);
        return newIcon;
    }

    public static String createHTMLToolTip(String message) {
        if (message != null) {
            StringBuffer toolTip = new StringBuffer("<html><body><table border=\"0\"><td valign=\"middle\">&nbsp;<img src=\"");
            toolTip.append(ClientImageObject.TOOLTIP_INFO_ICON.getImageIcon().getDescription());
            toolTip.append("\" border=0 align =\"bottom\">&nbsp;&nbsp;");
            toolTip.append(message);
            toolTip.append("</td></body></html>");
            return toolTip.toString();
        }
        return null;
    }

    public static ImageIcon drawRedStringOnIcon(ImageIcon icon, String string) {
        ImageIcon newIcon = null;
        int factor = 10;
        int iconW = icon.getIconWidth();
        int iconH = icon.getIconHeight() + factor;
        BufferedImage bi = new BufferedImage(iconW, iconH, 2);
        Graphics2D g = bi.createGraphics();
        g.drawImage(icon.getImage(), 0, 3, iconW, iconH - factor, null);
        g.setColor(Color.RED);
        g.setFont(STRIGN_FONT);
        int strH = g.getFontMetrics().getHeight();
        int strW = g.getFontMetrics().stringWidth(string);
        int strXcord = iconW / 2 - strW / 2;
        int strYcord = iconH / 2 + strH / 4;
        ((Graphics)g).drawString(string, strXcord, strYcord);
        g.dispose();
        newIcon = new ImageIcon(bi);
        return newIcon;
    }
}

