/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.SrXYItemRenderer;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class SrStatisticChart {
    protected static final String PIT = "PointInTime";
    private String m_chartTitle;
    private String m_xAxisLabel;
    private String m_yAxisLabel;
    protected TimeSeriesCollection m_dataset;
    private ChartPanel m_chartPanel;
    private JFreeChart m_chart;
    private SrXYItemRenderer m_renderer;
    private HashMap m_item2Rates;
    protected boolean m_firstEvent;
    public int MAX_NUMBER_OF_TICKS = 8640;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SrStatisticChart() {
        this(ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_STATISTICS_CHART_TITLE), ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_STATISTICS_CHART_X), ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_STATISTICS_CHART_Y));
    }

    public void removeListeners() {
    }

    public SrStatisticChart(String chartTitle, String xAxisLabel, String yAxisLabel) {
        this.m_chartTitle = chartTitle;
        this.m_xAxisLabel = xAxisLabel;
        this.m_yAxisLabel = yAxisLabel;
        this.m_dataset = new TimeSeriesCollection();
        this.m_dataset.setDomainIsPointsInTime(false);
        this.m_item2Rates = new HashMap();
        this.setFirstEvent(true);
    }

    public void addSeries(String seriesName, Date[] timeStep, int[] counders) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Second");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries hitsBySecondData = new TimeSeries(seriesName, (Class)clazz);
        hitsBySecondData.setMaximumItemCount(this.MAX_NUMBER_OF_TICKS);
        int i = 0;
        while (i < timeStep.length) {
            hitsBySecondData.add((RegularTimePeriod)new Second(timeStep[i]), (double)counders[i]);
            ++i;
        }
        this.m_dataset.addSeries(hitsBySecondData);
    }

    public void addSeries(String seriesName) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Second");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries hitsBySecondData = new TimeSeries(seriesName, (Class)clazz);
        hitsBySecondData.setMaximumItemCount(this.MAX_NUMBER_OF_TICKS);
        this.m_dataset.addSeries(hitsBySecondData);
    }

    private void createChart() {
        this.m_chart = ChartFactory.createTimeSeriesChart((String)this.m_chartTitle, (String)this.m_xAxisLabel, (String)this.m_yAxisLabel, (XYDataset)this.m_dataset, (boolean)true, (boolean)true, (boolean)false);
        Font font = Font.decode(SrResourceBundle.getInstance((String)"defaultUI", (Locale)Locale.US).getString((BundleKeysInterface)SrDefaultUIBundleKeys.GENERAL_FONT));
        ((StandardLegend)this.m_chart.getLegend()).setItemFont(font);
        XYPlot plot = this.m_chart.getXYPlot();
        this.m_renderer = new SrXYItemRenderer(2, null, null, this.m_dataset);
        plot.setRenderer((XYItemRenderer)this.m_renderer);
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setTickUnit(new DateTickUnit(5, 10), true, false);
        axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("HH:mm:ss"));
        axis.setTickLabelFont(font);
        axis.setVerticalTickLabels(true);
        plot.getRangeAxis().setTickLabelFont(font);
        Paint[] colors = this.createDefaultPaintArray();
        int i = 0;
        while (i < this.m_dataset.getSeriesCount()) {
            this.m_renderer.setSeriesPaint(i, colors[i]);
            ++i;
        }
        this.m_chart.setBackgroundPaint((Paint)new Color(Integer.parseInt(SrResourceBundle.getInstance((String)"defaultUI", (Locale)Locale.US).getString((BundleKeysInterface)SrDefaultUIBundleKeys.DIALOG_COLOR))));
        TextTitle title = new TextTitle(this.m_chartTitle, Font.decode(SrResourceBundle.getInstance((String)"defaultUI", (Locale)Locale.US).getString((BundleKeysInterface)SrDefaultUIBundleKeys.PANEL_TITLE_LABEL_FONT)));
        this.m_chart.setTitle(title);
    }

    public ChartPanel packChartToPanel() {
        this.createChart();
        this.m_chartPanel = new ChartPanel(this.m_chart, false, false, false, true, false);
        this.m_chartPanel.setMouseZoomable(true);
        return this.m_chartPanel;
    }

    public SrLabelField packChartToLabel(int chartWidth, int chartHeight) {
        this.createChart();
        BufferedImage image = this.m_chart.createBufferedImage(chartWidth, chartHeight);
        return new SrLabelField(new ImageIcon(image));
    }

    public void setSeriesValue(String seriesName, Date time, Number counter) {
        TimeSeries series = this.m_dataset.getSeries(seriesName);
        series.addOrUpdate((RegularTimePeriod)new Second(time), counter);
        this.m_renderer.setCurrentRateLabel(seriesName, counter);
    }

    protected SrXYItemRenderer getSrChartRenderer() {
        return (SrXYItemRenderer)this.m_chart.getXYPlot().getRenderer();
    }

    private Paint[] createDefaultPaintArray() {
        return new Paint[]{Color.blue, Color.green, Color.orange, Color.magenta, Color.cyan, Color.pink, Color.gray, ChartColor.DARK_BLUE, ChartColor.DARK_GREEN, ChartColor.DARK_MAGENTA, ChartColor.DARK_CYAN, Color.darkGray, ChartColor.LIGHT_BLUE, ChartColor.LIGHT_GREEN, ChartColor.LIGHT_MAGENTA, ChartColor.LIGHT_CYAN, Color.lightGray, ChartColor.VERY_DARK_BLUE, ChartColor.VERY_DARK_GREEN, ChartColor.VERY_DARK_MAGENTA, ChartColor.VERY_DARK_CYAN, ChartColor.VERY_LIGHT_BLUE, ChartColor.VERY_LIGHT_GREEN, ChartColor.VERY_LIGHT_MAGENTA, ChartColor.VERY_LIGHT_CYAN};
    }

    public ChartPanel getChartPanel() {
        return this.m_chartPanel;
    }

    protected HashMap getItem2RatesMap() {
        return this.m_item2Rates;
    }

    protected void setFirstEvent(boolean flag) {
        this.m_firstEvent = flag;
    }

    protected boolean isFirstEvent() {
        return this.m_firstEvent;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        long time = System.currentTimeMillis();
        System.out.print(time);
        Date[] dates = new Date[11];
        int[] counter = new int[11];
        int i = 0;
        while (i < 110000) {
            dates[i / 10000] = new Date(time + (long)i);
            counter[i / 10000] = i / 1000;
            i += 10000;
        }
        Date[] dates2 = new Date[11];
        int[] counter2 = new int[11];
        int i2 = 0;
        while (i2 < 110000) {
            dates2[i2 / 10000] = new Date(time + (long)i2);
            counter2[i2 / 10000] = i2 / 1000 + 5;
            i2 += 10000;
        }
        final SrStatisticChart chart = new SrStatisticChart("Statistic", "Time", "Counter");
        chart.addSeries("Test1", dates, counter);
        chart.addSeries("Test2", dates2, counter2);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)chart.packChartToPanel(), "Center");
        JButton btt = new JButton(new AbstractAction("Add"){

            public void actionPerformed(ActionEvent e) {
                chart.setSeriesValue("Test2", new Date(System.currentTimeMillis()), new Integer(8));
            }
        });
        mainPanel.add((Component)btt, "South");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.sanrad.swing.SrStatisticChart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDialog dlg = new JDialog(null, clazz.toString(), true);
        dlg.getContentPane().add(mainPanel);
        dlg.setSize(600, 400);
        dlg.show();
        System.exit(0);
    }

    protected void switchItemChartDisplay(Vector statisticsValues) {
        int i = 0;
        while (i < this.m_dataset.getSeriesCount()) {
            this.m_dataset.getSeries(i).clear();
            ++i;
        }
        int j = 0;
        while (j < statisticsValues.size()) {
            HashMap newItem = (HashMap)statisticsValues.get(j);
            Date time = new Date();
            newItem.put(PIT, time);
            this.updateStatisticsChart(newItem);
            ++j;
        }
    }

    protected void updateStatisticsChart(HashMap item) {
    }
}

