/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.PropertyPanelValidationEvent;
import com.sanrad.swing.PropertyPanelValidationListener;
import com.sanrad.swing.SrComponentStatusBarInterface;
import com.sanrad.swing.SrComponentStatusBarPanel;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrPropertyPanel;
import com.sanrad.swing.SrPropertyTabbedPanel;
import com.sanrad.swing.components.SrCheckbox;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrDateField;
import com.sanrad.swing.components.SrHexAddressTextField;
import com.sanrad.swing.components.SrHexTextField;
import com.sanrad.swing.components.SrIPTextField;
import com.sanrad.swing.components.SrIntegerTextField;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.swing.components.SrPasswordTextField;
import com.sanrad.swing.components.SrRadioButtonsPanel;
import com.sanrad.swing.components.SrTextAreaField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.swing.components.SrTimeField;
import com.sanrad.swing.components.SrWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class SrPropertyDialog
extends JDialog
implements PropertyPanelValidationListener,
SrComponentStatusBarInterface {
    private SrPropertyPanel m_pan;
    private SrPropertyTabbedPanel m_tabbedPan;
    private boolean m_showLastUpdatePan;
    private boolean m_showStatusPan;
    private AbstractAction[] m_externalButtons;
    private boolean m_useClose;
    private boolean m_useHelp;
    private boolean m_useRefresh;
    private JLabel m_lastUpdateLbl;
    private SrComponentStatusBarPanel m_statusPanel;
    private String m_lastUpdateStr;
    private String m_selectedBtt;
    protected JButton m_okBtt;
    private HashMap m_validTabs;
    private SrPanel m_topPanel;
    private SrPanel m_bottomPanel;
    private MouseAdapter m_mouseListener = new MouseAdapter(){};
    public static final String NONE_BUTTON = "None";
    public static final String OK_BUTTON = "Ok";
    public static final String CANCEL_BUTTON = "Cancel";
    public static final String HELP_BUTTON = "Help";
    public static final String CLOSE_BUTTON = "Close";
    public static final String REFRESH_BUTTON = "Refresh";
    public static final String START_STATUS_MSG = "<html><font color=blue><b>&nbsp;Status : </b></font> ";
    public static final String END_MSG = " </html>";
    public static final String START_UPDATE_MSG = "<html><font color=blue><b>&nbsp;Last update : </b></font> ";

    public SrPropertyDialog(JFrame frm, SrPropertyPanel pan, String title) {
        super(frm, title, false);
        this.m_pan = pan;
        this.init();
        this.initComponents();
    }

    public SrPropertyDialog(JFrame frm, SrPropertyTabbedPanel pan, String title) {
        super(frm, title, false);
        this.m_tabbedPan = pan;
        this.init();
        this.initComponents();
    }

    private void init() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SrPropertyDialog.this.onClose(new ActionEvent(this, 1001, "Window Closing"));
            }
        });
        this.m_showLastUpdatePan = false;
        this.m_showStatusPan = true;
        this.m_useClose = false;
        this.m_useRefresh = false;
        this.m_useHelp = false;
        if (this.m_pan != null) {
            this.m_pan.addValidationListener(this);
        } else {
            this.m_validTabs = new HashMap();
            String[] tabs = this.m_tabbedPan.getTabOrder();
            int i = 0;
            while (i < tabs.length) {
                SrPropertyPanel pan = this.m_tabbedPan.getTabPanel(tabs[i]);
                pan.addValidationListener(this);
                this.m_validTabs.put(tabs[i], new Boolean(false));
                ++i;
            }
        }
    }

    public JDialog getInnerDialog() {
        return this;
    }

    public void showLastUpdateBar(boolean show) {
        this.m_showLastUpdatePan = show;
    }

    public void showStatusBar(boolean show) {
        this.m_showStatusPan = show;
    }

    public void setYourOwnDialogButtons(AbstractAction[] actions) {
        this.m_externalButtons = actions;
    }

    public void addHelpButton() {
        this.m_useHelp = true;
    }

    public void useCloseButton(boolean use) {
        this.m_useClose = use;
    }

    public void useRefreshButton(boolean use) {
        this.m_useRefresh = use;
    }

    private void initComponents() {
        this.m_selectedBtt = NONE_BUTTON;
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        SrPanel mainPan = new SrPanel(new BorderLayout());
        if (this.m_showLastUpdatePan) {
            SrPanel lastUpdatePan = new SrPanel(new BorderLayout());
            lastUpdatePan.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
            this.m_lastUpdateLbl = new JLabel("<html><font color=blue><b>&nbsp;Last update : </b></font>  </html>", 2);
            SrPanel dummy1 = new SrPanel(new FlowLayout(2));
            SrPanel dummy2 = new SrPanel(new FlowLayout(2));
            lastUpdatePan.add((Component)dummy1, "North");
            lastUpdatePan.add((Component)this.m_lastUpdateLbl, "Center");
            lastUpdatePan.add((Component)dummy2, "South");
            mainPan.add((Component)lastUpdatePan, "North");
        }
        if (this.m_tabbedPan != null) {
            mainPan.add((Component)this.m_tabbedPan, "Center");
        } else if (this.m_pan != null) {
            mainPan.add((Component)this.m_pan, "Center");
        }
        SrPanel lowerPan = new SrPanel(new BorderLayout());
        mainPan.add((Component)lowerPan, "South");
        SrPanel buttonPan = new SrPanel(new FlowLayout(1));
        buttonPan.setBorder(BorderFactory.createEtchedBorder());
        SrPanel dummyPan = new SrPanel(new FlowLayout(0));
        dummyPan.add(new JLabel());
        lowerPan.add((Component)dummyPan, "North");
        lowerPan.add((Component)buttonPan, "Center");
        if (this.m_externalButtons != null && this.m_externalButtons.length > 0) {
            int i = 0;
            while (i < this.m_externalButtons.length) {
                JButton btt = new JButton(this.m_externalButtons[i]);
                buttonPan.add(btt);
                ++i;
            }
        } else if (this.m_useClose) {
            AbstractAction closeAct = new AbstractAction(CLOSE_BUTTON){

                public void actionPerformed(ActionEvent e) {
                    SrPropertyDialog.this.onClose(e);
                    SrPropertyDialog.this.m_selectedBtt = SrPropertyDialog.CLOSE_BUTTON;
                }
            };
            JButton closeBtt = new JButton(closeAct);
            buttonPan.add(closeBtt);
            closeBtt.registerKeyboardAction(closeAct, enter, 2);
            this.getRootPane().setDefaultButton(closeBtt);
        } else {
            AbstractAction okAct = new AbstractAction(OK_BUTTON){

                public void actionPerformed(ActionEvent e) {
                    SrPropertyDialog.this.onOK(e);
                    SrPropertyDialog.this.m_selectedBtt = SrPropertyDialog.OK_BUTTON;
                }
            };
            this.m_okBtt = new JButton(okAct);
            buttonPan.add(this.m_okBtt);
            this.m_okBtt.registerKeyboardAction(okAct, enter, 2);
            this.getRootPane().setDefaultButton(this.m_okBtt);
            AbstractAction cancelAct = new AbstractAction(CANCEL_BUTTON){

                public void actionPerformed(ActionEvent e) {
                    SrPropertyDialog.this.onCancel(e);
                    SrPropertyDialog.this.m_selectedBtt = SrPropertyDialog.CANCEL_BUTTON;
                }
            };
            JButton cancelBtt = new JButton(cancelAct);
            buttonPan.add(cancelBtt);
            KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
            cancelBtt.registerKeyboardAction(cancelAct, escape, 2);
            this.m_okBtt.setPreferredSize(cancelBtt.getPreferredSize());
            if (this.m_useHelp) {
                AbstractAction helpAct = new AbstractAction(HELP_BUTTON){

                    public void actionPerformed(ActionEvent e) {
                        SrPropertyDialog.this.onHelp(e);
                        SrPropertyDialog.this.m_selectedBtt = SrPropertyDialog.HELP_BUTTON;
                    }
                };
                JButton helpBtt = new JButton(helpAct);
                buttonPan.add(helpBtt);
            }
        }
        if (this.m_showStatusPan) {
            this.m_statusPanel = new SrComponentStatusBarPanel();
            lowerPan.add((Component)this.m_statusPanel, "South");
        }
        SrPanel finalPanel = new SrPanel(new BorderLayout());
        if (this.m_topPanel != null) {
            finalPanel.add((Component)this.m_topPanel, "North");
        }
        finalPanel.add((Component)mainPan, "Center");
        if (this.m_bottomPanel != null) {
            finalPanel.add((Component)this.m_bottomPanel, "South");
        }
        this.setContentPane(finalPanel);
        if (this.m_pan != null) {
            this.m_pan.onUpdateEvent(null);
        }
    }

    public void show() {
        this.pack();
        this.setSize(this.getWidthByTitle(), this.getHeight());
        Dimension screenDim = this.getToolkit().getScreenSize();
        Rectangle abounds = this.getBounds();
        this.setLocation((screenDim.width - abounds.width) / 2, (screenDim.height - abounds.height) / 2);
        super.show();
    }

    protected void onOK(ActionEvent e) {
        this.dispose();
    }

    protected void onCancel(ActionEvent e) {
        this.dispose();
    }

    protected void onHelp(ActionEvent e) {
    }

    public void doOnClose() {
        this.onClose(null);
    }

    protected void onClose(ActionEvent e) {
        this.dispose();
    }

    protected void onRefresh(ActionEvent e) {
    }

    public String getLastUpdateStr() {
        String str = "";
        if (this.m_lastUpdateStr != null) {
            str = this.m_lastUpdateStr;
        }
        return str;
    }

    public String getStatusStr() {
        return this.m_statusPanel.getStatusStr();
    }

    public void setLastUpdateStr(String lastUpdateStr) {
        if (this.m_lastUpdateLbl != null && lastUpdateStr != null) {
            this.m_lastUpdateStr = lastUpdateStr;
            this.m_lastUpdateLbl.setText(START_UPDATE_MSG + this.m_lastUpdateStr + END_MSG);
        }
    }

    public void setStatusStr(String statusStr) {
        this.m_statusPanel.setStatusStr(statusStr);
    }

    public void onPanelPropertyChanged(PropertyPanelValidationEvent e) {
        String panelName = e.getPanelName();
        Vector nonValidFields = e.getNonValidFields();
        boolean valid = true;
        if (this.m_pan != null && this.m_pan.getPanelName().equals(panelName)) {
            if (!nonValidFields.isEmpty()) {
                valid = false;
            }
        } else if (this.m_tabbedPan != null) {
            if (!nonValidFields.isEmpty()) {
                this.m_validTabs.put(panelName, new Boolean(false));
                valid = false;
            } else {
                this.m_validTabs.put(panelName, new Boolean(true));
                String[] tabs = this.m_tabbedPan.getTabOrder();
                int i = 0;
                while (i < tabs.length) {
                    Boolean bool;
                    if (!tabs[i].equals(panelName) && this.m_validTabs.containsKey(tabs[i]) && !(bool = (Boolean)this.m_validTabs.get(tabs[i])).booleanValue()) {
                        valid = false;
                        break;
                    }
                    ++i;
                }
            }
        }
        if (this.m_okBtt != null) {
            this.m_okBtt.setEnabled(valid);
        }
        if (valid) {
            this.setStatusStr("");
        } else {
            this.setStatusStr("Please fill the missing data marked by the red asterisks");
        }
    }

    public SrPropertyPanel getPanel() {
        return this.m_pan;
    }

    public SrPropertyTabbedPanel getTabbedPanel() {
        return this.m_tabbedPan;
    }

    public void addTopPanel(SrPanel topPanel) {
        this.m_topPanel = topPanel;
    }

    public void addBottomPanel(SrPanel bottomPanel) {
        this.m_bottomPanel = bottomPanel;
    }

    private int getWidthByTitle() {
        int titlePhyLength = this.getFontMetrics(this.getFont()).charsWidth(this.getTitle().toCharArray(), 0, this.getTitle().length());
        return Math.max(this.getWidth(), titlePhyLength + 80);
    }

    public void setWaitCursor() {
        this.setCursor(new Cursor(3));
        this.getGlassPane().addMouseListener(this.m_mouseListener);
        this.getGlassPane().setVisible(true);
    }

    public void setDefaultCursor() {
        this.setCursor(new Cursor(0));
        this.getGlassPane().removeMouseListener(this.m_mouseListener);
        this.getGlassPane().setVisible(false);
    }

    public static void main(String[] args) {
        System.setProperty("swing.noxp", "true");
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SrPropertyPanel pan = new SrPropertyPanel("Test", true, false, false);
        pan.addProperty("SrCheckbox", (SrComponent)new SrCheckbox());
        pan.addProperty("SrComboBox", (SrComponent)new SrComboBox(new Object[]{"1", "2", "3"}));
        pan.addProperty("SrDateField", (SrComponent)new SrDateField());
        pan.addProperty("SrTimeField", (SrComponent)new SrTimeField());
        pan.addProperty("SrHexAddressTextField", (SrComponent)new SrHexAddressTextField());
        pan.addProperty("SrIPTextField", (SrComponent)new SrIPTextField());
        pan.addProperty("SrHexTextField", (SrComponent)new SrHexTextField());
        pan.addProperty("SrIntegerTextField", (SrComponent)new SrIntegerTextField());
        pan.addProperty("SrLabelField", (SrComponent)new SrLabelField("SrLabelField"));
        SrWidget dateW = new SrWidget("Date", new SrDateField(), true, false, true, true, null);
        pan.addProperty(dateW);
        SrPropertyPanel pan2 = new SrPropertyPanel("Test2", true, false, false);
        pan2.addProperty("Text", (SrComponent)new SrTextField());
        SrRadioButtonsPanel set = new SrRadioButtonsPanel();
        set.addRadio("one");
        set.addRadio("two");
        set.addRadio("three");
        set.setTitle("SrRadioButtonsPanel");
        pan.addProperty("SrRadioButtonsPanel", (SrComponent)set);
        pan.addProperty("SrTextAreaField", (SrComponent)new SrTextAreaField("Hello", 4, 10));
        pan.addProperty("SrTextField", (SrComponent)new SrTextField());
        pan.addProperty("SrPasswordTextField", (SrComponent)new SrPasswordTextField());
        SrPropertyTabbedPanel tabbed = new SrPropertyTabbedPanel(new SrPropertyPanel[]{pan, pan2});
        JFrame frm = new JFrame();
        SrPropertyDialog dlg = new SrPropertyDialog(frm, tabbed, "Test");
        dlg.addHelpButton();
        dlg.showLastUpdateBar(true);
        dlg.showStatusBar(true);
        dlg.show();
        System.exit(0);
    }
}

