/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.SrTablePanel;
import com.sanrad.swing.SrTreePanel;
import com.sanrad.swing.components.SrMenu;
import com.sanrad.swing.components.SrMenuItem;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class SrPopupMenu
extends JPopupMenu {
    protected List m_actions;
    protected JComponent m_comToWorkWith;
    private ArrayList m_lastActionSet;
    private HashMap m_actionToitem;
    protected Vector m_listeners;

    public SrPopupMenu(JComponent workWith) {
        this.m_comToWorkWith = workWith;
        this.m_listeners = new Vector();
        this.m_actionToitem = new HashMap();
    }

    public void attachActions(List actions) {
        this.m_actions = actions;
        this.addAllActions(this, this.m_actions);
        this.m_lastActionSet = new ArrayList();
        this.m_lastActionSet.addAll(this.m_actions);
    }

    protected void addMenuItem(AbstractAction action, int index) {
        SrMenuItem item = new SrMenuItem(action);
        super.insert(item, index);
        this.m_actionToitem.put(action, item);
    }

    protected void addMenuItem(SrMenu parent, AbstractAction action, int index) {
        SrMenuItem item = new SrMenuItem(action);
        parent.add((Component)item, index);
        this.m_actionToitem.put(action, item);
    }

    protected void addMenu(SrMenu menu, int index) {
        super.insert(menu, index);
        this.m_actionToitem.put((AbstractAction)menu.getAction(), menu);
    }

    protected void addMenuItem(AbstractAction action, int[] menuTreePath, int index) {
        this.addMenuComponent(new SrMenuItem(action), menuTreePath, index);
    }

    protected void addMenu(AbstractAction action, int[] menuTreePath, int index) {
        this.addMenuComponent(new SrMenu(action), menuTreePath, index);
    }

    protected void addMenuComponent(JMenuItem item, int[] menuTreePath, int index) {
        if (menuTreePath != null) {
            ArrayList<Integer> _menuTreePath = new ArrayList<Integer>();
            int i = 0;
            while (i < menuTreePath.length) {
                _menuTreePath.add(new Integer(menuTreePath[i]));
                ++i;
            }
            int menuIndex = (Integer)_menuTreePath.remove(0);
            this.isnertMenuComponentInPlace((JMenu)this.getComponent(menuIndex), item, _menuTreePath, index);
        } else {
            super.insert(item, index);
            this.m_actionToitem.put(item.getAction(), item);
        }
    }

    private void isnertMenuComponentInPlace(JMenu menu, JMenuItem item, ArrayList menuTreePath, int index) {
        if (menuTreePath.isEmpty()) {
            menu.insert(item, index);
            this.m_actionToitem.put(item.getAction(), item);
        } else {
            int menuIndex = (Integer)menuTreePath.remove(0);
            JMenu subMenu = (JMenu)menu.getMenuComponent(menuIndex);
            this.isnertMenuComponentInPlace(subMenu, item, menuTreePath, index);
        }
    }

    public void show(MouseEvent e) {
        List currentActions = this.validateActions(e);
        if (currentActions != null && currentActions.size() > 0) {
            if (!this.m_lastActionSet.equals(currentActions)) {
                this.removeAllActions();
                this.addAllActions(this, currentActions);
                this.m_lastActionSet = new ArrayList();
                this.m_lastActionSet.addAll(currentActions);
            }
            JComponent invoker = this.m_comToWorkWith;
            if (this.m_comToWorkWith instanceof SrTreePanel) {
                invoker = ((SrTreePanel)this.m_comToWorkWith).getTreeObject();
            } else if (this.m_comToWorkWith instanceof SrTablePanel) {
                invoker = ((SrTablePanel)this.m_comToWorkWith).getTable();
            }
            this.show(invoker, e.getX(), e.getY());
        }
    }

    private void addAllActions(Object container, List currentActions) {
        int i = 0;
        while (i < currentActions.size()) {
            Object obj = currentActions.get(i);
            if (obj instanceof List) {
                List menuItemList = (List)obj;
                ArrayList menuItemListCloned = new ArrayList(menuItemList);
                AbstractAction action = (AbstractAction)menuItemListCloned.remove(0);
                SrMenu newMenu = new SrMenu(action);
                this.addToMenu(container, newMenu);
                this.addAllActions(newMenu, menuItemListCloned);
                this.m_actionToitem.put(action, newMenu);
            } else if (obj instanceof AbstractAction) {
                AbstractAction act = (AbstractAction)obj;
                SrMenuItem item = new SrMenuItem(act);
                this.addToMenu(container, item);
                this.m_actionToitem.put(act, item);
            } else if (obj instanceof JPopupMenu.Separator) {
                this.addToMenu(container, (JPopupMenu.Separator)obj);
            }
            ++i;
        }
    }

    private void addToMenu(Object container, JComponent item) {
        if (container instanceof JPopupMenu) {
            ((JPopupMenu)container).add(item);
        } else if (container instanceof SrMenu) {
            ((SrMenu)container).add(item);
        }
    }

    public void removeItemFromMenu(AbstractAction act) {
        if (this.m_actionToitem.containsKey(act)) {
            this.m_actionToitem.remove(act);
            this.m_actions.remove(act);
        }
    }

    protected void removeAllActions() {
        this.removeAll();
        this.m_lastActionSet.clear();
        this.m_actionToitem.clear();
    }

    protected List validateActions(MouseEvent e) {
        return this.m_actions;
    }

    public void addListener(EventListener l) {
        if (!this.m_listeners.contains(l)) {
            this.m_listeners.add(l);
        }
    }

    public void removeListener(EventListener l) {
        this.m_listeners.remove(l);
    }

    public SrMenuItem getSrMenuItem(AbstractAction act) {
        SrMenuItem menuItem = null;
        JMenuItem item = (JMenuItem)this.m_actionToitem.get(act);
        if (item instanceof SrMenuItem) {
            menuItem = (SrMenuItem)item;
        }
        return menuItem;
    }

    public SrMenu getSrMenu(AbstractAction act) {
        SrMenu menu = null;
        JMenuItem item = (JMenuItem)this.m_actionToitem.get(act);
        if (item instanceof SrMenu) {
            menu = (SrMenu)item;
        }
        return menu;
    }

    public boolean isMenuItemCreated(AbstractAction act) {
        return this.m_actionToitem.containsKey(act);
    }

    protected List getCurrentActions() {
        return this.m_actions;
    }
}

