/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.components.SrComponent;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class SrCellEditor
extends AbstractCellEditor
implements TableCellEditor,
FocusListener,
KeyListener {
    private SrComponent m_com;
    private TableColumn m_tableCol;
    private int m_headerWidth;
    private JLabel m_dummy;
    private int m_maxWidth;
    private boolean m_escPressed;
    private CellEditorListener m_cellEditorListener;

    public SrCellEditor(TableColumn column, SrComponent com, int headerWidth) {
        this.m_com = com;
        this.m_tableCol = column;
        this.m_maxWidth = this.m_headerWidth = headerWidth;
        this.m_escPressed = false;
        this.m_dummy = new JLabel();
        final SrCellEditor editor = this;
        this.m_cellEditorListener = new CellEditorListener(){

            public void editingStopped(ChangeEvent e) {
                this.resize();
            }

            public void editingCanceled(ChangeEvent e) {
                this.resize();
            }

            private void resize() {
                int width = SrCellEditor.this.m_headerWidth;
                Object obj = editor.getCellEditorValue();
                if (obj instanceof String) {
                    SrCellEditor.this.m_dummy.setText((String)editor.getCellEditorValue());
                    if (SrCellEditor.this.m_headerWidth < ((SrCellEditor)SrCellEditor.this).m_dummy.getPreferredSize().width) {
                        width = ((SrCellEditor)SrCellEditor.this).m_dummy.getPreferredSize().width;
                    }
                }
                if (SrCellEditor.this.m_maxWidth < width + 5) {
                    SrCellEditor.this.m_maxWidth = width + 5;
                }
                SrCellEditor.this.m_tableCol.setPreferredWidth(SrCellEditor.this.m_maxWidth);
            }
        };
        this.addCellEditorListener(this.m_cellEditorListener);
        this.m_com.getComponent().addFocusListener(this);
        this.m_com.getComponent().addKeyListener(this);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.m_com.setValue(value);
        return (Component)((Object)this.m_com);
    }

    public Object getCellEditorValue() {
        Object value = null;
        if (this.m_com != null) {
            value = this.m_com.getValue();
        }
        return value;
    }

    public boolean isCellEditable(EventObject anEvent) {
        int comWidth = (int)this.m_com.getComponent().getPreferredSize().getWidth() + 1;
        if (comWidth > this.m_headerWidth) {
            this.m_tableCol.setPreferredWidth(comWidth);
        }
        return true;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (!this.m_escPressed) {
            this.stopCellEditing();
        }
    }

    public void keyPressed(KeyEvent e) {
        this.m_escPressed = e.getKeyCode() == 27;
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    protected void finalize() throws Throwable {
        this.m_com.getComponent().removeFocusListener(this);
        this.m_com.getComponent().removeKeyListener(this);
        this.removeCellEditorListener(this.m_cellEditorListener);
        super.finalize();
    }
}

