/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.AboutDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.Timer;

public class SplashWindow
extends JWindow {
    private BorderLayout borderLayout1 = new BorderLayout();
    private JLabel splashImage = new JLabel();
    private SplashPanel splashPanel = new SplashPanel();
    private String version = null;
    private int versionX;
    private int versionY;
    private String message;
    private String stopMessage;
    private Progress progress;
    private boolean startProgress = false;
    private int progressCounter = 0;

    public SplashWindow(ImageIcon splashImageIcon) {
        try {
            this.jbInit();
            this.splashImage.setIcon(splashImageIcon);
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension labelSize = this.splashImage.getPreferredSize();
            this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SplashWindow(ImageIcon splashImageIcon, String version, int versionX, int versionY) {
        this(splashImageIcon);
        this.version = version;
        this.versionX = versionX;
        this.versionY = versionY;
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.splashPanel.setLayout(new BorderLayout());
        this.splashPanel.add((Component)this.splashImage, "Center");
        this.getContentPane().add((Component)this.splashPanel, "Center");
    }

    public void drawMsgLabel(String msg, boolean isProgress) {
        this.message = msg;
        this.startProgress = isProgress;
        this.stopMessage = null;
        this.splashPanel.drawMassage(this.splashPanel.getGraphics());
    }

    public void error(String msg) {
        this.finishProgress(msg);
    }

    public void finishProgress(String msg) {
        this.stopMessage = msg;
        this.progress.stop();
        if (msg != null) {
            this.splashPanel.drawMsgAfterProgress(this.splashPanel.getGraphics(), msg);
        }
        this.progress.isEnabled = false;
    }

    public void dispose() {
        if (this.progress != null && this.progress.timer != null) {
            this.progress.timer.stop();
        }
        super.dispose();
    }

    class SplashPanel
    extends JPanel {
        SplashPanel() {
        }

        public void paint(Graphics g) {
            super.paint(g);
            Color prevColor = g.getColor();
            Font prevFont = g.getFont();
            if (SplashWindow.this.version != null) {
                g.setColor(AboutDialog.VERSION_COLOR);
                g.setFont(AboutDialog.VERSION_FONT);
                g.drawString(SplashWindow.this.version, SplashWindow.this.versionX, SplashWindow.this.versionY);
                g.setFont(prevFont);
            }
            if (SplashWindow.this.message != null) {
                this.drawMassage(g);
            }
            g.setColor(prevColor);
            g.setFont(prevFont);
        }

        private void drawMassage(Graphics g) {
            Color prevColor = g.getColor();
            Font prevFont = g.getFont();
            Font msgFont = g.getFont().deriveFont((float)(g.getFont().getSize() + 1));
            FontMetrics fm = g.getFontMetrics(msgFont);
            int msgX = 10;
            int msgY = this.getHeight() - 10;
            int msgWidth = fm.stringWidth(SplashWindow.this.message);
            g.setColor(Color.BLACK);
            g.setFont(msgFont);
            g.drawString(SplashWindow.this.message, msgX, msgY);
            if (SplashWindow.this.startProgress) {
                if (SplashWindow.this.progress == null) {
                    SplashWindow.this.progress = new Progress();
                    ((SplashWindow)SplashWindow.this).progress.location = new Point(msgX + msgWidth + 5, msgY - ((SplashWindow)SplashWindow.this).progress.diameter);
                    ((SplashWindow)SplashWindow.this).progress.isEnabled = true;
                    SplashWindow.this.progress.start(g);
                } else {
                    SplashWindow.this.progress.paintProgress(g);
                    if (SplashWindow.this.stopMessage != null) {
                        this.drawMsgAfterProgress(g, SplashWindow.this.stopMessage);
                    }
                }
            }
            g.setColor(prevColor);
            g.setFont(prevFont);
        }

        private void drawMsgAfterProgress(Graphics g, String msg) {
            Color prevColor = g.getColor();
            Font prevFont = g.getFont();
            Font msgFont = g.getFont().deriveFont((float)(g.getFont().getSize() + 1));
            FontMetrics fm = g.getFontMetrics(msgFont);
            int msgY = this.getHeight() - 10;
            g.setColor(Color.BLACK);
            g.setFont(msgFont);
            g.drawString(msg, ((SplashWindow)SplashWindow.this).progress.location.x + SplashWindow.this.progress.getWidth() + 3, msgY);
            g.setColor(prevColor);
            g.setFont(prevFont);
        }
    }

    private static class Progress {
        int diameter = 2;
        int counter = 0;
        boolean isEnabled = false;
        Timer timer;
        Point location;

        Progress() {
        }

        void paintProgress(Graphics g) {
            Color prevColor = g.getColor();
            g.setColor(Color.BLACK);
            int i = 0;
            while (i < this.counter) {
                g.drawOval(this.location.x + this.diameter + i * (this.diameter + this.diameter / 2), this.location.y, this.diameter, this.diameter);
                ++i;
            }
            g.setColor(prevColor);
        }

        void stepProgressForward(Graphics g) {
            Color prevColor = g.getColor();
            g.setColor(Color.BLACK);
            g.drawOval(this.location.x + this.diameter + this.counter++ * (this.diameter + this.diameter / 2), this.location.y, this.diameter, this.diameter);
            g.setColor(prevColor);
        }

        int getWidth() {
            return this.diameter + this.counter * (this.diameter + this.diameter / 2);
        }

        void start(Graphics g) {
            this.timer = new Timer(750, new ActionListener(this, g){
                final /* synthetic */ Progress this$1;
                private final /* synthetic */ Graphics val$g;
                {
                    this.this$1 = progress;
                    this.val$g = graphics;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.stepProgressForward(this.val$g);
                }
            });
            this.timer.start();
        }

        void stop() {
            if (this.timer != null) {
                this.timer.stop();
            }
        }
    }
}

