/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.OKCancelDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.Timer;

public abstract class OKCancelRefreshDialog
extends OKCancelDialog {
    private JButton btnRefresh;
    private Timer refreshTimer = null;
    private Timer timerCounter = null;
    private JLabel timerCounterLabel;
    int counter = -1;

    protected OKCancelRefreshDialog(JFrame owner, String title) {
        super(owner, title);
    }

    protected OKCancelRefreshDialog(JDialog owner, String title) {
        super(owner, title);
    }

    protected OKCancelRefreshDialog(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
    }

    protected OKCancelRefreshDialog(JDialog dialog, String title, boolean modal) {
        super(dialog, title, modal);
    }

    protected void setButtons() {
        super.setButtons();
        this.btnRefresh = new JButton();
        this.btnRefresh.setText("Refresh");
        this.btnRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OKCancelRefreshDialog.this.btnRefresh_actionPerformed(e);
            }
        });
        this.setLastUpdateText();
    }

    protected void setTimerDelay(int delay) {
        if (this.refreshTimer != null) {
            this.refreshTimer.setDelay(delay);
        }
    }

    protected void startRefreshTimer(int delay) {
        if (this.refreshTimer == null) {
            ActionListener taskPerformer = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    OKCancelRefreshDialog.this.refreshInvoked();
                }
            };
            this.refreshTimer = new Timer(delay, taskPerformer);
            this.refreshTimer.start();
            this.updateTimerCounterLabel();
        } else {
            this.refreshTimer.setDelay(delay);
            this.refreshTimer.restart();
        }
        this.refreshInvoked();
    }

    protected void stopTimer() {
        if (this.refreshTimer != null) {
            this.refreshTimer.stop();
            this.refreshTimer = null;
        }
        if (this.timerCounter != null) {
            this.timerCounter.stop();
            this.timerCounter = null;
        }
    }

    private void btnRefresh_actionPerformed(ActionEvent e) {
        this.refreshInvoked();
    }

    private void refreshInvoked() {
        this.doOnRefresh();
        this.setLastUpdateText();
    }

    private void setLastUpdateText() {
        String lastUpdate = new Date(System.currentTimeMillis()).toString();
        this.setMessageText("Last update: " + lastUpdate);
        if (this.refreshTimer != null) {
            this.counter = this.refreshTimer.getDelay() / 1000;
            this.updateTimerCounterLabel();
        }
    }

    private void updateTimerCounterLabel() {
    }

    protected abstract void doOnRefresh();

    public void dispose() {
        this.stopTimer();
        super.dispose();
    }
}

