/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrComponentStatusBarInterface;
import com.sanrad.swing.SrComponentStatusBarPanel;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.components.SrTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public abstract class OKCancelDialog
extends JDialog
implements SrComponentStatusBarInterface {
    private boolean okPressed = false;
    protected JPanel buttonsPanel = new JPanel();
    protected JPanel messagePanel = new JPanel();
    private FlowLayout flowLayout2 = new FlowLayout();
    private FlowLayout flowLayout3 = new FlowLayout(0, 10, 0);
    protected JButton btnCancel = new JButton();
    protected JButton btnOK = new JButton();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JLabel messageLabel = new JLabel();
    private SrComponentStatusBarPanel m_statusBar = new SrComponentStatusBarPanel();
    private boolean m_useStatusBar = true;

    private OKCancelDialog(JFrame owner) {
        super((Frame)owner, true);
        this.init();
    }

    protected OKCancelDialog(JFrame owner, String title) {
        this(owner);
        this.setTitle(title);
    }

    protected OKCancelDialog(JDialog owner, String title) {
        super((Dialog)owner, true);
        this.init();
        this.setTitle(title);
    }

    protected OKCancelDialog(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.init();
    }

    protected OKCancelDialog(JDialog dialog, String title, boolean modal) {
        super(dialog, title, modal);
        this.init();
    }

    protected void doFirst() {
    }

    private void init() {
        try {
            this.jbInit();
            this.setButtons();
            this.btnOK.setPreferredSize(this.btnCancel.getPreferredSize());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.buttonsPanel.setLayout(new FlowLayout(1, 5, 5));
        this.buttonsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.messagePanel.setLayout(this.flowLayout3);
        this.flowLayout2.setAlignment(2);
        this.doFirst();
        if (this.isStatusBarInUse()) {
            JPanel statusPlusButtonPanel = new JPanel(new BorderLayout());
            statusPlusButtonPanel.add((Component)this.buttonsPanel, "Center");
            statusPlusButtonPanel.add((Component)this.m_statusBar, "South");
            this.getContentPane().add((Component)statusPlusButtonPanel, "South");
        } else {
            this.getContentPane().add((Component)this.buttonsPanel, "South");
        }
        this.getContentPane().add((Component)this.messagePanel, "North");
        this.buttonsPanel.add((Component)this.btnOK, null);
        this.buttonsPanel.add((Component)this.btnCancel, null);
        this.messagePanel.add((Component)this.messageLabel, null);
        this.setBackgroungColor(this.buttonsPanel);
        this.setBackgroungColor(this.messagePanel);
    }

    protected void btnOK_actionPerformed(ActionEvent e) {
        this.okPressed = true;
        this.dispose();
        this.doOnOK();
    }

    private void btnCancel_actionPerformed(ActionEvent e) {
        this.doOnCancel();
        this.dispose();
    }

    public void inProccess(String message) {
        StatusPanel.getInstance().setLevel(StatusPanel.NO_INFO);
    }

    public boolean isOKPressed() {
        return this.okPressed;
    }

    protected JPanel createPanel(JComponent c1, JComponent c2) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(c1);
        panel.add(c2);
        return panel;
    }

    protected SrPanel createSrPanel(JComponent c1, JComponent c2) {
        SrPanel panel = new SrPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(c1);
        if (c2 != null) {
            panel.add(c2);
        }
        return panel;
    }

    protected void addCenterPanel(JPanel panel) {
        this.getContentPane().add((Component)panel, "Center");
    }

    protected abstract void doOnOK();

    public abstract void doOnCancel();

    protected void setBackgroungColor(JComponent component) {
        component.setBackground(LookAndFill.DIALOG_COLOR);
    }

    protected SrTextField getUnknownTextField() {
        SrTextField txtField = new SrTextField();
        txtField.setText("unknown");
        txtField.setEnabled(false);
        return txtField;
    }

    protected void setOKButtonText() {
        this.btnOK.setText("OK");
    }

    protected void setCancelButtonText() {
        this.btnCancel.setText("Cancel");
    }

    protected void setButtons() {
        this.setOKButtonText();
        this.setCancelButtonText();
        AbstractAction okAct = new AbstractAction(this.btnOK.getText()){

            public void actionPerformed(ActionEvent e) {
                OKCancelDialog.this.btnOK_actionPerformed(e);
            }
        };
        AbstractAction cancelAct = new AbstractAction(this.btnCancel.getText()){

            public void actionPerformed(ActionEvent e) {
                OKCancelDialog.this.btnCancel_actionPerformed(e);
            }
        };
        this.btnOK.setAction(okAct);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        this.btnOK.registerKeyboardAction(okAct, enter, 2);
        this.btnCancel.setAction(cancelAct);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
        this.btnCancel.registerKeyboardAction(cancelAct, escape, 2);
        this.setDefaultButton();
    }

    protected void setDefaultButton() {
        this.getRootPane().setDefaultButton(this.btnOK);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setDefaultButton();
            Dimension screenDim = this.getToolkit().getScreenSize();
            Rectangle abounds = this.getBounds();
            this.setLocation((screenDim.width - abounds.width) / 2, (screenDim.height - abounds.height) / 2);
        }
        super.setVisible(visible);
    }

    public void show() {
        Dimension screenDim = this.getToolkit().getScreenSize();
        Rectangle abounds = this.getBounds();
        this.setLocation((screenDim.width - abounds.width) / 2, (screenDim.height - abounds.height) / 2);
        super.show();
    }

    protected void setMessageText(String msg) {
        this.messageLabel.setText(msg);
    }

    public String getStatusStr() {
        return this.m_statusBar.getStatusStr();
    }

    public void setStatusStr(String statusStr) {
        this.m_statusBar.setStatusStr(statusStr);
    }

    protected boolean isStatusBarInUse() {
        return this.m_useStatusBar;
    }
}

