/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.swing;

import com.sanrad.swing.ImageObject;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.ToolBarListener;
import com.sanrad.swing.ToolBarPanel;
import com.sanrad.swing.UpperPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public abstract class FrameView
extends JFrame {
    protected static final String STATUS_READY = "Ready";
    private BorderLayout borderLayout1 = new BorderLayout();
    protected UpperPanel upperPanel = new UpperPanel();
    private FlowLayout flowLayout1 = new FlowLayout();
    private JPanel topPanel = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JPanel mainPanel = new JPanel();
    private JLayeredPane layeredPanel = new JLayeredPane();
    protected JLabel titleLabel = new JLabel();
    protected GridBagConstraints gbc;

    protected FrameView() {
        this.setIconImage(ImageObject.APP_ICON.getImageIcon().getImage());
        this.getContentPane().setLayout(this.borderLayout1);
        this.upperPanel.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.upperPanel.setBorder(BorderFactory.createEtchedBorder());
        this.topPanel.setLayout(this.gridBagLayout1);
        this.gbc = this.getConstraintsForUpperPanel();
        this.topPanel.add((Component)this.upperPanel, this.gbc);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createEtchedBorder());
        this.gbc.gridy = 1;
        this.gbc.weighty = 1.0;
        this.gbc.fill = 1;
        this.gbc.ipady = 0;
        this.topPanel.add((Component)this.mainPanel, this.gbc);
        this.getContentPane().add((Component)this.topPanel, "Center");
        SrPanel buttonsPanel = this.createButtonsPanel();
        if (buttonsPanel != null) {
            this.getContentPane().add((Component)buttonsPanel, "South");
        }
        StatusPanel.getInstance().setText(STATUS_READY, StatusPanel.INFO, this);
        this.titleLabel.setFont(LookAndFill.UPPER_PANEL_TITLE_LABEL_FONT);
        this.titleLabel.setForeground(Color.white);
        this.titleLabel.setBounds(15, 90, 150, 15);
    }

    protected GridBagConstraints getConstraintsForUpperPanel() {
        return new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 73);
    }

    protected FrameView(String viewTitle) {
        this();
        this.setViewTitle(viewTitle, true);
    }

    protected FrameView(String viewTitle, Image icon) {
        this(viewTitle);
        this.setIconImage(icon);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected SrPanel createButtonsPanel() {
        return null;
    }

    protected void addToolBarPanel(ToolBarPanel toolBarPanel) {
        if (this instanceof ToolBarListener) {
            this.upperPanel.addToolBarPanel(toolBarPanel, (ToolBarListener)((Object)this));
        } else {
            System.err.println(this.getClass() + " is not instance of ToolBarListener in " + this.getClass() + "::addToolBarPanel()");
        }
    }

    protected ToolBarPanel getToolBarPanel() {
        return this.upperPanel.getToolBarPanel();
    }

    protected void removeToolBarPanel(ToolBarPanel toolBarPanel) {
        this.upperPanel.removeToolBarPanel((ToolBarListener)((Object)this));
    }

    protected void setToolBarPanel(ToolBarPanel toolBarPanel) {
        if (this instanceof ToolBarListener) {
            RepaintManager.currentManager(this).removeInvalidComponent(this.upperPanel);
            this.upperPanel.setToolBarPanel(toolBarPanel, (ToolBarListener)((Object)this));
            RepaintManager.currentManager(this).addInvalidComponent(this.upperPanel);
        } else {
            System.err.println(this.getClass() + " is not instance of ToolBarListener in " + this.getClass() + "::setToolBarPanel()");
        }
    }

    protected JPanel getMainPanel() {
        return this.mainPanel;
    }

    protected void setStatusLabel(String message) {
        StatusPanel.getInstance().setText(message, this);
    }

    protected void setViewTitle(String title, boolean isToolbarShown) {
        if (isToolbarShown) {
            this.upperPanel.setViewTitle(title);
        }
    }

    public void setVisible(boolean visible) {
        final boolean fVisible = visible;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FrameView.this.setItVisible(fVisible);
            }
        });
    }

    private void setItVisible(boolean visible) {
        super.setVisible(visible);
    }

    public void show() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FrameView.this.letItShow();
            }
        });
    }

    private void letItShow() {
        super.show();
    }
}

