/*
 * Decompiled with CFR 0.152.
 */
package BlowfishJ;

import BlowfishJ.BinConverter;
import BlowfishJ.BlowfishCBC;
import BlowfishJ.SHA1;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class BlowfishInputStream
extends InputStream {
    private PushbackInputStream _in;
    private String _passphrase;
    private BlowfishCBC _cbc;
    private long _iv;
    private byte[] _in_buffer;
    private int _bytes_read = 0;
    private int _buffer_index = 0;
    private boolean _started = false;

    public BlowfishInputStream(String passphrase, InputStream is) {
        this._passphrase = passphrase;
        this._in = new PushbackInputStream(new BufferedInputStream(is));
        SHA1 hasher = new SHA1();
        hasher.update(this._passphrase);
        hasher.finalize();
        this._cbc = new BlowfishCBC(hasher.getDigest(), 0L);
        hasher.clear();
        this._in_buffer = new byte[8];
    }

    public int read() throws IOException {
        if (!this._started) {
            this.decryptBuffer();
            if (this._bytes_read < 8) {
                return -1;
            }
            this.decryptBuffer();
            if (this._bytes_read == -1) {
                return -1;
            }
            this._buffer_index = 0;
        }
        if (this._bytes_read < this._in_buffer.length && this._buffer_index == this._bytes_read) {
            return -1;
        }
        if (this._buffer_index == this._bytes_read) {
            this.decryptBuffer();
            if (this._bytes_read == -1) {
                return -1;
            }
            this._buffer_index = 0;
        }
        int rtn = this._in_buffer[this._buffer_index] & 0xFF;
        ++this._buffer_index;
        return rtn;
    }

    private void decryptBuffer() throws IOException {
        this._bytes_read = this._in.read(this._in_buffer, 0, this._in_buffer.length);
        if (this._bytes_read == -1) {
            return;
        }
        if (!this._started) {
            if (this._bytes_read < this._in_buffer.length) {
                return;
            }
            long iv = BinConverter.byteArrayToLong(this._in_buffer, 0);
            this._cbc.setCBCIV(iv);
            this._started = true;
            return;
        }
        this._cbc.decrypt(this._in_buffer);
        int end = this._in.read();
        if (end == -1) {
            byte pad_count = this._in_buffer[this._in_buffer.length - 1];
            if (pad_count > this._in_buffer.length || pad_count < 1) {
                return;
            }
            this._bytes_read = this._in_buffer.length - pad_count;
            if (this._bytes_read == 0) {
                this._bytes_read = -1;
            }
        } else {
            this._in.unread(end);
        }
    }

    public boolean markSupported() {
        return this._in.markSupported();
    }

    public void mark(int readlimit) {
        ((FilterInputStream)this._in).mark(readlimit);
    }

    public int available() throws IOException {
        return this._in.available();
    }

    public void close() throws IOException {
        this._in.close();
        this._cbc.cleanUp();
    }
}

