/*
 * Decompiled with CFR 0.152.
 */
package BlowfishJ;

import BlowfishJ.BinConverter;
import BlowfishJ.BlowfishECB;

public class BlowfishCBC
extends BlowfishECB {
    long m_lCBCIV;

    public long getCBCIV() {
        return this.m_lCBCIV;
    }

    public void getCBCIV(byte[] dest) {
        BinConverter.longToByteArray(this.m_lCBCIV, dest, 0);
    }

    public void setCBCIV(long lNewCBCIV) {
        this.m_lCBCIV = lNewCBCIV;
    }

    public void setCBCIV(byte[] newCBCIV) {
        this.m_lCBCIV = BinConverter.byteArrayToLong(newCBCIV, 0);
    }

    public BlowfishCBC(byte[] bfkey) {
        super(bfkey);
        this.setCBCIV(0L);
    }

    public BlowfishCBC(byte[] bfkey, long lInitCBCIV) {
        super(bfkey);
        this.setCBCIV(lInitCBCIV);
    }

    public BlowfishCBC(byte[] bfkey, byte[] initCBCIV) {
        super(bfkey);
        this.setCBCIV(initCBCIV);
    }

    public void cleanUp() {
        this.m_lCBCIV = 0L;
        super.cleanUp();
    }

    private long encryptBlockCBC(long lPlainblock) {
        lPlainblock ^= this.m_lCBCIV;
        this.m_lCBCIV = lPlainblock = super.encryptBlock(lPlainblock);
        return this.m_lCBCIV;
    }

    private long decryptBlockCBC(long lCipherblock) {
        long lTemp = lCipherblock;
        lCipherblock = super.decryptBlock(lCipherblock);
        this.m_lCBCIV = lTemp;
        return lCipherblock ^= this.m_lCBCIV;
    }

    public void encrypt(byte[] inbuffer, byte[] outbuffer) {
        int nLen = inbuffer.length;
        for (int nI = 0; nI < nLen; nI += 8) {
            long lTemp = BinConverter.byteArrayToLong(inbuffer, nI);
            lTemp = this.encryptBlockCBC(lTemp);
            BinConverter.longToByteArray(lTemp, outbuffer, nI);
        }
    }

    public void encrypt(byte[] buffer) {
        int nLen = buffer.length;
        for (int nI = 0; nI < nLen; nI += 8) {
            long lTemp = BinConverter.byteArrayToLong(buffer, nI);
            lTemp = this.encryptBlockCBC(lTemp);
            BinConverter.longToByteArray(lTemp, buffer, nI);
        }
    }

    public void encrypt(int[] inbuffer, int[] outbuffer) {
        int nLen = inbuffer.length;
        for (int nI = 0; nI < nLen; nI += 2) {
            long lTemp = BinConverter.intArrayToLong(inbuffer, nI);
            lTemp = this.encryptBlockCBC(lTemp);
            BinConverter.longToIntArray(lTemp, outbuffer, nI);
        }
    }

    public void encrypt(int[] buffer) {
        int nLen = buffer.length;
        for (int nI = 0; nI < nLen; nI += 2) {
            long lTemp = BinConverter.intArrayToLong(buffer, nI);
            lTemp = this.encryptBlockCBC(lTemp);
            BinConverter.longToIntArray(lTemp, buffer, nI);
        }
    }

    public void encrypt(long[] inbuffer, long[] outbuffer) {
        int nLen = inbuffer.length;
        for (int nI = 0; nI < nLen; ++nI) {
            outbuffer[nI] = this.encryptBlockCBC(inbuffer[nI]);
        }
    }

    public void encrypt(long[] buffer) {
        int nLen = buffer.length;
        for (int nI = 0; nI < nLen; ++nI) {
            buffer[nI] = this.encryptBlockCBC(buffer[nI]);
        }
    }

    public void decrypt(byte[] inbuffer, byte[] outbuffer) {
        int nLen = inbuffer.length;
        for (int nI = 0; nI < nLen; nI += 8) {
            long lTemp = BinConverter.byteArrayToLong(inbuffer, nI);
            lTemp = this.decryptBlockCBC(lTemp);
            BinConverter.longToByteArray(lTemp, outbuffer, nI);
        }
    }

    public void decrypt(byte[] buffer) {
        int nLen = buffer.length;
        for (int nI = 0; nI < nLen; nI += 8) {
            long lTemp = BinConverter.byteArrayToLong(buffer, nI);
            lTemp = this.decryptBlockCBC(lTemp);
            BinConverter.longToByteArray(lTemp, buffer, nI);
        }
    }

    public void decrypt(int[] inbuffer, int[] outbuffer) {
        int nLen = inbuffer.length;
        for (int nI = 0; nI < nLen; nI += 2) {
            long lTemp = BinConverter.intArrayToLong(inbuffer, nI);
            lTemp = this.decryptBlockCBC(lTemp);
            BinConverter.longToIntArray(lTemp, outbuffer, nI);
        }
    }

    public void decrypt(int[] buffer) {
        int nLen = buffer.length;
        for (int nI = 0; nI < nLen; nI += 2) {
            long lTemp = BinConverter.intArrayToLong(buffer, nI);
            lTemp = this.decryptBlockCBC(lTemp);
            BinConverter.longToIntArray(lTemp, buffer, nI);
        }
    }

    public void decrypt(long[] inbuffer, long[] outbuffer) {
        int nLen = inbuffer.length;
        for (int nI = 0; nI < nLen; ++nI) {
            outbuffer[nI] = this.decryptBlockCBC(inbuffer[nI]);
        }
    }

    public void decrypt(long[] buffer) {
        int nLen = buffer.length;
        for (int nI = 0; nI < nLen; ++nI) {
            buffer[nI] = this.decryptBlockCBC(buffer[nI]);
        }
    }
}

