/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.BaseGradientPainter;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SpecularGradientPainter
extends BaseGradientPainter {
    public String getDisplayName() {
        return "Specular";
    }

    public BufferedImage getContourBackground(int width, int height, Shape contour, boolean isDark, ColorScheme colorScheme1, ColorScheme colorScheme2, float cyclePos, boolean hasShine, boolean useCyclePosAsInterpolation) {
        BufferedImage mixResult = this.getMixContourBackground(width, height, contour, isDark, colorScheme1, colorScheme2, cyclePos, hasShine, useCyclePosAsInterpolation);
        if (mixResult != null) {
            return mixResult;
        }
        BufferedImage image = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ColorScheme interpolationScheme1 = colorScheme1;
        ColorScheme interpolationScheme2 = useCyclePosAsInterpolation ? colorScheme2 : colorScheme1;
        double cycleCoef = 1.0 - (double)cyclePos / 10.0;
        Color topBorderColor = SubstanceColorUtilities.getTopBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef);
        Color midBorderColor = SubstanceColorUtilities.getMidBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef);
        Color bottomBorderColor = SubstanceColorUtilities.getBottomBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef);
        Color topFillColor = SubstanceColorUtilities.getTopFillColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        Color midFillColor = SubstanceColorUtilities.getMidFillColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        Color bottomFillColor = SubstanceColorUtilities.getBottomFillColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        Color topShineColor = SubstanceColorUtilities.getTopShineColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        Color bottomShineColor = SubstanceColorUtilities.getBottomShineColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        graphics.setStroke(new BasicStroke(1.3f, 1, 1));
        graphics.setClip(contour);
        GradientPaint gradientTop = new GradientPaint(0.0f, 0.0f, topFillColor, 0.0f, height / 2, midFillColor);
        graphics.setPaint(gradientTop);
        graphics.fillRect(0, 0, width, height / 2);
        GradientPaint gradientBottom = new GradientPaint(0.0f, height / 2, midFillColor, 0.0f, height - 2, bottomFillColor);
        graphics.setPaint(gradientBottom);
        graphics.fillRect(0, height / 2, width, height / 2);
        GradientPaint gradientBorderTop = new GradientPaint(0.0f, 0.0f, topBorderColor, 0.0f, height / 2, midBorderColor);
        graphics.setPaint(gradientBorderTop);
        graphics.setClip(0, 0, width, height / 2);
        graphics.draw(contour);
        GradientPaint gradientBorderBottom = new GradientPaint(0.0f, height / 2, midBorderColor, 0.0f, height - 2, bottomBorderColor);
        graphics.setPaint(gradientBorderBottom);
        graphics.setClip(0, height / 2, width, 1 + height / 2);
        graphics.draw(contour);
        if (hasShine) {
            double span;
            int y;
            int y2;
            int x;
            graphics.setClip(null);
            int shineHeight = (int)((double)height / 1.8);
            double[][] dists = new double[width][height];
            ColorModel srcColorModel = image.getColorModel();
            WritableRaster srcRaster = image.getRaster();
            int[][] alphas = new int[width][height];
            for (x = 0; x < width; ++x) {
                for (y2 = 0; y2 < height; ++y2) {
                    alphas[x][y2] = srcColorModel.getAlpha(srcRaster.getDataElements(x, y2, null));
                    dists[x][y2] = Math.max(width, height);
                }
            }
            for (y = 0; y < height; ++y) {
                int x2;
                span = 0.0;
                for (x2 = 0; x2 < width; ++x2) {
                    span = alphas[x2][y] == 0 ? 0.0 : (span == 0.0 || alphas[x2][y] < 255 ? (double)alphas[x2][y] / 255.0 : (span += 1.0));
                    dists[x2][y] = Math.min(span, dists[x2][y]);
                }
                span = 0.0;
                for (x2 = width - 1; x2 >= 0; --x2) {
                    span = alphas[x2][y] == 0 ? 0.0 : (span == 0.0 || alphas[x2][y] < 255 ? (double)alphas[x2][y] / 255.0 : (span += 1.0));
                    dists[x2][y] = Math.min(span, dists[x2][y]);
                }
            }
            for (x = 0; x < width; ++x) {
                span = 0.0;
                for (y2 = 0; y2 < height; ++y2) {
                    span = alphas[x][y2] == 0 ? 0.0 : (span == 0.0 || alphas[x][y2] < 255 ? (double)alphas[x][y2] / 255.0 : (span += 1.0));
                    dists[x][y2] = Math.min(span, dists[x][y2]);
                }
                span = 0.0;
                for (y2 = height - 1; y2 >= 0; --y2) {
                    span = alphas[x][y2] == 0 ? 0.0 : (span == 0.0 || alphas[x][y2] < 255 ? (double)alphas[x][y2] / 255.0 : (span += 1.0));
                    dists[x][y2] = Math.min(span, dists[x][y2]);
                }
            }
            for (y = 0; y < shineHeight; ++y) {
                double coef = (double)y / (double)height;
                double minDist = (0.8 + (double)height / 20.0) * (1.0 + 3.0 * coef);
                double maxDist = (0.8 + (double)height / 20.0) * (1.0 + 6.0 * coef);
                double colorCoef = (double)y / (double)shineHeight;
                int alpha = (int)(255.0 * (1.0 - 0.1 * colorCoef));
                alpha = Math.max(alpha, 0);
                int shineR = (int)((double)topShineColor.getRed() + colorCoef * (double)(bottomShineColor.getRed() - topShineColor.getRed()));
                int shineG = (int)((double)topShineColor.getGreen() + colorCoef * (double)(bottomShineColor.getGreen() - topShineColor.getGreen()));
                int shineB = (int)((double)topShineColor.getBlue() + colorCoef * (double)(bottomShineColor.getBlue() - topShineColor.getBlue()));
                for (int x3 = 0; x3 < width; ++x3) {
                    double dist;
                    Point2D.Double p = new Point2D.Double((double)x3 + 0.5, (double)y + 0.5);
                    if (!contour.contains(p) || (dist = dists[x3][y]) <= minDist) continue;
                    double delta = dist - minDist;
                    int dAlpha = alpha;
                    if (delta < 1.0) {
                        dAlpha = (int)(delta * (double)dAlpha);
                    }
                    if (dist < maxDist) {
                        dAlpha = (int)((double)dAlpha * ((dist - minDist) / (maxDist - minDist)));
                    }
                    graphics.setColor(new Color(shineR, shineG, shineB, dAlpha));
                    graphics.drawLine(x3, y, x3, y);
                }
            }
        }
        return image;
    }
}

