/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.FadeConfigurationManager;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceDefaultTableCellRenderer;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstanceTableUI
extends BasicTableUI {
    protected Set lafWidgets;
    public static String SELECTED_INDICES = "substancelaf.internal.tableSelectedIndices";
    public static String ROLLED_OVER_INDEX = "substancelaf.internal.tableRolledOverIndex";
    protected Map<Class<?>, TableCellRenderer> defaultRenderers;
    protected PropertyChangeListener substancePropertyChangeListener;
    protected ListSelectionListener substanceFadeSelectionListener;
    protected RolloverFadeListener substanceFadeRolloverListener;
    private static SubstanceGradientBackgroundDelegate backgroundDelegate = new SubstanceGradientBackgroundDelegate();

    @Override
    public void installDefaults() {
        this.__org__jvnet__substance__SubstanceTableUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    public void uninstallDefaults() {
        this.__org__jvnet__substance__SubstanceTableUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void __org__jvnet__substance__SubstanceTableUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceTableUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceTableUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceTableUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    public void uninstallListeners() {
        this.__org__jvnet__substance__SubstanceTableUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceTableUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceTableUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    public void installListeners() {
        this.__org__jvnet__substance__SubstanceTableUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceTableUI();
    }

    protected void __org__jvnet__substance__SubstanceTableUI__installDefaults() {
        Class[] defClasses;
        super.installDefaults();
        if (SubstanceCoreUtilities.toBleedWatermark(this.table)) {
            this.table.setOpaque(false);
        }
        this.defaultRenderers = new HashMap();
        for (Class clazz : defClasses = new Class[]{Object.class, Icon.class, ImageIcon.class, Number.class, Float.class, Double.class, Date.class, Boolean.class}) {
            this.defaultRenderers.put(clazz, this.table.getDefaultRenderer(clazz));
        }
        this.installRendererIfNecessary(Object.class, new SubstanceDefaultTableCellRenderer());
        this.installRendererIfNecessary(Icon.class, new SubstanceDefaultTableCellRenderer.IconRenderer());
        this.installRendererIfNecessary(ImageIcon.class, new SubstanceDefaultTableCellRenderer.IconRenderer());
        this.installRendererIfNecessary(Number.class, new SubstanceDefaultTableCellRenderer.NumberRenderer());
        this.installRendererIfNecessary(Float.class, new SubstanceDefaultTableCellRenderer.DoubleRenderer());
        this.installRendererIfNecessary(Double.class, new SubstanceDefaultTableCellRenderer.DoubleRenderer());
        this.installRendererIfNecessary(Date.class, new SubstanceDefaultTableCellRenderer.DateRenderer());
        this.installRendererIfNecessary(Boolean.class, new SubstanceDefaultTableCellRenderer.BooleanRenderer());
        HashMap<TableCellId, Object> selected = new HashMap<TableCellId, Object>();
        int rows = this.table.getRowCount();
        int cols = this.table.getColumnCount();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                if (!this.table.isCellSelected(i, j)) continue;
                selected.put(new TableCellId(i, j), this.table.getValueAt(i, j));
            }
        }
        this.table.putClientProperty(SELECTED_INDICES, selected);
    }

    protected void installRendererIfNecessary(Class clazz, TableCellRenderer renderer) {
        TableCellRenderer currRenderer = this.table.getDefaultRenderer(clazz);
        if (currRenderer != null) {
            boolean isCore;
            boolean bl = isCore = currRenderer instanceof DefaultTableCellRenderer.UIResource || currRenderer.getClass().getName().startsWith("javax.swing.JTable");
            if (!isCore) {
                return;
            }
        }
        this.table.setDefaultRenderer(clazz, renderer);
    }

    protected void __org__jvnet__substance__SubstanceTableUI__uninstallDefaults() {
        for (Map.Entry<Class<?>, TableCellRenderer> entry : this.defaultRenderers.entrySet()) {
            this.uninstallRendererIfNecessary(entry.getKey(), entry.getValue());
        }
        this.table.putClientProperty(SELECTED_INDICES, null);
        super.uninstallDefaults();
    }

    protected void uninstallRendererIfNecessary(Class clazz, TableCellRenderer renderer) {
        TableCellRenderer currRenderer = this.table.getDefaultRenderer(clazz);
        if (currRenderer != null) {
            boolean isSubstanceRenderer;
            boolean bl = isSubstanceRenderer = currRenderer instanceof SubstanceDefaultTableCellRenderer || currRenderer instanceof SubstanceDefaultTableCellRenderer.BooleanRenderer;
            if (!isSubstanceRenderer) {
                return;
            }
        }
        this.table.setDefaultRenderer(clazz, renderer);
    }

    protected void __org__jvnet__substance__SubstanceTableUI__installListeners() {
        super.installListeners();
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("substancelaf.watermark.tobleed".equals(evt.getPropertyName())) {
                    SubstanceTableUI.this.table.setOpaque(!SubstanceCoreUtilities.toBleedWatermark(SubstanceTableUI.this.table));
                }
                if ("columnSelectionAllowed".equals(evt.getPropertyName()) || "rowSelectionAllowed".equals(evt.getPropertyName())) {
                    SubstanceTableUI.this.syncSelection(null);
                }
            }
        };
        this.table.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.substanceFadeSelectionListener = new TableSelectionListener();
        this.table.getSelectionModel().addListSelectionListener(this.substanceFadeSelectionListener);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(this.substanceFadeSelectionListener);
        this.substanceFadeRolloverListener = new RolloverFadeListener();
        this.table.addMouseMotionListener(this.substanceFadeRolloverListener);
        this.table.addMouseListener(this.substanceFadeRolloverListener);
    }

    protected void __org__jvnet__substance__SubstanceTableUI__uninstallListeners() {
        this.table.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        this.table.getSelectionModel().removeListSelectionListener(this.substanceFadeSelectionListener);
        this.table.getColumnModel().getSelectionModel().removeListSelectionListener(this.substanceFadeSelectionListener);
        this.substanceFadeSelectionListener = null;
        this.table.removeMouseMotionListener(this.substanceFadeRolloverListener);
        this.table.removeMouseListener(this.substanceFadeRolloverListener);
        this.substanceFadeRolloverListener = null;
        super.uninstallListeners();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean ltr;
        Rectangle clip = g.getClipBounds();
        Rectangle bounds = this.table.getBounds();
        bounds.y = 0;
        bounds.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !bounds.intersects(clip)) {
            return;
        }
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int rMin = this.table.rowAtPoint(upperLeft);
        int rMax = this.table.rowAtPoint(lowerRight);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.table.getRowCount() - 1;
        }
        int cMin = this.table.columnAtPoint((ltr = this.table.getComponentOrientation().isLeftToRight()) ? upperLeft : lowerRight);
        int cMax = this.table.columnAtPoint(ltr ? lowerRight : upperLeft);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        this.paintGrid(g, rMin, rMax, cMin, cMax);
        this.paintCells(g, rMin, rMax, cMin, cMax);
    }

    private void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        g.setColor(this.table.getGridColor());
        Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
        Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
        Rectangle damagedArea = minCell.union(maxCell);
        if (this.table.getShowHorizontalLines()) {
            int tableWidth = damagedArea.x + damagedArea.width;
            int y = damagedArea.y;
            for (int row = rMin; row <= rMax; ++row) {
                g.drawLine(damagedArea.x, (y += this.table.getRowHeight(row)) - 1, tableWidth - 1, y - 1);
            }
        }
        if (this.table.getShowVerticalLines()) {
            int x;
            TableColumnModel cm = this.table.getColumnModel();
            int tableHeight = damagedArea.y + damagedArea.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                x = damagedArea.x;
                for (int column = cMin; column <= cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    g.drawLine((x += w) - 1, 0, x - 1, tableHeight - 1);
                }
            } else {
                x = damagedArea.x + damagedArea.width;
                for (int column = cMin; column <= cMax; ++column) {
                    g.drawLine(x - 1, 0, x - 1, tableHeight - 1);
                    int w = cm.getColumn(column).getWidth();
                    x -= w;
                }
                g.drawLine(x, 0, x, tableHeight - 1);
            }
        }
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.table.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.table.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (int row = rMin; row <= rMax; ++row) {
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                for (int column = cMin; column <= cMax; ++column) {
                    TableColumn aColumn = cm.getColumn(column);
                    int columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    if (aColumn != draggedColumn) {
                        this.paintCell(g, cellRect, row, column);
                    }
                    cellRect.x += columnWidth;
                }
            }
        } else {
            for (int row = rMin; row <= rMax; ++row) {
                int columnWidth;
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                TableColumn aColumn = cm.getColumn(cMin);
                if (aColumn != draggedColumn) {
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    this.paintCell(g, cellRect, row, cMin);
                }
                for (int column = cMin + 1; column <= cMax; ++column) {
                    aColumn = cm.getColumn(column);
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    cellRect.x -= columnWidth;
                    if (aColumn == draggedColumn) continue;
                    this.paintCell(g, cellRect, row, column);
                }
            }
        }
        if (draggedColumn != null) {
            this.paintDraggedArea(g, rMin, rMax, draggedColumn, header.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance) {
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        g.setColor(this.table.getParent().getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        vacatedColumnRect.x += distance;
        g.setColor(this.table.getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        if (this.table.getShowVerticalLines()) {
            g.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = vacatedColumnRect.y;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + vacatedColumnRect.height - 1;
            g.drawLine(x1 - 1, y1, x1 - 1, y2);
            g.drawLine(x2, y1, x2, y2);
        }
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle r = this.table.getCellRect(row, draggedColumnIndex, false);
            r.x += distance;
            this.paintCell(g, r, row, draggedColumnIndex);
            if (!this.table.getShowHorizontalLines()) continue;
            g.setColor(this.table.getGridColor());
            Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
            rcr.x += distance;
            int x1 = rcr.x;
            int y1 = rcr.y;
            int x2 = x1 + rcr.width - 1;
            int y2 = y1 + rcr.height - 1;
            g.drawLine(x1, y2, x2, y2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        float fadeCoef;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.table, g));
        TableCellId cellId = new TableCellId(row, column);
        boolean isSelectedAnim = FadeTracker.getInstance().isTracked((Component)this.table, cellId, FadeTracker.FadeKind.SELECTION);
        boolean isRolloverAnim = FadeTracker.getInstance().isTracked((Component)this.table, cellId, FadeTracker.FadeKind.ROLLOVER);
        Comparable currRoIndex = (Comparable)this.table.getClientProperty(ROLLED_OVER_INDEX);
        boolean isRollover = currRoIndex != null && currRoIndex.equals(cellId);
        float alphaForBackground = 0.0f;
        if (this.table.isCellSelected(row, column) || isSelectedAnim) {
            if (isSelectedAnim) {
                fadeCoef = FadeTracker.getInstance().getFade10((Component)this.table, cellId, FadeTracker.FadeKind.SELECTION);
                alphaForBackground = 0.7f * fadeCoef / 10.0f;
            } else {
                alphaForBackground = 0.7f;
            }
        }
        if (isRolloverAnim) {
            fadeCoef = FadeTracker.getInstance().getFade10((Component)this.table, cellId, FadeTracker.FadeKind.ROLLOVER);
            alphaForBackground = Math.max(alphaForBackground, 0.4f * fadeCoef / 10.0f);
        } else if (isRollover) {
            alphaForBackground = Math.max(alphaForBackground, 0.4f);
        }
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            if (alphaForBackground > 0.0f && component != null) {
                g2d.setComposite(TransitionLayout.getAlphaComposite(this.table, alphaForBackground, g));
                backgroundDelegate.update(g2d, component, new Rectangle(cellRect.x, cellRect.y, cellRect.width, cellRect.height), SubstanceCoreUtilities.getTheme(this.table, true).getHighlightBackgroundTheme(), false);
                g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.table, g));
            }
            if (component instanceof JComponent) {
                JComponent jRenderer;
                JComponent jComponent = jRenderer = (JComponent)component;
                synchronized (jComponent) {
                    boolean newOpaque;
                    boolean bl = newOpaque = !this.table.isCellSelected(row, column) && !isSelectedAnim && !isRollover && !isRolloverAnim;
                    if (SubstanceCoreUtilities.toBleedWatermark(this.table)) {
                        newOpaque = false;
                    }
                    HashMap<Component, Boolean> opacity = new HashMap<Component, Boolean>();
                    if (!newOpaque) {
                        SubstanceCoreUtilities.makeNonOpaque(component, opacity);
                    }
                    component.setBounds(cellRect);
                    component.validate();
                    if (!newOpaque) {
                        SubstanceCoreUtilities.restoreOpaque(component, opacity);
                    }
                }
            } else {
                component.setBounds(cellRect);
                component.validate();
            }
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            boolean isWatermarkBleed = SubstanceCoreUtilities.toBleedWatermark(this.table);
            if (!isWatermarkBleed && component != null) {
                g2d.setColor(component.getBackground());
                g2d.fillRect(cellRect.x, cellRect.y, cellRect.width, cellRect.height);
            }
            if (alphaForBackground > 0.0f && component != null) {
                g2d.setComposite(TransitionLayout.getAlphaComposite(this.table, alphaForBackground, g));
                backgroundDelegate.update(g2d, component, new Rectangle(cellRect.x, cellRect.y, cellRect.width, cellRect.height), SubstanceCoreUtilities.getTheme(this.table, true).getHighlightBackgroundTheme(), false);
                g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.table, g));
            }
            if (component instanceof JComponent) {
                JComponent jRenderer;
                JComponent jComponent = jRenderer = (JComponent)component;
                synchronized (jComponent) {
                    boolean newOpaque;
                    boolean bl = newOpaque = !this.table.isCellSelected(row, column) && !isSelectedAnim && !isRollover && !isRolloverAnim;
                    if (SubstanceCoreUtilities.toBleedWatermark(this.table)) {
                        newOpaque = false;
                    }
                    HashMap<Component, Boolean> opacity = new HashMap<Component, Boolean>();
                    if (!newOpaque) {
                        SubstanceCoreUtilities.makeNonOpaque(jRenderer, opacity);
                    }
                    this.rendererPane.paintComponent(g2d, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
                    if (!newOpaque) {
                        SubstanceCoreUtilities.restoreOpaque(jRenderer, opacity);
                    }
                }
            } else {
                this.rendererPane.paintComponent(g2d, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
            }
        }
        g2d.dispose();
    }

    private FadeTracker.FadeTrackerCallback getCallback(int row, int column) {
        boolean hasRowSelection = this.table.getRowSelectionAllowed();
        boolean hasColumnSelection = this.table.getColumnSelectionAllowed();
        if (hasRowSelection && !hasColumnSelection) {
            return new RowRepaintCallback(this.table, row);
        }
        if (!hasRowSelection && hasColumnSelection) {
            return new ColumnRepaintCallback(this.table, column);
        }
        return new CellRepaintCallback(this.table, row, column);
    }

    private FadeTracker.FadeTrackerCallback getCallback(Comparable comparable) {
        if (comparable instanceof TableRowId) {
            return new RowRepaintCallback(this.table, ((TableRowId)comparable).row);
        }
        if (comparable instanceof TableColumnId) {
            return new ColumnRepaintCallback(this.table, ((TableColumnId)comparable).column);
        }
        return new CellRepaintCallback(this.table, ((TableCellId)comparable).row, ((TableCellId)comparable).column);
    }

    private Comparable getId(int row, int column) {
        boolean hasRowSelection = this.table.getRowSelectionAllowed();
        boolean hasColumnSelection = this.table.getColumnSelectionAllowed();
        if (hasRowSelection && !hasColumnSelection) {
            return new TableRowId(row);
        }
        if (!hasRowSelection && hasColumnSelection) {
            return new TableColumnId(column);
        }
        return new TableCellId(row, column);
    }

    protected void cancelFades(Set<Long> initiatedFadeSequences) {
        FadeTracker fadeTrackerInstance = FadeTracker.getInstance();
        for (long fadeId : initiatedFadeSequences) {
            fadeTrackerInstance.cancelFadeInstance(fadeId);
        }
    }

    protected void syncSelection(ListSelectionEvent e) {
        if (LafWidgetUtilities.hasNoFades(this.table, FadeTracker.FadeKind.SELECTION)) {
            return;
        }
        if (this.table.getRowCount() * this.table.getColumnCount() > 1000) {
            return;
        }
        Map currSelected = (Map)this.table.getClientProperty(SELECTED_INDICES);
        HashSet<Long> initiatedFadeSequences = new HashSet<Long>();
        boolean fadeCanceled = false;
        int rows = this.table.getRowCount();
        int cols = this.table.getColumnCount();
        FadeTracker fadeTrackerInstance = FadeTracker.getInstance();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                TableCellId cellId = new TableCellId(i, j);
                if (this.table.isCellSelected(i, j)) {
                    if (currSelected.containsKey(cellId)) continue;
                    if (!fadeCanceled) {
                        long fadeId = fadeTrackerInstance.trackFadeIn(FadeTracker.FadeKind.SELECTION, (Component)this.table, cellId, false, (FadeTracker.FadeTrackerCallback)new CellRepaintCallback(this.table, i, j));
                        initiatedFadeSequences.add(fadeId);
                        if (initiatedFadeSequences.size() > 15) {
                            this.cancelFades(initiatedFadeSequences);
                            initiatedFadeSequences.clear();
                            fadeCanceled = true;
                        }
                    } else {
                        new CellRepaintCallback(this.table, i, j).fadeEnded(FadeTracker.FadeKind.SELECTION);
                    }
                    currSelected.put(cellId, this.table.getModel().getValueAt(i, j));
                    continue;
                }
                if (!currSelected.containsKey(cellId)) continue;
                Object oldValue = currSelected.get(cellId);
                Object currValue = this.table.getValueAt(i, j);
                boolean isSame = false;
                isSame = oldValue == null ? currValue == null : oldValue.equals(currValue);
                if (isSame) {
                    if (!fadeCanceled) {
                        long fadeId = fadeTrackerInstance.trackFadeOut(FadeTracker.FadeKind.SELECTION, (Component)this.table, cellId, false, (FadeTracker.FadeTrackerCallback)new CellRepaintCallback(this.table, i, j));
                        initiatedFadeSequences.add(fadeId);
                        if (initiatedFadeSequences.size() > 15) {
                            this.cancelFades(initiatedFadeSequences);
                            initiatedFadeSequences.clear();
                            fadeCanceled = true;
                        }
                    } else {
                        new CellRepaintCallback(this.table, i, j).fadeEnded(FadeTracker.FadeKind.SELECTION);
                    }
                }
                currSelected.remove(cellId);
            }
        }
    }

    private class RolloverFadeListener
    implements MouseListener,
    MouseMotionListener {
        private RolloverFadeListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseExited(MouseEvent e) {
            if (!SubstanceTableUI.this.table.isEnabled()) {
                return;
            }
            JTable jTable = SubstanceTableUI.this.table;
            synchronized (jTable) {
                this.fadeOut();
                SubstanceTableUI.this.table.putClientProperty(ROLLED_OVER_INDEX, null);
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (!SubstanceTableUI.this.table.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        public void mouseDragged(MouseEvent e) {
            if (!SubstanceTableUI.this.table.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMove(MouseEvent e) {
            JTable jTable = SubstanceTableUI.this.table;
            synchronized (jTable) {
                int row = SubstanceTableUI.this.table.rowAtPoint(e.getPoint());
                int column = SubstanceTableUI.this.table.columnAtPoint(e.getPoint());
                if (row < 0 || row >= SubstanceTableUI.this.table.getRowCount() || column < 0 || column >= SubstanceTableUI.this.table.getColumnCount()) {
                    this.fadeOut();
                    SubstanceTableUI.this.table.putClientProperty(ROLLED_OVER_INDEX, null);
                } else {
                    Comparable newId = SubstanceTableUI.this.getId(row, column);
                    Comparable currId = (Comparable)SubstanceTableUI.this.table.getClientProperty(ROLLED_OVER_INDEX);
                    if (currId != null && newId.equals(currId)) {
                        return;
                    }
                    this.fadeOut();
                    FadeTracker.getInstance().trackFadeIn(FadeTracker.FadeKind.ROLLOVER, (Component)SubstanceTableUI.this.table, newId, false, SubstanceTableUI.this.getCallback(row, column));
                    if (FadeConfigurationManager.getInstance().fadeAllowed(FadeTracker.FadeKind.ROLLOVER, SubstanceTableUI.this.table)) {
                        SubstanceTableUI.this.table.putClientProperty(ROLLED_OVER_INDEX, newId);
                    }
                }
            }
        }

        private void fadeOut() {
            Comparable prevRoIndex = (Comparable)SubstanceTableUI.this.table.getClientProperty(ROLLED_OVER_INDEX);
            if (prevRoIndex == null) {
                return;
            }
            FadeTracker.getInstance().trackFadeOut(FadeTracker.FadeKind.ROLLOVER, (Component)SubstanceTableUI.this.table, prevRoIndex, false, SubstanceTableUI.this.getCallback(prevRoIndex));
        }
    }

    protected class TableSelectionListener
    implements ListSelectionListener {
        protected TableSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            SubstanceTableUI.this.syncSelection(e);
        }
    }

    protected static class TableRowId
    implements Comparable {
        protected int row;

        public TableRowId(int row) {
            this.row = row;
        }

        public int compareTo(Object o) {
            if (o instanceof TableCellId) {
                TableCellId otherId = (TableCellId)o;
                if (this.row == otherId.row) {
                    return 0;
                }
                return 1;
            }
            if (o instanceof TableRowId) {
                TableRowId otherId = (TableRowId)o;
                if (this.row == otherId.row) {
                    return 0;
                }
                return 1;
            }
            return -1;
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            return this.row ^ this.row >>> 32;
        }
    }

    protected static class TableColumnId
    implements Comparable {
        protected int column;

        public TableColumnId(int column) {
            this.column = column;
        }

        public int compareTo(Object o) {
            if (o instanceof TableCellId) {
                TableCellId otherId = (TableCellId)o;
                if (this.column == otherId.column) {
                    return 0;
                }
                return 1;
            }
            if (o instanceof TableColumnId) {
                TableColumnId otherId = (TableColumnId)o;
                if (this.column == otherId.column) {
                    return 0;
                }
                return 1;
            }
            return -1;
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            return this.column ^ this.column >>> 32;
        }
    }

    protected static class TableCellId
    implements Comparable {
        protected int row;
        protected int column;

        public TableCellId(int row, int column) {
            this.row = row;
            this.column = column;
        }

        public int compareTo(Object o) {
            if (o instanceof TableCellId) {
                TableCellId otherId = (TableCellId)o;
                if (this.row == otherId.row && this.column == otherId.column) {
                    return 0;
                }
                return 1;
            }
            if (o instanceof TableRowId) {
                TableRowId otherId = (TableRowId)o;
                if (this.row == otherId.row) {
                    return 0;
                }
                return 1;
            }
            if (o instanceof TableColumnId) {
                TableColumnId otherId = (TableColumnId)o;
                if (this.column == otherId.column) {
                    return 0;
                }
                return 1;
            }
            return -1;
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            return (this.row ^ this.row >>> 32) & (this.column ^ this.column >>> 32);
        }
    }

    protected class ColumnRepaintCallback
    implements FadeTracker.FadeTrackerCallback {
        protected JTable table;
        protected int columnIndex;

        public ColumnRepaintCallback(JTable table, int columnIndex) {
            this.table = table;
            this.columnIndex = columnIndex;
        }

        public void fadeEnded(FadeTracker.FadeKind fadeKind) {
            this.repaintColumn();
        }

        public void fadePerformed(FadeTracker.FadeKind fadeKind, float fade10) {
            this.repaintColumn();
        }

        private void repaintColumn() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (SubstanceTableUI.this.table == null) {
                        return;
                    }
                    int columnCount = ColumnRepaintCallback.this.table.getColumnCount();
                    if (columnCount > 0 && ColumnRepaintCallback.this.columnIndex < columnCount) {
                        Rectangle rect = ColumnRepaintCallback.this.table.getCellRect(0, ColumnRepaintCallback.this.columnIndex, true);
                        for (int i = 1; i < ColumnRepaintCallback.this.table.getRowCount(); ++i) {
                            rect = rect.union(ColumnRepaintCallback.this.table.getCellRect(i, ColumnRepaintCallback.this.columnIndex, true));
                        }
                        ColumnRepaintCallback.this.table.repaint(rect);
                    }
                }
            });
        }
    }

    protected class RowRepaintCallback
    implements FadeTracker.FadeTrackerCallback {
        protected JTable table;
        protected int rowIndex;

        public RowRepaintCallback(JTable table, int rowIndex) {
            this.table = table;
            this.rowIndex = rowIndex;
        }

        public void fadeEnded(FadeTracker.FadeKind fadeKind) {
            this.repaintRow();
        }

        public void fadePerformed(FadeTracker.FadeKind fadeKind, float fade10) {
            this.repaintRow();
        }

        private void repaintRow() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (SubstanceTableUI.this.table == null) {
                        return;
                    }
                    int rowCount = RowRepaintCallback.this.table.getRowCount();
                    if (rowCount > 0 && RowRepaintCallback.this.rowIndex < rowCount) {
                        Rectangle rect = RowRepaintCallback.this.table.getCellRect(RowRepaintCallback.this.rowIndex, 0, true);
                        for (int i = 1; i < RowRepaintCallback.this.table.getColumnCount(); ++i) {
                            rect = rect.union(RowRepaintCallback.this.table.getCellRect(RowRepaintCallback.this.rowIndex, i, true));
                        }
                        RowRepaintCallback.this.table.repaint(rect);
                    }
                }
            });
        }
    }

    protected class CellRepaintCallback
    implements FadeTracker.FadeTrackerCallback {
        protected JTable table;
        protected int rowIndex;
        protected int columnIndex;

        public CellRepaintCallback(JTable table, int rowIndex, int columnIndex) {
            this.table = table;
            this.rowIndex = rowIndex;
            this.columnIndex = columnIndex;
        }

        public void fadeEnded(FadeTracker.FadeKind fadeKind) {
            this.repaintCell();
        }

        public void fadePerformed(FadeTracker.FadeKind fadeKind, float fade10) {
            this.repaintCell();
        }

        private void repaintCell() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (SubstanceTableUI.this.table == null) {
                        return;
                    }
                    int rowCount = CellRepaintCallback.this.table.getRowCount();
                    int colCount = CellRepaintCallback.this.table.getColumnCount();
                    if (rowCount > 0 && CellRepaintCallback.this.rowIndex < rowCount && colCount > 0 && CellRepaintCallback.this.columnIndex < colCount) {
                        Rectangle rect = CellRepaintCallback.this.table.getCellRect(CellRepaintCallback.this.rowIndex, CellRepaintCallback.this.columnIndex, true);
                        CellRepaintCallback.this.table.repaint(rect);
                    }
                }
            });
        }
    }
}

