/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.FadeConfigurationManager;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceListUI
extends BasicListUI {
    protected Set lafWidgets;
    public static String SELECTED_INDICES = "substancelaf.internal.listSelectedIndices";
    public static String ROLLED_OVER_INDEX = "substancelaf.internal.listRolledOverIndex";
    protected PropertyChangeListener substancePropertyChangeListener;
    protected boolean isFileList;
    protected boolean isLeftToRight;
    private static SubstanceGradientBackgroundDelegate backgroundDelegate = new SubstanceGradientBackgroundDelegate();
    protected ListSelectionListener substanceFadeSelectionListener;
    protected RolloverFadeListener substanceFadeRolloverListener;

    public void installDefaults() {
        this.__org__jvnet__substance__SubstanceListUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void uninstallDefaults() {
        this.__org__jvnet__substance__SubstanceListUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void __org__jvnet__substance__SubstanceListUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceListUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceListUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceListUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void uninstallListeners() {
        this.__org__jvnet__substance__SubstanceListUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceListUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceListUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void installListeners() {
        this.__org__jvnet__substance__SubstanceListUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public static ComponentUI createUI(JComponent list) {
        return new SubstanceListUI();
    }

    protected void __org__jvnet__substance__SubstanceListUI__installDefaults() {
        super.installDefaults();
        this.isFileList = Boolean.TRUE.equals(this.list.getClientProperty("List.isFileList"));
        this.isLeftToRight = this.list.getComponentOrientation().isLeftToRight();
        if (SubstanceCoreUtilities.toBleedWatermark(this.list)) {
            this.list.setOpaque(false);
        }
        HashMap selected = new HashMap();
        for (int i = 0; i < this.list.getModel().getSize(); ++i) {
            if (!this.list.isSelectedIndex(i)) continue;
            selected.put(i, this.list.getModel().getElementAt(i));
        }
        this.list.putClientProperty(SELECTED_INDICES, selected);
    }

    protected void __org__jvnet__substance__SubstanceListUI__uninstallDefaults() {
        this.list.putClientProperty(SELECTED_INDICES, null);
        super.uninstallDefaults();
    }

    protected void __org__jvnet__substance__SubstanceListUI__installListeners() {
        super.installListeners();
        this.substanceFadeSelectionListener = new ListSelectionListener(){

            protected void cancelFades(Set<Long> initiatedFadeSequences) {
                FadeTracker fadeTrackerInstance = FadeTracker.getInstance();
                for (long fadeId : initiatedFadeSequences) {
                    fadeTrackerInstance.cancelFadeInstance(fadeId);
                }
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (LafWidgetUtilities.hasNoFades(SubstanceListUI.this.list, FadeTracker.FadeKind.SELECTION)) {
                    return;
                }
                HashSet<Long> initiatedFadeSequences = new HashSet<Long>();
                boolean fadeCanceled = false;
                FadeTracker fadeTrackerInstance = FadeTracker.getInstance();
                Map currSelected = (Map)SubstanceListUI.this.list.getClientProperty(SELECTED_INDICES);
                for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                    long fadeId;
                    if (i >= SubstanceListUI.this.list.getModel().getSize()) continue;
                    if (SubstanceListUI.this.list.isSelectedIndex(i)) {
                        if (currSelected.containsKey(i)) continue;
                        if (!fadeCanceled) {
                            fadeId = fadeTrackerInstance.trackFadeIn(FadeTracker.FadeKind.SELECTION, (Component)SubstanceListUI.this.list, i, false, (FadeTracker.FadeTrackerCallback)new CellRepaintCallback(SubstanceListUI.this.list, i));
                            initiatedFadeSequences.add(fadeId);
                            if (initiatedFadeSequences.size() > 25) {
                                this.cancelFades(initiatedFadeSequences);
                                initiatedFadeSequences.clear();
                                fadeCanceled = true;
                            }
                        }
                        currSelected.put(i, SubstanceListUI.this.list.getModel().getElementAt(i));
                        continue;
                    }
                    if (!currSelected.containsKey(i)) continue;
                    if (currSelected.get(i) == SubstanceListUI.this.list.getModel().getElementAt(i) && !fadeCanceled) {
                        fadeId = fadeTrackerInstance.trackFadeOut(FadeTracker.FadeKind.SELECTION, (Component)SubstanceListUI.this.list, i, false, (FadeTracker.FadeTrackerCallback)new CellRepaintCallback(SubstanceListUI.this.list, i));
                        initiatedFadeSequences.add(fadeId);
                        if (initiatedFadeSequences.size() > 25) {
                            this.cancelFades(initiatedFadeSequences);
                            initiatedFadeSequences.clear();
                            fadeCanceled = true;
                        }
                    }
                    currSelected.remove(i);
                }
            }
        };
        this.list.getSelectionModel().addListSelectionListener(this.substanceFadeSelectionListener);
        this.substanceFadeRolloverListener = new RolloverFadeListener();
        this.list.addMouseMotionListener(this.substanceFadeRolloverListener);
        this.list.addMouseListener(this.substanceFadeRolloverListener);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("substancelaf.watermark.tobleed".equals(evt.getPropertyName())) {
                    SubstanceListUI.this.list.setOpaque(!SubstanceCoreUtilities.toBleedWatermark(SubstanceListUI.this.list));
                }
            }
        };
        this.list.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    protected void __org__jvnet__substance__SubstanceListUI__uninstallListeners() {
        this.list.getSelectionModel().removeListSelectionListener(this.substanceFadeSelectionListener);
        this.substanceFadeSelectionListener = null;
        this.list.removeMouseMotionListener(this.substanceFadeRolloverListener);
        this.list.removeMouseListener(this.substanceFadeRolloverListener);
        this.substanceFadeRolloverListener = null;
        this.list.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
        float fadeCoef;
        AlphaComposite ac;
        Object value = dataModel.getElementAt(row);
        boolean cellHasFocus = this.list.hasFocus() && row == leadIndex;
        boolean isSelected = selModel.isSelectedIndex(row);
        boolean isWatermarkBleed = SubstanceCoreUtilities.toBleedWatermark(this.list);
        Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, row, isSelected, cellHasFocus);
        int cx = rowBounds.x;
        int cy = rowBounds.y;
        int cw = rowBounds.width;
        int ch = rowBounds.height;
        if (this.isFileList) {
            int w = Math.min(cw, rendererComponent.getPreferredSize().width + 4);
            if (!this.isLeftToRight) {
                cx += cw - w;
            }
            cw = w;
        }
        boolean isSelectedAnim = FadeTracker.getInstance().isTracked((Component)this.list, row, FadeTracker.FadeKind.SELECTION);
        boolean isRolloverAnim = FadeTracker.getInstance().isTracked((Component)this.list, row, FadeTracker.FadeKind.ROLLOVER);
        Integer currRoIndex = (Integer)this.list.getClientProperty(ROLLED_OVER_INDEX);
        boolean isRollover = currRoIndex != null && currRoIndex == row;
        float currFactor = 1.0f;
        Composite currComposite = ((Graphics2D)g).getComposite();
        if (currComposite instanceof AlphaComposite && (ac = (AlphaComposite)currComposite).getRule() == 3) {
            currFactor = ac.getAlpha();
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.list, currFactor));
        if (!isWatermarkBleed) {
            g2d.setColor(rendererComponent.getBackground());
            g2d.fillRect(cx, cy, cw, ch);
        }
        float alphaForBackground = 0.0f;
        if (isSelected || isSelectedAnim) {
            if (isSelectedAnim) {
                fadeCoef = FadeTracker.getInstance().getFade10((Component)this.list, row, FadeTracker.FadeKind.SELECTION);
                alphaForBackground = 0.7f * fadeCoef / 10.0f;
            } else {
                alphaForBackground = 0.7f;
            }
        }
        if (isRolloverAnim) {
            fadeCoef = FadeTracker.getInstance().getFade10((Component)this.list, row, FadeTracker.FadeKind.ROLLOVER);
            alphaForBackground = Math.max(alphaForBackground, 0.4f * fadeCoef / 10.0f);
        } else if (isRollover) {
            alphaForBackground = Math.max(alphaForBackground, 0.4f);
        }
        if (alphaForBackground > 0.0f) {
            g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.list, alphaForBackground * currFactor));
            backgroundDelegate.update(g2d, rendererComponent, new Rectangle(cx, cy, cw, ch), SubstanceCoreUtilities.getTheme(this.list, true).getHighlightBackgroundTheme(), true);
            g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.list, currFactor));
        }
        if (rendererComponent instanceof JComponent) {
            JComponent jRenderer;
            JComponent jComponent = jRenderer = (JComponent)rendererComponent;
            synchronized (jComponent) {
                boolean newOpaque;
                boolean bl = newOpaque = !isSelected && !isSelectedAnim && !isRollover && !isRolloverAnim;
                if (SubstanceCoreUtilities.toBleedWatermark(this.list)) {
                    newOpaque = false;
                }
                HashMap<Component, Boolean> opacity = new HashMap<Component, Boolean>();
                if (!newOpaque) {
                    SubstanceCoreUtilities.makeNonOpaque(jRenderer, opacity);
                }
                this.rendererPane.paintComponent(g2d, rendererComponent, this.list, cx, cy, cw, ch, true);
                if (!newOpaque) {
                    SubstanceCoreUtilities.restoreOpaque(jRenderer, opacity);
                }
            }
        } else {
            this.rendererPane.paintComponent(g2d, rendererComponent, this.list, cx, cy, cw, ch, true);
        }
        g2d.dispose();
    }

    protected class CellRepaintCallback
    implements FadeTracker.FadeTrackerCallback {
        protected JList list;
        protected int cellIndex;

        public CellRepaintCallback(JList list, int tabIndex) {
            this.list = list;
            this.cellIndex = tabIndex;
        }

        public void fadeEnded(FadeTracker.FadeKind fadeKind) {
            this.repaintCell();
        }

        public void fadePerformed(FadeTracker.FadeKind fadeKind, float fade10) {
            this.repaintCell();
        }

        private void repaintCell() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (SubstanceListUI.this.list == null) {
                        return;
                    }
                    try {
                        SubstanceListUI.this.maybeUpdateLayoutState();
                        int cellCount = CellRepaintCallback.this.list.getModel().getSize();
                        if (cellCount > 0 && CellRepaintCallback.this.cellIndex < cellCount) {
                            Rectangle rect = SubstanceListUI.this.getCellBounds(CellRepaintCallback.this.list, CellRepaintCallback.this.cellIndex, CellRepaintCallback.this.cellIndex);
                            CellRepaintCallback.this.list.repaint(rect);
                        }
                    }
                    catch (RuntimeException re) {
                        return;
                    }
                }
            });
        }
    }

    private class RolloverFadeListener
    implements MouseListener,
    MouseMotionListener {
        private RolloverFadeListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            this.fadeOut();
            SubstanceListUI.this.list.putClientProperty(ROLLED_OVER_INDEX, null);
        }

        public void mouseMoved(MouseEvent e) {
            if (!SubstanceListUI.this.list.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        public void mouseDragged(MouseEvent e) {
            if (!SubstanceListUI.this.list.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        private void handleMove(MouseEvent e) {
            boolean fadeAllowed = FadeConfigurationManager.getInstance().fadeAllowed(FadeTracker.FadeKind.ROLLOVER, SubstanceListUI.this.list);
            if (!fadeAllowed) {
                this.fadeOut();
                SubstanceListUI.this.list.putClientProperty(ROLLED_OVER_INDEX, null);
                return;
            }
            int roIndex = SubstanceListUI.this.list.locationToIndex(e.getPoint());
            if (roIndex < 0 || roIndex >= SubstanceListUI.this.list.getModel().getSize()) {
                this.fadeOut();
                SubstanceListUI.this.list.putClientProperty(ROLLED_OVER_INDEX, null);
            } else {
                Integer currRoIndex = (Integer)SubstanceListUI.this.list.getClientProperty(ROLLED_OVER_INDEX);
                if (currRoIndex != null && currRoIndex == roIndex) {
                    return;
                }
                this.fadeOut();
                FadeTracker.getInstance().trackFadeIn(FadeTracker.FadeKind.ROLLOVER, (Component)SubstanceListUI.this.list, roIndex, false, (FadeTracker.FadeTrackerCallback)new CellRepaintCallback(SubstanceListUI.this.list, roIndex));
                SubstanceListUI.this.list.putClientProperty(ROLLED_OVER_INDEX, roIndex);
            }
        }

        private void fadeOut() {
            Integer prevRoIndex = (Integer)SubstanceListUI.this.list.getClientProperty(ROLLED_OVER_INDEX);
            if (prevRoIndex == null) {
                return;
            }
            FadeTracker.getInstance().trackFadeOut(FadeTracker.FadeKind.ROLLOVER, (Component)SubstanceListUI.this.list, prevRoIndex, false, (FadeTracker.FadeTrackerCallback)new CellRepaintCallback(SubstanceListUI.this.list, prevRoIndex));
        }
    }
}

