/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch.statistics;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.NetworkingStatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.UDPStatistics;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UDPStatisticsImpl
extends NetworkingStatisticsImpl
implements UDPStatistics {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private static HashMap<ParameterCode, ClientParameterCode> parametersToCalculateCodeMap;

    public UDPStatisticsImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.STATISTIC_UDP, aCED, (HashMap)parametersToCalculateCodeMap);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        StringBuffer sb = new StringBuffer(this.getParentVSwitch().getName());
        sb.append(" UDP Statistics");
        this.toStringValue = sb.toString();
        return changedValues;
    }

    @Override
    protected PollingGroupType getGroupType() {
        return PollingGroupType.UDP_GROUP_TYPE;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.UDP_OUT_DATAGRAMS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.UDP_IN_ERRORS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.UDP_NO_PORTS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.UDP_IN_DATAGRAMS, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        parametersToCalculateCodeMap = new HashMap();
        parametersToCalculateCodeMap.put(ParameterCode.UDP_IN_DATAGRAMS, ClientParameterCode.UDP_STATISTICS_DATAGRAMS_RECEIVED_PER_SEC);
        parametersToCalculateCodeMap.put(ParameterCode.UDP_OUT_DATAGRAMS, ClientParameterCode.UDP_STATISTICS_DATAGRAMS_SENT_PER_SEC);
        parametersToCalculateCodeMap.put(ParameterCode.UDP_IN_ERRORS, ClientParameterCode.UDP_STATISTICS_ERRORS_DATAGRAMS_PER_SEC);
    }
}

