/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch.statistics;

import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.statistics.StatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.NetworkingStatistics;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class NetworkingStatisticsImpl
extends StatisticsImpl
implements NetworkingStatistics {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    protected NetworkingStatisticsImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED, HashMap parametersToCalculateCodeMap) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED, parametersToCalculateCodeMap);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    protected NetworkingStatisticsImpl(VSwitchImpl aVS, ClusterImpl cluster, ClassID classId, ConfigElementData aCED, HashMap parametersToCalculateCodeMap) throws RemoteException, IllegalValueException, InvalidElementException {
        super(aVS, cluster, classId, aCED, parametersToCalculateCodeMap);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public void clearParameterList() throws RemoteException {
        VSwitchImpl vswitch = this.getParentVSwitch();
        HashMap<ParameterCode, Parameter> parameters = this.getParameterListValuesMap(vswitch);
        Set<ParameterCode> keys = parameters.keySet();
        for (ParameterCode key : keys) {
            Parameter param;
            if (key == ParameterCode.VSWITCH_ID || (param = this.getParameter(vswitch, key)) == null) continue;
            param.setValue(null);
        }
    }

    static {
        HashMap parameterCodeFlagsMap = new HashMap();
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

