/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch.statistics;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRow;
import com.sanrad.nms.server.logic.vswitch.statistics.InterfaceStatisticsTableRow;
import com.sanrad.nms.server.logic.vswitch.statistics.NetworkingStatisticsImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class InterfaceStatisticsTableRowImpl
extends NetworkingStatisticsImpl
implements InterfaceStatisticsTableRow {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private static HashMap<ParameterCode, ClientParameterCode> parametersToCalculateCodeMap;
    private InterfaceTableRow m_parentInterface;

    public InterfaceStatisticsTableRowImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.STATISTIC_INTERFACE, aCED, (HashMap)parametersToCalculateCodeMap);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    protected PollingGroupType getGroupType() {
        return null;
    }

    @Override
    public SrFuture<Integer> stopPolling() throws RemoteException, IllegalValueException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SrFuture<Void> startPolling() throws RemoteException {
        return new CompleteFuture("InterfaceStatisticsTableRowImpl.startPolling");
    }

    public String getAlias() {
        return (String)this.getValueOf(ParameterCode.IF_ALIAS);
    }

    public InterfaceTableRow getParentInterface() {
        return this.m_parentInterface;
    }

    @Override
    public String getInterfaceAlias() throws RemoteException {
        return this.getParentInterface().getAlias();
    }

    @Override
    public String getInterfaceType() throws RemoteException {
        return this.m_parentInterface.getType();
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        if (!aCED.getParametersList().containsValue(null)) {
            HashMap changedValues = null;
            if (!this.getCluster().isDiscoverCompleted()) {
                for (ParameterCode currParam : aCED.keySet()) {
                    if (currParam == ParameterCode.INTERFACE_ID || currParam == ParameterCode.VSWITCH_ID) continue;
                    aCED.addParameter(new Parameter(currParam, null));
                }
            }
            changedValues = super.changeParameterList(aCED);
            CommKeyClassId parentInterface = (CommKeyClassId)this.getSrValueOf(ParameterCode.INTERFACE_ID);
            this.m_parentInterface = (InterfaceTableRow)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(parentInterface);
            changedValues.put(ParameterCode.INTERFACE_ID, this.getSrValueOf(ParameterCode.INTERFACE_ID));
            return changedValues;
        }
        return new HashMap();
    }

    public String toStringValue() throws RemoteException {
        return "InterfaceStatisticsRow: " + this.getAlias();
    }

    @Override
    public String toString() {
        try {
            return this.toStringValue();
        }
        catch (RemoteException re) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, (Throwable)re, new Object[]{"got a remote exception in the server."});
            return super.toString();
        }
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.INTERFACE_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_OUT_OCTET, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_IN_OCTET, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_DISCONTINUITY, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_IN_UNKNOWN_PROTOCOLS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_OUT_BROADCAST_PKTS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_OUT_MULTICAST_PKTS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_IN_BROADCAST_PKTS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_IN_MULTICAST_PKTS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_OUT_MULTICAST_PKTS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_IN_UNICAST, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_OUT_UNICAST, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_OUT_ERRORS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_OUT_DISCARDS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_IN_ERRORS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_IN_DISCARDS, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        parametersToCalculateCodeMap = new HashMap();
        parametersToCalculateCodeMap.put(ParameterCode.IF_IN_OCTET, ClientParameterCode.IFC_STATISTICS_IN_OCTETS_PER_SEC);
        parametersToCalculateCodeMap.put(ParameterCode.IF_OUT_OCTET, ClientParameterCode.IFC_STATISTICS_OUT_OCTETS_PER_SEC);
        parametersToCalculateCodeMap.put(ParameterCode.IF_OUT_ERRORS, ClientParameterCode.IFC_STATISTICS_OUT_ERRORS_PER_SEC);
    }
}

