/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch.statistics;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.ICMPStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.NetworkingStatisticsImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ICMPStatisticsImpl
extends NetworkingStatisticsImpl
implements ICMPStatistics {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private static HashMap<ParameterCode, ClientParameterCode> parametersToCalculateCodeMap;

    public ICMPStatisticsImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.STATISTIC_ICMP, aCED, (HashMap)parametersToCalculateCodeMap);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        StringBuffer sb = new StringBuffer(this.getParentVSwitch().getName());
        sb.append(" ICMP Statistics");
        this.toStringValue = sb.toString();
        return changedValues;
    }

    @Override
    protected PollingGroupType getGroupType() {
        return PollingGroupType.ICMP_GROUP_TYPE;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.ICMP_OUT_ADDRESS_REPS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_OUT_ADDRESS_MASKS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_OUT_TIMESTAMP_REPS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_OUT_TIMESTAMPS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_OUT_ECHO_REPS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_OUT_ECHOES, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_OUT_REDIRECTS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_OUT_SRC_QUENCHES, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_OUT_PARAMS_PROBS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_OUT_TIME_EXCDS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_OUT_DEST_UNREACHS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_OUT_ERRORS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_OUT_MSGS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_IN_ADDRESS_REPS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_IN_ADDRESS_MASKS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_IN_TIMESTAMP_REPS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_IN_TIMESTAMPS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_IN_ECHO_REPS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_IN_ECHOES, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_IN_REDIRECTS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_IN_SRC_QUENCHES, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_IN_PARAMS_PROBS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_IN_TIME_EXCDS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_IN_DEST_UNREACH, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_IN_ERRORS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ICMP_IN_MSGS, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        parametersToCalculateCodeMap = new HashMap();
        parametersToCalculateCodeMap.put(ParameterCode.ICMP_IN_MSGS, ClientParameterCode.ICMP_STATISTICS_RECEIVED_MESSEGES_PER_SEC);
        parametersToCalculateCodeMap.put(ParameterCode.ICMP_OUT_MSGS, ClientParameterCode.ICMP_STATISTICS_SENT_MESSEGES_PER_SEC);
        parametersToCalculateCodeMap.put(ParameterCode.ICMP_IN_ERRORS, ClientParameterCode.ICMP_STATISTICS_IN_ERRORS_PER_SEC);
        parametersToCalculateCodeMap.put(ParameterCode.ICMP_OUT_ERRORS, ClientParameterCode.ICMP_STATISTICS_OUT_ERRORS_PER_SEC);
    }
}

