/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch.pscsi;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.pscsi.PSCSIInterfaceTableRow;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PSCSIInterfaceTableRowImpl
extends InterfaceTableRowImpl
implements PSCSIInterfaceTableRow {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public PSCSIInterfaceTableRowImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.PSCSI_INTERFACE, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public int getBusId() throws RemoteException {
        Integer busId = (Integer)this.getValueOf(ParameterCode.PSCSI_BUS_ID);
        return busId;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        Integer busId;
        String valid = super.isValid(parameterList);
        if (valid == null && (busId = (Integer)parameterList.get(ClientParameterCode.PSCSI_IF_BUS_ID)) != null) {
            if (busId > 15) {
                return ErrorMessage.ILLEGAL_BUS_ID.getMessage(busId.toString());
            }
            parameterList.put(ClientParameterCode.PSCSI_IF_BUS_ID, new SrInteger(busId));
        }
        return null;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.PSCSI_BUS_ID, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

