/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.SrTestUtils;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.comm.database.XmlDBConnection;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBindList;
import com.sanrad.nms.server.comm.snmp.raid.IbmRaidSubsystem;
import com.sanrad.nms.server.comm.snmp.raid.RaidConfigurationException;
import com.sanrad.nms.server.comm.snmp.raid.RaidControllerTest;
import com.sanrad.nms.server.comm.snmp.raid.RaidMgmtInitializationException;
import com.sanrad.nms.server.comm.snmp.raid.RaidSnmpMgr;
import com.sanrad.nms.server.comm.snmp.raid.RaidSubsystem;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.comm.snmp.trap.SrTrapType;
import com.sanrad.nms.server.comm.snmp.trap.TrapEvent;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.Site;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.DataMgrAOImpl;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.VSwitchStatusConstant;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.concurrent.SrExecutionException;
import com.sanrad.util.concurrent.SrFuture;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class VSwitchImplTest
extends TestCase {
    private SrTestUtils myTestUtils;
    private Properties myVstorProperties = new Properties();
    private XmlDBConnection myXmlConnection = new XmlDBConnection();

    public VSwitchImplTest(String arg0) {
        super(arg0);
        if (this.myTestUtils == null) {
            this.myTestUtils = SrTestUtils.getInstance();
        }
        try {
            this.myVstorProperties.load(new FileInputStream("test//config//RaidController.properties"));
        }
        catch (FileNotFoundException exp) {
            exp.printStackTrace();
        }
        catch (IOException exp) {
            exp.printStackTrace();
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        SrLogger.init((Properties)new Properties());
        this.cleanNeighbors(this.myVstorProperties.getProperty("V_STOR_IP"), this.myVstorProperties.getProperty("OTHER_V_STOR_IP"));
        this.cleanNeighbors(this.myVstorProperties.getProperty("V_STOR_IP"), this.myVstorProperties.getProperty("VSWITCH_IP"));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void testGetVSwitchStatus() {
        Cluster testCluster = null;
        testCluster = this.createClusterInSite();
        try {
            this.addClusterVswitch(testCluster, this.myVstorProperties.getProperty("VSWITCH_IP"), null, null, null);
            VSwitchImpl testVs = ((ClusterImpl)testCluster).getConnectedVSwitches()[0];
            SrSnmpVarBind sysUpTimeBind = new SrSnmpVarBind("sysUpTime.0", (SrType)new SrTimeTicks(102931200));
            SrSnmpVarBind snmpTrapOIDBind = new SrSnmpVarBind("snmpTrapOID.0", (SrType)new SrOidType("1.3.6.1.4.1.10059.2.0.1"));
            SrSnmpVarBind srGenStatusLowMemoryBind = new SrSnmpVarBind("srGenStatus.0", (SrType)VSwitchStatusConstant.LOW_MEMORY);
            SrSnmpVarBind srGenStatusOKBind = new SrSnmpVarBind("srGenStatus.0", (SrType)VSwitchStatusConstant.OK);
            SrSnmpVarBind srGenLastUpdateBind = new SrSnmpVarBind("srGenLastUpdate.0", (SrType)new SrTimeTicks(6433200));
            SrSnmpVarBindList lomMemoryBindList = new SrSnmpVarBindList();
            lomMemoryBindList.add((Object)sysUpTimeBind);
            lomMemoryBindList.add((Object)snmpTrapOIDBind);
            lomMemoryBindList.add((Object)srGenStatusLowMemoryBind);
            lomMemoryBindList.add((Object)srGenLastUpdateBind);
            SrTrap lowMemoryTrap = new SrTrap(SrTrapType.VSWITCH_STATUS, lomMemoryBindList, new SrDateAndTime(new Date()), testVs.getCommKeyClassId().getMyFirstSnmpAgentIndex(), testVs.getMgmIPAddr());
            SrFuture lowMemFuture = DataMgrAOImpl.getInstance().trapReceived(new TrapEvent(new Object(), lowMemoryTrap));
            try {
                lowMemFuture.get();
                Thread.sleep(1000L);
            }
            catch (SrExecutionException e) {
                VSwitchImplTest.assertTrue((String)"Low memory trap failed", (boolean)false);
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                VSwitchImplTest.assertTrue((String)"Low memory trap failed", (boolean)false);
                e.printStackTrace();
            }
            System.out.println(VSwitchStatusConstant.LOW_MEMORY.equals((Object)testVs.getVSwitchStatus()));
            VSwitchImplTest.assertTrue((String)"V-Switch wasn't update with LowMomory status", (boolean)VSwitchStatusConstant.LOW_MEMORY.equals((Object)testVs.getVSwitchStatus()));
            SrSnmpVarBindList okTrapBindList = new SrSnmpVarBindList();
            okTrapBindList.add((Object)sysUpTimeBind);
            okTrapBindList.add((Object)snmpTrapOIDBind);
            okTrapBindList.add((Object)srGenStatusOKBind);
            okTrapBindList.add((Object)srGenLastUpdateBind);
            SrTrap okMemoryTrap = new SrTrap(SrTrapType.VSWITCH_STATUS, okTrapBindList, new SrDateAndTime(new Date()), testVs.getCommKeyClassId().getMyFirstSnmpAgentIndex(), testVs.getMgmIPAddr());
            SrFuture okMemFuture = DataMgrAOImpl.getInstance().trapReceived(new TrapEvent(new Object(), okMemoryTrap));
            try {
                okMemFuture.get();
                Thread.sleep(1000L);
            }
            catch (SrExecutionException e) {
                VSwitchImplTest.assertTrue((String)"OK trap failed", (boolean)false);
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                VSwitchImplTest.assertTrue((String)"OK trap failed", (boolean)false);
                e.printStackTrace();
            }
            VSwitchImplTest.assertTrue((String)"V-Switch wasn't update with OK status", (boolean)VSwitchStatusConstant.OK.equals((Object)testVs.getVSwitchStatus()));
        }
        finally {
            this.removeClusterAndSite(testCluster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddVStor_FirstCtrlIpOnly() {
        Cluster testCluster = null;
        try {
            testCluster = this.createClusterInSite();
            this.addClusterVswitch(testCluster, this.myVstorProperties.getProperty("V_STOR_IP"), null, this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP1"), null);
            this.myTestUtils.waitForDiscoveryToComplete();
            this.myTestUtils.waitMillis(3000L);
            this.checkVstorRaidParams((ClusterImpl)testCluster, this.myVstorProperties.getProperty("V_STOR_IP"), null, this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP1"), null);
        }
        finally {
            this.removeClusterAndSite(testCluster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddVStor_SecondCtrlIpOnly() {
        Cluster testCluster = null;
        try {
            testCluster = this.createClusterInSite();
            this.addClusterVswitch(testCluster, this.myVstorProperties.getProperty("V_STOR_IP"), null, null, this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP2"));
            this.myTestUtils.waitForDiscoveryToComplete();
            this.myTestUtils.waitMillis(3000L);
            this.checkVstorRaidParams((ClusterImpl)testCluster, this.myVstorProperties.getProperty("V_STOR_IP"), null, null, this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP2"));
        }
        finally {
            this.removeClusterAndSite(testCluster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddVStor_CtrlIpsOnly() {
        Cluster testCluster = null;
        try {
            testCluster = this.createClusterInSite();
            this.addClusterVswitch(testCluster, this.myVstorProperties.getProperty("V_STOR_IP"), null, this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP1"), this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP2"));
            this.myTestUtils.waitForDiscoveryToComplete();
            this.myTestUtils.waitMillis(3000L);
            this.checkVstorRaidParams((ClusterImpl)testCluster, this.myVstorProperties.getProperty("V_STOR_IP"), null, this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP1"), this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP2"));
        }
        finally {
            this.removeClusterAndSite(testCluster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddVStor_CtrlIpsAndName() {
        Cluster testCluster = null;
        try {
            testCluster = this.createClusterInSite();
            this.addClusterVswitch(testCluster, this.myVstorProperties.getProperty("V_STOR_IP"), this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_NAME"), this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP1"), this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP2"));
            this.myTestUtils.waitForDiscoveryToComplete();
            this.myTestUtils.waitMillis(3000L);
            this.checkVstorRaidParams((ClusterImpl)testCluster, this.myVstorProperties.getProperty("V_STOR_IP"), this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_NAME"), this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP1"), this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP2"));
        }
        finally {
            this.removeClusterAndSite(testCluster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddVStor_VStorsCluster() {
        Cluster testCluster = null;
        try {
            testCluster = this.createClusterInSite();
            this.addClusterVswitch(testCluster, this.myVstorProperties.getProperty("V_STOR_IP"), this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_NAME"), this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP1"), this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP2"));
            this.myTestUtils.waitForDiscoveryToComplete();
            this.addClusterVswitch(testCluster, this.myVstorProperties.getProperty("OTHER_V_STOR_IP"), this.myVstorProperties.getProperty("OTHER_STORAGE_SUBSYSTEM_NAME"), this.myVstorProperties.getProperty("OTHER_STORAGE_SUBSYSTEM_IP1"), this.myVstorProperties.getProperty("OTHER_STORAGE_SUBSYSTEM_IP2"));
            this.myTestUtils.waitForDiscoveryToComplete();
            this.myTestUtils.waitMillis(3000L);
            this.checkVstorRaidParams((ClusterImpl)testCluster, this.myVstorProperties.getProperty("V_STOR_IP"), this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_NAME"), this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP1"), this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP2"));
            this.checkVstorRaidParams((ClusterImpl)testCluster, this.myVstorProperties.getProperty("OTHER_V_STOR_IP"), this.myVstorProperties.getProperty("OTHER_STORAGE_SUBSYSTEM_NAME"), this.myVstorProperties.getProperty("OTHER_STORAGE_SUBSYSTEM_IP1"), this.myVstorProperties.getProperty("OTHER_STORAGE_SUBSYSTEM_IP2"));
        }
        finally {
            this.removeClusterAndSite(testCluster);
            this.cleanNeighbors(this.myVstorProperties.getProperty("V_STOR_IP"), this.myVstorProperties.getProperty("OTHER_V_STOR_IP"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddVStor_VswitchAndVstorCluster() {
        Cluster testCluster = null;
        try {
            testCluster = this.createClusterInSite();
            this.addClusterVswitch(testCluster, this.myVstorProperties.getProperty("V_STOR_IP"), this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_NAME"), this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP1"), this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP2"));
            this.myTestUtils.waitForDiscoveryToComplete();
            this.addClusterVswitch(testCluster, this.myVstorProperties.getProperty("VSWITCH_IP"), null, null, null);
            this.myTestUtils.waitForDiscoveryToComplete();
            this.myTestUtils.waitMillis(3000L);
            this.checkVstorRaidParams((ClusterImpl)testCluster, this.myVstorProperties.getProperty("V_STOR_IP"), this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_NAME"), this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP1"), this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP2"));
        }
        finally {
            this.removeClusterAndSite(testCluster);
            this.cleanNeighbors(this.myVstorProperties.getProperty("V_STOR_IP"), this.myVstorProperties.getProperty("VSWITCH_IP"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChangeRaidParams_changeName() {
        String vstorIp = this.myVstorProperties.getProperty("V_STOR_IP");
        String ctrlIp1 = this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP1");
        String ctrlIp2 = this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP2");
        String raidName = this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_NAME");
        Cluster testCluster = null;
        try {
            testCluster = this.createClusterInSite();
            this.addClusterVswitch(testCluster, vstorIp, raidName, ctrlIp1, ctrlIp2);
            this.myTestUtils.waitForDiscoveryToComplete();
            this.myTestUtils.waitMillis(3000L);
        }
        finally {
            this.removeClusterAndSite(testCluster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChangeRaidParams_changeDefaultName() {
        String vstorIp = this.myVstorProperties.getProperty("V_STOR_IP");
        String ctrlIp1 = this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP1");
        String ctrlIp2 = this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP2");
        Cluster testCluster = null;
        try {
            testCluster = this.createClusterInSite();
            this.addClusterVswitch(testCluster, vstorIp, null, ctrlIp1, ctrlIp2);
            this.myTestUtils.waitForDiscoveryToComplete();
            this.myTestUtils.waitMillis(3000L);
        }
        finally {
            this.removeClusterAndSite(testCluster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddVStor_RaidExistInSmApp() {
        String vstorIp = this.myVstorProperties.getProperty("V_STOR_IP");
        String ctrlIp1 = this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP1");
        String ctrlIp2 = this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP2");
        String raidName = this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_NAME");
        Cluster testCluster = null;
        try {
            String oldName = VSwitchImplTest.getAutoRaidName();
            RaidControllerTest.addStorageSubsystem((String)oldName, (String)ctrlIp1, null, (char)'\u0000');
            testCluster = this.createClusterInSite();
            this.addClusterVswitch(testCluster, vstorIp, raidName, ctrlIp1, ctrlIp2);
            this.myTestUtils.waitForDiscoveryToComplete();
            this.myTestUtils.waitMillis(3000L);
            VSwitchImpl vstor = ((ClusterImpl)testCluster).getVSwitchByIPAddress(vstorIp);
            IbmRaidSubsystem raid = RaidControllerTest.getStorageSubsystem((String)ctrlIp1, (String)ctrlIp2, (char)vstor.getCommKeyClassId().getMyFirstSnmpAgentIndex());
            List ips = raid.getIPAddresses();
            if (!ips.contains(new SrIpAddress(ctrlIp1)) || !ips.contains(new SrIpAddress(ctrlIp2))) {
                VSwitchImplTest.fail((String)"Not all CTRL Raid IPs were found in SM Application");
            }
            if (!raid.getName().equals(raidName)) {
                VSwitchImplTest.fail((String)"Raid name in not as requested");
            }
            this.removeClusterAndSite(testCluster);
        }
        catch (RaidConfigurationException e) {
            VSwitchImplTest.fail((String)e.getMessage());
        }
        finally {
            this.removeClusterAndSite(testCluster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddVStor_OtherVStorAlreadyExists_commonIpError() throws RaidMgmtInitializationException {
        String vstorIp = this.myVstorProperties.getProperty("V_STOR_IP");
        String otherVstorIp = this.myVstorProperties.getProperty("OTHER_V_STOR_IP");
        String ctrlIp1 = this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP1");
        String ctrlIp2 = this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP2");
        String raidName = this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_NAME");
        Cluster testCluster1 = null;
        Cluster testCluster2 = null;
        try {
            testCluster1 = this.createClusterInSite();
            this.addClusterVswitch(testCluster1, vstorIp, raidName, ctrlIp1, ctrlIp2);
            this.myTestUtils.waitForDiscoveryToComplete();
            this.myTestUtils.waitMillis(3000L);
            testCluster2 = this.createClusterInSite();
            this.addClusterVswitch(testCluster2, otherVstorIp, null, ctrlIp1, ctrlIp2);
            this.myTestUtils.waitForDiscoveryToComplete();
            this.myTestUtils.waitMillis(3000L);
            VSwitchImpl secondVstor = ((ClusterImpl)testCluster2).getVSwitchByIPAddress(otherVstorIp);
            RaidSubsystem otherRaid = RaidSnmpMgr.getInstance().getRaidSubsystem(secondVstor.getCommKeyClassId().getMyFirstSnmpAgentIndex(), new SrIpAddress(ctrlIp1), new SrIpAddress(ctrlIp2));
            VSwitchImplTest.assertNull((String)("V-Stor " + otherVstorIp + " is connected to an equivalent RAID as V-Stor " + vstorIp), (Object)otherRaid);
            this.removeClusterAndSite(testCluster1);
            this.removeClusterAndSite(testCluster2);
        }
        catch (Throwable throwable) {
            this.removeClusterAndSite(testCluster1);
            this.removeClusterAndSite(testCluster2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddVStor_OtherVStorAlreadyExists_sameNameError() throws RaidMgmtInitializationException {
        String vstorIp = this.myVstorProperties.getProperty("V_STOR_IP");
        String otherVstorIp = this.myVstorProperties.getProperty("OTHER_V_STOR_IP");
        String ctrlIp1 = this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP1");
        String ctrlIp2 = this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_IP2");
        String otherCtrlIp1 = this.myVstorProperties.getProperty("OTHER_STORAGE_SUBSYSTEM_IP1");
        String otherCtrlIp2 = this.myVstorProperties.getProperty("OTHER_STORAGE_SUBSYSTEM_IP2");
        String raidName = this.myVstorProperties.getProperty("STORAGE_SUBSYSTEM_NAME");
        String otherRaidName = this.myVstorProperties.getProperty("OTHER_STORAGE_SUBSYSTEM_NAME");
        Cluster testCluster1 = null;
        Cluster testCluster2 = null;
        try {
            testCluster1 = this.createClusterInSite();
            this.addClusterVswitch(testCluster1, vstorIp, raidName, ctrlIp1, ctrlIp2);
            this.myTestUtils.waitForDiscoveryToComplete();
            this.myTestUtils.waitMillis(3000L);
            testCluster2 = this.createClusterInSite();
            this.addClusterVswitch(testCluster2, otherVstorIp, otherRaidName, otherCtrlIp1, otherCtrlIp2);
            this.myTestUtils.waitForDiscoveryToComplete();
            this.myTestUtils.waitMillis(3000L);
            this.removeClusterAndSite(testCluster1);
            this.removeClusterAndSite(testCluster2);
        }
        catch (Throwable throwable) {
            this.removeClusterAndSite(testCluster1);
            this.removeClusterAndSite(testCluster2);
            throw throwable;
        }
    }

    private Cluster createClusterInSite() {
        Site testSite = null;
        testSite = this.myTestUtils.createSite("testSite");
        VSwitchImplTest.assertNotNull((String)"Site creation failed", (Object)testSite);
        ClusterImpl testCluster = this.myTestUtils.createCluster("testCluster", testSite);
        VSwitchImplTest.assertNotNull((String)"Failed to create testCluster", (Object)testCluster);
        return testCluster;
    }

    private void removeClusterAndSite(Cluster aCluster) {
        try {
            this.myTestUtils.removeSite(aCluster.getParentSite());
            while (SystemRootImpl.getInstance().getSites().size() != 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void checkVstorRaidParams(ClusterImpl aClusterToCheck, String aVstorIp, String aRaidName, String aRaidCtrlIp1, String aRaidCtrlIp2) {
        SrIpAddress ctrlIp2InVs;
        SrIpAddress ctrlIp1InVs;
        VSwitchImpl vstor = aClusterToCheck.getVSwitchByIPAddress(aVstorIp);
        VSwitchImplTest.assertNotNull((String)("V-Stor " + aVstorIp + " wasn't found in cluster " + aClusterToCheck), (Object)vstor);
        HashMap<ParameterCode, Parameter> params = vstor.getParameters(null);
        SrString raidNameInVs = (SrString)params.get(ParameterCode.ATTACHED_RAID_NAME).getValue();
        if (aRaidName != null) {
            VSwitchImplTest.assertEquals((String)("The RAID name " + raidNameInVs + " is not as was set, " + aRaidName), (String)raidNameInVs.toString(), (String)aRaidName);
        }
        if ((ctrlIp1InVs = (SrIpAddress)params.get(ParameterCode.ATTACHED_RAID_NAME).getValue()) != null) {
            VSwitchImplTest.assertEquals((String)("The first Ctrl IP " + ctrlIp1InVs + " is not as was set, " + aRaidCtrlIp1), (String)ctrlIp1InVs.toString(), (String)aRaidCtrlIp1);
        }
        if ((ctrlIp2InVs = (SrIpAddress)params.get(ParameterCode.ATTACHED_RAID_NAME).getValue()) != null) {
            VSwitchImplTest.assertEquals((String)("The second Ctrl IP " + ctrlIp2InVs + " is not as was set, " + aRaidCtrlIp2), (String)ctrlIp2InVs.toString(), (String)aRaidCtrlIp2);
        }
    }

    private void addClusterVswitch(Cluster aCluster, String aVstorIP, String aRaidName, String aRaidCtrlIp1, String aRaidCtrlIp2) {
        String defIpMask = Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SNMP_DEFAULT_IP_MASK);
        int defRetries = new Integer(Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SNMP_DEFAULT_NUM_OF_RETRIES));
        int defSnmpPort = new Integer(Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SNMP_DEFAULT_PORT));
        int defTrapPort = new Integer(Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SNMP_DEFAULT_TRAP_PORT));
        String defWriteComm = Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SNMP_DEFAULT_WRITE_COMMUNITY);
        String defReadComm = Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SNMP_DEFAULT_READ_COMMUNITY);
        int defTimeout = new Integer(Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SNMP_DEFAULT_TIMEOUT_MILISEC));
        SnmpVersion defVersion = SnmpVersion.V2C;
        try {
            LogicMgrAOImpl.getInstance().addClusterVSwitch(aCluster.getCommKeyClassId(), aVstorIP, defIpMask, defSnmpPort, defTrapPort, defReadComm, defWriteComm, defTimeout, defRetries, defVersion).get();
            System.out.println("V-Stor " + aVstorIP + " added to cluster " + aCluster);
        }
        catch (SrExecutionException e) {
            e.printStackTrace();
            VSwitchImplTest.fail((String)e.getMessage());
        }
        catch (RemoteException e) {
            VSwitchImplTest.fail((String)("The test failed because of the exception: " + e));
        }
        catch (InterruptedException e) {
            VSwitchImplTest.fail((String)("The test failed because of the exception: " + e));
        }
    }

    private void cleanNeighbors(String aVsIp1, String aVsIp2) {
    }

    private static String getAutoRaidName() {
        return "V-STOR" + (int)(Math.random() * 1000.0);
    }
}

