/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.vswitch.VSwitchAlarmGenerator;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.logic.BasicLogicObjectImpl;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.PollingElement;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.hardware.HardwareImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiatorImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiator;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorStatisticsImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorsGroupStatistics;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorsGroupStatisticsImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSIInstanceImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionStatisticsImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionsGroupStatistics;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionsGroupStatisticsImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.raid.AttachedRaidImpl;
import com.sanrad.nms.server.logic.statistics.Statistics;
import com.sanrad.nms.server.logic.statistics.StatisticsImpl;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.target.TargetQosGroupImpl;
import com.sanrad.nms.server.logic.vswitch.IPRouteTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.IPRouteTableRowValidator;
import com.sanrad.nms.server.logic.vswitch.IPTableRow;
import com.sanrad.nms.server.logic.vswitch.IPTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.IPTableRowValidator;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRow;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.ManagerImpl;
import com.sanrad.nms.server.logic.vswitch.NeighborImpl;
import com.sanrad.nms.server.logic.vswitch.PortalTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.PortalTableRowValidator;
import com.sanrad.nms.server.logic.vswitch.SFPConnectedInterfaceImpl;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchConnectivityEvent;
import com.sanrad.nms.server.logic.vswitch.VSwitchConnectivityListener;
import com.sanrad.nms.server.logic.vswitch.VSwitchImplJmx;
import com.sanrad.nms.server.logic.vswitch.VSwitchValidator;
import com.sanrad.nms.server.logic.vswitch.fc.FCNodeImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.EthernetStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.EthernetStatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.ICMPStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.ICMPStatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.IPStatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.InterfaceStatisticsTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.InterfacesGroupStatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.TCPConnectionStatisticsTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.TCPStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.TCPStatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.UDPListenerStatisticsTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.UDPStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.UDPStatisticsImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrLong;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTAddress;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.IscsiPortalRolesConstant;
import com.sanrad.nms.server.util.types.constants.IscsiTgtQosActivityConstant;
import com.sanrad.nms.server.util.types.constants.NetConfigActivityConstant;
import com.sanrad.nms.server.util.types.constants.ResetConstant;
import com.sanrad.nms.server.util.types.constants.SDTakeOverStateConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.nms.server.util.types.constants.StorageDiscoveryOperationConstant;
import com.sanrad.nms.server.util.types.constants.TempetureUnitConstant;
import com.sanrad.nms.server.util.types.constants.VSwitchCapabilityConstant;
import com.sanrad.nms.server.util.types.constants.VSwitchStatusConstant;
import com.sanrad.nms.server.util.types.constants.VSwitchSysOID;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.NetUtil;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.IFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.io.IOException;
import java.math.BigInteger;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class VSwitchImpl
extends BasicLogicObjectImpl
implements VSwitch,
PollingElement {
    private SrFuture<Void> myDiscoveryFuture = new CompleteFuture("VSwitchImpl.Discovery");
    private static final int WAKE_ON_LAN_PORT = 9;
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private VSwitchImplJmx myBean = null;
    private boolean isAlwaysEnableDeletion = false;
    private VSwitchImpl myInconsistentNeighborToRemove = null;
    private HashMap<ClassID, StatisticsImpl> myClassIdToStatisticsMap = new HashMap();
    private static Comparator<DirectAccessDeviceImpl> theEntityNameComparator;
    private boolean myIsConnected = false;
    private boolean myIsDiscoverCompleted = false;
    private String myIsNeighborValid = null;
    private Cluster myWatingMovingCluster = null;
    private HardwareImpl myHardwareObj = null;
    private FCNodeImpl myFCNode;
    private Vector<IPTableRowImpl> myIPTable = new Vector();
    private Vector<InterfaceTableRowImpl> myInterfaceTable = new Vector();
    private Vector<IPRouteTableRowImpl> myIPRouteTable = new Vector();
    private Vector<PortalTableRowImpl> myPortalTable = new Vector();
    private Vector<NeighborImpl> myNeighborTable = new Vector();
    private Vector<ManagerImpl> myManagerTable = new Vector();
    private Vector<InterfaceStatisticsTableRowImpl> myInterfaceStatisticsTable = new Vector();
    private Vector<UDPListenerStatisticsTableRowImpl> myUdpListenerStatisticsTable = new Vector();
    private Vector<TCPConnectionStatisticsTableRowImpl> myTcpConnectionStatisticsTable = new Vector();
    private Vector<ISCSIInstanceImpl> myIscsiInstances = new Vector();
    private Vector<ISCSISessionImpl> myIscsiSessions = new Vector();
    private Vector<ISCSIRemoteInitiatorImpl> mIscsiRemoteInitiators = new Vector();
    private Vector<ISCSIRemoteInitiatorStatisticsImpl> myIscsiRemoteInitiatorsStatistics = new Vector();
    private Vector<ISCSISessionStatisticsImpl> mIscsiSessionsStatistics = new Vector();
    private ArrayList<ISCSIInitiatorImpl> myIscsiInitiators = new ArrayList();
    private String myIPAddr = null;
    SrEventListenerManager.Informer<VSwitchConnectivityListener, VSwitchConnectivityEvent> vSwitchConnectivityChangedInformer = new SrEventListenerManager.Informer<VSwitchConnectivityListener, VSwitchConnectivityEvent>(){

        public void inform(VSwitchConnectivityListener listener, VSwitchConnectivityEvent event) {
            listener.vSwitchConnectivityChanged(event);
        }
    };

    public VSwitchImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.VSWITCH, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
        ConfigElementData ifaceGroupCed = new ConfigElementData(ClassID.STATISTIC_INTERFACES_GROUP);
        ifaceGroupCed.addParameter((ParameterCodes)ParameterCode.VSWITCH_ID, (Object)this.getCommKeyClassId());
        this.myClassIdToStatisticsMap.put(ClassID.STATISTIC_INTERFACES_GROUP, new InterfacesGroupStatisticsImpl(this, ifaceGroupCed));
        ConfigElementData rigCed = new ConfigElementData(ClassID.REMOTE_INITIATORS_STATISTICS_GROUP);
        rigCed.addParameter((ParameterCodes)ParameterCode.VSWITCH_ID, (Object)this.getCommKeyClassId());
        this.myClassIdToStatisticsMap.put(ClassID.REMOTE_INITIATORS_STATISTICS_GROUP, new ISCSIRemoteInitiatorsGroupStatisticsImpl(this, rigCed));
        ConfigElementData sgCed = new ConfigElementData(ClassID.SESSIONS_STATISTICS_GROUP);
        sgCed.addParameter((ParameterCodes)ParameterCode.VSWITCH_ID, (Object)this.getCommKeyClassId());
        this.myClassIdToStatisticsMap.put(ClassID.SESSIONS_STATISTICS_GROUP, new ISCSISessionsGroupStatisticsImpl(this, sgCed));
        this.addConnectivityListener(cluster);
    }

    public boolean isInterfaceAliasExist(String alias) {
        for (InterfaceTableRowImpl row : this.getInterfaceTable()) {
            if (!row.getAlias().equals(alias)) continue;
            return true;
        }
        return false;
    }

    public Statistics getStatistics(ClassID aClassId) {
        if (aClassId == null) {
            throw new IllegalArgumentException("The given class id should not be null.");
        }
        Statistics retVal = this.myClassIdToStatisticsMap.get(aClassId);
        if (retVal == null) {
            throw new IllegalArgumentException("The statistics instance for class id " + aClassId + " was not initialized before it was queried.");
        }
        return retVal;
    }

    public void setStatistics(ClassID aClassId, Statistics aStatis) {
        if (aClassId == null || aStatis == null) {
            throw new IllegalArgumentException("the given parameters should not be null. aClassId = " + aClassId + "; aStatis = " + aStatis);
        }
        this.myClassIdToStatisticsMap.put(aClassId, (StatisticsImpl)aStatis);
    }

    @Override
    public HardwareImpl getHardware() {
        return this.myHardwareObj;
    }

    public void setHardware(HardwareImpl hardware) {
        this.myHardwareObj = hardware;
    }

    public void setTCPStatistics(TCPStatisticsImpl tcp) {
        this.myClassIdToStatisticsMap.put(ClassID.STATISTIC_TCP, tcp);
    }

    public void setUDPStatistics(UDPStatisticsImpl udp) {
        this.myClassIdToStatisticsMap.put(ClassID.STATISTIC_UDP, udp);
    }

    public void setICMPStatistics(ICMPStatisticsImpl icmp) {
        this.myClassIdToStatisticsMap.put(ClassID.STATISTIC_ICMP, icmp);
    }

    public void setIPStatistics(IPStatisticsImpl ip) {
        this.myClassIdToStatisticsMap.put(ClassID.STATISTIC_IP, ip);
    }

    public void setEthernetStatistics(EthernetStatisticsImpl ethernet) {
        this.myClassIdToStatisticsMap.put(ClassID.STATISTIC_ETHERNET, ethernet);
    }

    @Override
    public TempetureUnitConstant getTempUnits() {
        return (TempetureUnitConstant)this.getSrValueOf(this, ParameterCode.TEMPERATURE_UNITS);
    }

    public void addConnectivityListener(VSwitchConnectivityListener listener) {
        this.m_listeners.add((EventListener)listener);
    }

    public void removeConnectivityListener(VSwitchConnectivityListener listener) {
        this.m_listeners.remove((EventListener)listener);
    }

    private void fireConnectivityChanged(boolean connectivityState) {
        VSwitchConnectivityEvent event = new VSwitchConnectivityEvent(this, this, connectivityState);
        this.m_listeners.fireEvent(VSwitchConnectivityListener.class, (EventObject)event, this.vSwitchConnectivityChangedInformer);
    }

    private HashMap getManagerParameterList(HashMap parameterList) {
        HashMap managerParameterList = new HashMap();
        if (parameterList.containsKey(ClientParameterCode.VSWITCH_READ_COMMUNITY)) {
            managerParameterList.put(ClientParameterCode.MANAGER_READ_COMMUNITY, parameterList.get(ClientParameterCode.VSWITCH_READ_COMMUNITY));
        }
        if (parameterList.containsKey(ClientParameterCode.VSWITCH_WRITE_COMMUNITY)) {
            managerParameterList.put(ClientParameterCode.MANAGER_WRITE_COMMUNITY, parameterList.get(ClientParameterCode.VSWITCH_WRITE_COMMUNITY));
        }
        if (parameterList.containsKey(ClientParameterCode.VSWITCH_TRAP_PORT)) {
            managerParameterList.put(ClientParameterCode.MANAGER_TRAP_PORT, parameterList.get(ClientParameterCode.VSWITCH_TRAP_PORT));
        }
        return managerParameterList;
    }

    @Override
    public SrFuture<Void> changeElement(HashMap parameterList) throws IllegalValueException {
        ConfigElementData vsData;
        HashMap tmpParameterList = new HashMap(parameterList);
        String msg = this.isValid(tmpParameterList);
        if (msg != null) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{msg});
            throw new IllegalValueException(msg);
        }
        HashMap managerParameterList = this.getManagerParameterList(parameterList);
        ConfigElementDataList cedList = new ConfigElementDataList();
        if (managerParameterList != null) {
            for (ManagerImpl manager : this.getThisMachineManagers()) {
                cedList.add((ElementData)manager.validateChangeAndCreateCED(managerParameterList));
            }
        }
        if ((vsData = this.validateChangeAndCreateCED(parameterList)).containsParameter(ParameterCode.VSWITCH_SNMP_UDP_PORT) && this.isConnected()) {
            SrIpAddress vsIP = new SrIpAddress(this.getMgmIPAddr());
            SrInteger mgntPort = (SrInteger)vsData.getValue((ParameterCodes)ParameterCode.VSWITCH_SNMP_UDP_PORT);
            SrTAddress newIPAndPort = new SrTAddress(vsIP, mgntPort);
            vsData.setValue(ParameterCode.VSWITCH_TADDRESS, (SrType)newIPAndPort);
        }
        if (vsData.containsParameter(ParameterCode.TARGET_QOS_GROUP_RATE_LIMIT)) {
            SrGauge qosRate = (SrGauge)vsData.removeParameter(ParameterCode.TARGET_QOS_GROUP_RATE_LIMIT);
            for (TargetQosGroupImpl qosGroup : this.cluster.getTargetQosMgr().getGroups()) {
                if (!this.equals(qosGroup.getActiveVswitch())) continue;
                ConfigElementData qosGroupCed = new ConfigElementData(qosGroup.getCommKeyClassId());
                qosGroupCed.setValue(ParameterCode.TARGET_QOS_GROUP_RATE_LIMIT, (SrType)qosRate);
                cedList.add((ElementData)qosGroupCed);
            }
        }
        cedList.add((ElementData)vsData);
        return this.innerChangeElement(cedList);
    }

    @Override
    protected String isValid(HashMap parameterList) {
        Long qosLimit;
        Integer qosEnabled;
        Boolean reportLUNDiscovery;
        Boolean failover;
        Integer faulty;
        Integer suspicious;
        Integer keepAlive;
        BigInteger telnetPort;
        String writeCommunity;
        String readCommunity;
        Integer retries;
        Integer switchId;
        Integer trapPort;
        Integer snmpPort;
        Long timeout;
        Long time;
        String location;
        String contact;
        String name = (String)parameterList.get(ClientParameterCode.VSWITCH_NAME);
        if (name != null) {
            if (name.trim().equals("")) {
                return ClassID.VSWITCH + " name cannot be empty. Please select another name.";
            }
            if (this.cluster.isVSwitchNameExist(name)) {
                return "Name " + name + " already exists in Cluster. Please select another name.";
            }
            parameterList.put(ClientParameterCode.VSWITCH_NAME, new SrString(name));
        }
        if ((contact = (String)parameterList.get(ClientParameterCode.VSWITCH_CONTACT)) != null) {
            parameterList.put(ClientParameterCode.VSWITCH_CONTACT, new SrString(contact));
        }
        if ((location = (String)parameterList.get(ClientParameterCode.VSWITCH_LOCATION)) != null) {
            parameterList.put(ClientParameterCode.VSWITCH_LOCATION, new SrString(location));
        }
        if ((time = (Long)parameterList.get(ClientParameterCode.VSWITCH_DATE_AND_TIME)) != null) {
            parameterList.put(ClientParameterCode.VSWITCH_DATE_AND_TIME, new SrDateAndTime(time));
        }
        if ((timeout = (Long)parameterList.get(ClientParameterCode.VSWITCH_TIMEOUT)) != null) {
            parameterList.put(ClientParameterCode.VSWITCH_TIMEOUT, new SrLong(timeout));
        }
        if ((snmpPort = (Integer)parameterList.get(ClientParameterCode.VSWITCH_SNMP_PORT)) != null) {
            parameterList.put(ClientParameterCode.VSWITCH_SNMP_PORT, new SrInteger(snmpPort));
        }
        if ((trapPort = (Integer)parameterList.get(ClientParameterCode.VSWITCH_TRAP_PORT)) != null) {
            parameterList.put(ClientParameterCode.VSWITCH_TRAP_PORT, new SrInteger(trapPort));
        }
        if ((switchId = (Integer)parameterList.get(ClientParameterCode.VSWITCH_SWITCH_ID)) != null) {
            parameterList.put(ClientParameterCode.VSWITCH_SWITCH_ID, new SrInteger(switchId));
        }
        if ((retries = (Integer)parameterList.get(ClientParameterCode.VSWITCH_RETRIES)) != null) {
            parameterList.put(ClientParameterCode.VSWITCH_RETRIES, new SrInteger(retries));
        }
        if ((readCommunity = (String)parameterList.get(ClientParameterCode.VSWITCH_READ_COMMUNITY)) != null) {
            String errMsg = VSwitchValidator.isCommunityValid(readCommunity);
            if (errMsg == null) {
                parameterList.put(ClientParameterCode.VSWITCH_READ_COMMUNITY, new SrString(readCommunity));
            } else {
                return "Read Community '" + readCommunity + "' is not valid: " + errMsg;
            }
        }
        if ((writeCommunity = (String)parameterList.get(ClientParameterCode.VSWITCH_WRITE_COMMUNITY)) != null) {
            String errMsg = VSwitchValidator.isCommunityValid(writeCommunity);
            if (errMsg == null) {
                parameterList.put(ClientParameterCode.VSWITCH_WRITE_COMMUNITY, new SrString(writeCommunity));
            } else {
                return "Write Community '" + writeCommunity + "' string is not valid: " + errMsg;
            }
        }
        if ((telnetPort = (BigInteger)parameterList.get(ClientParameterCode.VSWITCH_TELNET_PORT)) != null) {
            parameterList.put(ClientParameterCode.VSWITCH_TELNET_PORT, new SrGauge(telnetPort.toString()));
        }
        if ((keepAlive = (Integer)parameterList.get(ClientParameterCode.KEEP_ALIVE)) != null) {
            if (keepAlive <= 0) {
                return "Keep alive interval " + keepAlive + " should be positive. Please select another interval.";
            }
            parameterList.put(ClientParameterCode.KEEP_ALIVE, new SrInteger(keepAlive));
        }
        if ((suspicious = (Integer)parameterList.get(ClientParameterCode.SUSPICIOUS_INTERVAL)) != null) {
            if (keepAlive == null) {
                keepAlive = this.getKeepAliveInterval();
            }
            if (suspicious <= keepAlive) {
                return "Suspicious interval " + suspicious + " should be bigger than keep alive interval. Please select another interval.";
            }
            parameterList.put(ClientParameterCode.SUSPICIOUS_INTERVAL, new SrInteger(suspicious));
        }
        if ((faulty = (Integer)parameterList.get(ClientParameterCode.FAULTY_INTERVAL)) != null) {
            if (suspicious == null) {
                suspicious = this.getSuspiciousInterval();
            }
            if (faulty <= suspicious) {
                return "Faulty interval " + faulty + " should be bigger than suspicious interval. Please select another interval.";
            }
            parameterList.put(ClientParameterCode.FAULTY_INTERVAL, new SrInteger(faulty));
        }
        if ((failover = (Boolean)parameterList.get(ClientParameterCode.FAILOVER_ENABLE)) != null) {
            int failoverValue = failover != false ? 1 : 2;
            parameterList.put(ClientParameterCode.FAILOVER_ENABLE, new SrInteger(failoverValue));
        }
        if ((reportLUNDiscovery = (Boolean)parameterList.get(ClientParameterCode.VSWITCH_REPORT_LUN_DISCOVERY)) != null) {
            int reportLUNs = reportLUNDiscovery != false ? 1 : 2;
            parameterList.put(ClientParameterCode.VSWITCH_REPORT_LUN_DISCOVERY, new SrInteger(reportLUNs));
        }
        if ((qosEnabled = (Integer)parameterList.get(ClientParameterCode.VSWITCH_TGT_QOS_ACTIVITY)) != null) {
            parameterList.put(ClientParameterCode.VSWITCH_TGT_QOS_ACTIVITY, new SrInteger(qosEnabled));
        }
        if ((qosLimit = (Long)parameterList.get(ClientParameterCode.TARGET_QOS_GROUP_RATE_LIMIT)) != null) {
            parameterList.put(ClientParameterCode.TARGET_QOS_GROUP_RATE_LIMIT, new SrGauge(qosLimit.longValue()));
        }
        return null;
    }

    private SrFuture<Void> readInitiator(ISCSIInitiatorImpl initiator) {
        CommKeyClassId iscsiInitiatorCommKeyClassId = initiator.getCommKeyClassId();
        CommKeyClassId scsiInitiatorCommKeyClassId = this.cluster.getSCSIId(iscsiInitiatorCommKeyClassId);
        ConfigElementData element = new ConfigElementData(scsiInitiatorCommKeyClassId);
        return DataMgrAdapter.getInstance().readElement(element);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        VSwitchImpl vSwitch;
        String oldName = this.getName();
        SDTakeOverStateConstant oldTakeoverState = this.getTakeOverState();
        if (!aCED.containsParameter(ParameterCode.VSWITCH_TARGETS_COUNT) && this.getValueOf(ParameterCode.VSWITCH_TARGETS_COUNT) == null) {
            aCED.setValue(ParameterCode.VSWITCH_TARGETS_COUNT, (SrType)new SrInteger(0));
        }
        HashMap changedValues = super.changeParameterList(aCED);
        if (this.getMgmIPAddr() == null) {
            this.setMgmIPAddr(this.getDisplayStringOf(this, ParameterCode.VSWITCH_IP_ADDRESS));
        }
        this.toStringValue = this.getMgmIPAddr();
        SDTakeOverStateConstant newTakeoverState = this.getTakeOverState();
        if (this.isRediscoverNeeded(oldTakeoverState, newTakeoverState)) {
            ErrorAssertingListener.listenTo(this.cluster.rediscover());
        }
        if (this.isKeepaliveCheckNeeded(oldTakeoverState, newTakeoverState)) {
            this.getOtherVSwitchFromCluster(this).sendKeepAlive();
        }
        if (!changedValues.containsKey(ParameterCode.VSWITCH_NAME) || (vSwitch = this.cluster.getOtherVSwitch(this)) == null || vSwitch.getName().equals(this.getName())) {
            // empty if block
        }
        if (aCED.getParametersList().containsKey(ParameterCode.VSWITCH_NAME) && this.getCapability() == null) {
            ConfigElementData tmpCed = new ConfigElementData(aCED.getCommKeyClassId());
            tmpCed.addParameter((ParameterCodes)ParameterCode.VSWITCH_CAPABILITY, (Object)VSwitchCapabilityConstant.GDR);
            super.changeParameterList(tmpCed);
        }
        if (oldName != null && !oldName.equals(this.getName())) {
            ISCSIInitiator[] iSCSIInitiators;
            ErrorAssertingListener.listenTo(this.cluster.getTargetListMgr().readExposedOn());
            if (this.cluster.isDiscoverCompleted() && (iSCSIInitiators = this.getISCSIInitiators()).length > 0) {
                ISCSIInitiatorImpl vswitchInitiator = (ISCSIInitiatorImpl)iSCSIInitiators[0];
                ErrorAssertingListener.listenTo(this.readInitiator(vswitchInitiator));
            }
        }
        if (this.myBean == null) {
            this.myBean = new VSwitchImplJmx(this);
        }
        return changedValues;
    }

    private boolean isRediscoverNeeded(SDTakeOverStateConstant oldTakeoverState, SDTakeOverStateConstant newTakeoverState) {
        return this.cluster.getVSwitchesCount() > 1 && !this.cluster.getOtherVSwitch(this).isConnected() && oldTakeoverState != null && newTakeoverState != null && !oldTakeoverState.equals((Object)newTakeoverState) && newTakeoverState.equals((Object)SDTakeOverStateConstant.SD_TAKE_OVER_STATE_UNDER_TAKE_OVER);
    }

    private boolean isKeepaliveCheckNeeded(SDTakeOverStateConstant oldTakeoverState, SDTakeOverStateConstant newTakeoverState) {
        return this.cluster.getVSwitchesCount() > 1 && this.getOtherVSwitchFromCluster(this) != null && oldTakeoverState != null && newTakeoverState != null && !oldTakeoverState.equals((Object)newTakeoverState) && newTakeoverState.equals((Object)SDTakeOverStateConstant.SD_TAKE_OVER_STATE_UNDER_TAKE_OVER);
    }

    private void sendKeepAlive() {
        ConfigElementData ced = new ConfigElementData(this.getCommKeyClassId());
        ced.setValue(ParameterCode.VSWITCH_DATE_AND_TIME, (SrType)null);
        ced.setValue(ParameterCode.VSWITCH_ID, (SrType)this.getCommKeyClassId());
        ErrorAssertingListener.listenTo(this.refreshFields(ced));
    }

    public Vector<InterfaceTableRowImpl> getEthernetInterfaces() {
        Vector<InterfaceTableRowImpl> ethernetInterfaces = new Vector<InterfaceTableRowImpl>();
        for (InterfaceTableRowImpl row : this.getInterfaceTable()) {
            if (!row.isEthernet()) continue;
            ethernetInterfaces.addElement(row);
        }
        return ethernetInterfaces;
    }

    @Override
    public SrFuture<Void> deleteElement() throws RemoteException, IllegalValueException {
        final SrFuture retFuture = new SrFuture("VSwitchImpl.deleteElement");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        String canDeleteMsg = this.canBeDeleted();
        if (!this.isDeletedFromDatabaseOnly() && canDeleteMsg == null) {
            List<ISCSITargetImpl> targetsExposeOn;
            VSwitchImpl otherVSwitch = this.cluster.getOtherVSwitch(this);
            if (otherVSwitch != null && !(targetsExposeOn = this.cluster.getOtherVSwitchTargetsExposedOnVSwitch(this)).isEmpty()) {
                this.setDeletionPending();
                for (ISCSITargetImpl target : targetsExposeOn) {
                    try {
                        HashMap<ClientParameterCode, String> parameterList = new HashMap<ClientParameterCode, String>();
                        parameterList.put(ClientParameterCode.TARGET_EXPOSED_ON, otherVSwitch.getName());
                        midFutures.add(((LogicObjectImpl)target).changeElement(parameterList));
                    }
                    catch (IllegalValueException ive) {
                        this.clearDeletionStatus();
                        String msg = ive.getMessage() + " when trying to delete " + ClassID.VSWITCH + " " + this;
                        theLogger.warn(SrLogCategories.LEGACY, new Object[]{msg});
                        IllegalValueException tmpIve = new IllegalValueException(msg);
                        tmpIve.setStackTrace(ive.getStackTrace());
                        throw tmpIve;
                    }
                }
            }
        } else if (canDeleteMsg != null) {
            throw new IllegalValueException(canDeleteMsg);
        }
        midFutures.add(super.deleteElement());
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    @Override
    protected String canBeDeleted() {
        if (!this.isDeletedFromDatabaseOnly()) {
            VSwitchImpl otherVSwitch = this.cluster.getOtherVSwitch(this);
            if (!this.isAlwaysEnableDeletion() && otherVSwitch != null && !otherVSwitch.isNeighborDead(this)) {
                return "You cannot remove " + ClassID.VSWITCH + " " + this.getName() + ", because it's not dead for " + otherVSwitch.getName() + ".";
            }
            if (otherVSwitch != null && SDTakeOverStateConstant.SD_TAKE_OVER_STATE_STANDING.equals((Object)SDTakeOverStateConstant.getTakeOverState((Integer)((Integer)otherVSwitch.getValueOf(ParameterCode.VSWITCH_TAKE_OVER_STATE))))) {
                return "You cannot remove " + ClassID.VSWITCH + " " + this.getName() + ", because the cluster it belongs to is in initializing state.";
            }
        }
        return null;
    }

    private String checkIPValidity(String ip, String mask) throws IllegalValueException {
        try {
            if (!NetUtil.isNetworkIpValid((String)ip)) {
                throw new IllegalValueException(ErrorMessage.IP_IS_NOT_VALID.getMessage(ip));
            }
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalValueException(ErrorMessage.IP_IS_NOT_VALID.getMessage(ip));
        }
        if (!NetUtil.isMaskValid((String)mask)) {
            throw new IllegalValueException("the mask is not valid");
        }
        return null;
    }

    public SrFuture<Void> addManagerIfNoManagerIsDefinedYet() {
        if (!this.isManagerDefined()) {
            ConfigElementData element = new ConfigElementData(ClassID.SNMP_MANAGER);
            element.addParameter(new Parameter(ParameterCode.MANAGER_READ_COMMUNITY, (Object)new SrString(this.getReadCommunity())));
            element.addParameter(new Parameter(ParameterCode.MANAGER_WRITE_COMMUNITY, (Object)new SrString(this.getWriteCommunity())));
            element.addParameter(new Parameter(ParameterCode.MANAGER_TRAP_ENABLE, (Object)new SrBoolean(true)));
            element.addParameter(new Parameter(ParameterCode.MANAGER_TRAP_PORT, (Object)new SrInteger(this.getTrapPort())));
            return this.createElement(element, ClassID.SNMP_MANAGER, "for " + this.getName());
        }
        return new CompleteFuture("VSwitchImpl.addManagerIfNOManagerIsDefinedYet");
    }

    public NeighborImpl getNeighbor(VSwitchImpl neighbor) {
        for (NeighborImpl curNei : this.getNeighborTable()) {
            if (!curNei.getIPAddress().equals(neighbor.getMgmIPAddr())) continue;
            return curNei;
        }
        return null;
    }

    public boolean isNeighborOf(VSwitchImpl neighbor) {
        for (NeighborImpl neigh : neighbor.getNeighborTable()) {
            if (!neigh.getName().equals(this.getName())) continue;
            return true;
        }
        if (!neighbor.isConnected()) {
            NeighborImpl n = this.getNeighbor(neighbor);
            return n != null && n.isAlive();
        }
        return false;
    }

    public void setInconsistentNeighborToRemove(VSwitchImpl aVs) {
        this.myInconsistentNeighborToRemove = aVs;
    }

    public boolean isNeighborDead(VSwitchImpl neighbor) {
        if (neighbor.equals(this.myInconsistentNeighborToRemove)) {
            this.setInconsistentNeighborToRemove(null);
            return true;
        }
        NeighborImpl neighborImpl = this.getNeighbor(neighbor);
        if (neighborImpl != null) {
            return neighborImpl.isDead();
        }
        return true;
    }

    @Override
    public SrFuture<Void> createIPTableRow(String ip, String mask, String activity, String interfaceName) throws IllegalValueException {
        String msg = this.checkIPValidity(ip, mask);
        if (msg != null) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{msg});
            throw new IllegalValueException(msg);
        }
        IPTableRowValidator validator = new IPTableRowValidator(this, ip, mask, interfaceName, activity);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        InterfaceTableRowImpl interfaceRow = this.getInterfaceTableRowByName(interfaceName);
        if (interfaceRow == null) {
            throw new IllegalValueException("Interface name " + interfaceName + " not found");
        }
        ConfigElementData element = new ConfigElementData(ClassID.NETWORK_CONFIGURATION);
        element.addParameter((ParameterCodes)ParameterCode.NETWORK_CONFIG_IP_ADDRESS, (Object)new SrIpAddress(ip));
        element.addParameter((ParameterCodes)ParameterCode.NETWORK_CONFIG_NET_MASK, (Object)new SrIpAddress(mask));
        element.addParameter((ParameterCodes)ParameterCode.NETWORK_CONFIG_ACTIVITY, (Object)NetConfigActivityConstant.getNetConfigState((String)activity));
        element.addParameter((ParameterCodes)ParameterCode.NETWORK_CONFIG_INTERFACE, (Object)new SrString(interfaceRow.getName()));
        return this.createElement(element, ClassID.NETWORK_CONFIGURATION, ip + " for " + this.getName());
    }

    private CommKeyClassId getInterfaceTableRow(String interfaceName) {
        InterfaceTableRowImpl row = this.getInterfaceTableRowByName(interfaceName);
        if (row != null) {
            return new CommKeyClassId(row.getCommKeys(), row.getClassId());
        }
        return null;
    }

    public IPTableRow getIPTableRowFromSameSubnet(String ip, String mask) {
        return this.innerGetIPTableRowFromSameSubnet(ip, mask, null);
    }

    public IPTableRow getIPTableRowFromSameSubnet(String ip, String mask, String interfaceName) {
        return this.innerGetIPTableRowFromSameSubnet(ip, mask, interfaceName);
    }

    private IPTableRow innerGetIPTableRowFromSameSubnet(String ip, String mask, String interfaceName) {
        String subnet = null;
        if (mask != null) {
            subnet = NetUtil.getSubnet((String)ip, (String)mask);
        }
        for (IPTableRowImpl row : this.getIPTable()) {
            if (interfaceName != null && !row.getInterface().getName().equals(interfaceName)) continue;
            String rowSubnet = NetUtil.getSubnet((String)row.getIPAddress(), (String)row.getIPMask());
            if (subnet == null) {
                subnet = NetUtil.getSubnet((String)ip, (String)row.getIPMask());
            }
            if (!(mask == null ? ip.indexOf(rowSubnet) > -1 : rowSubnet.equals(subnet))) continue;
            return row;
        }
        return null;
    }

    public IPTableRowImpl getIPTableRow(String ip) {
        for (IPTableRowImpl row : this.getIPTable()) {
            if (!row.getIPAddress().equals(ip)) continue;
            return row;
        }
        return null;
    }

    public Vector<IPTableRowImpl> getIPTableRowsOfInterface(String interfaceName) {
        Vector<IPTableRowImpl> ips = new Vector<IPTableRowImpl>();
        for (IPTableRowImpl row : this.getIPTable()) {
            if (!row.getInterface().getName().equals(interfaceName)) continue;
            ips.addElement(row);
        }
        return ips;
    }

    public ArrayList<PortalTableRowImpl> getPortalTableRows(String ip) {
        ArrayList<PortalTableRowImpl> portals = new ArrayList<PortalTableRowImpl>();
        for (PortalTableRowImpl row : this.getPortalTable()) {
            if (!row.isTargetRole() || !row.getIPAddress().equals(ip)) continue;
            portals.add(row);
        }
        return portals;
    }

    public ArrayList<IPRouteTableRowImpl> getIPRouteTableRows(IPTableRowImpl ip) {
        ArrayList<IPRouteTableRowImpl> ipRoutes = new ArrayList<IPRouteTableRowImpl>();
        for (IPRouteTableRowImpl row : this.getIPRouteTable()) {
            String gatewaySubnet = NetUtil.getSubnet((String)row.getGateway(), (String)ip.getIPMask());
            String ipSubnet = NetUtil.getSubnet((String)ip.getIPAddress(), (String)ip.getIPMask());
            if (!ipSubnet.equals(gatewaySubnet)) continue;
            ipRoutes.add(row);
        }
        return ipRoutes;
    }

    public ArrayList<IPRouteTableRowImpl> getGwIPRouteTableRows(IPTableRowImpl ip) {
        ArrayList<IPRouteTableRowImpl> ipGwRoutes = new ArrayList<IPRouteTableRowImpl>();
        for (IPRouteTableRowImpl row : this.getIPRouteTable()) {
            String ipAddress = ip.getIPAddress();
            String gwIPAddress = row.getGateway();
            InterfaceTableRow gwInterface = row.getInterface();
            if (!gwInterface.equals(ip.getInterface())) continue;
            if (ipAddress.equals(gwIPAddress)) {
                ipGwRoutes.add(row);
            }
            if (!NetUtil.isIPBelongsToSubnet((String)ipAddress, (String)ip.getIPMask(), (String)NetUtil.getSubnet((String)gwIPAddress, (String)row.getDestIPMask()))) continue;
            ipGwRoutes.add(row);
        }
        return ipGwRoutes;
    }

    public IPRouteTableRowImpl getIPRouteTableRow(String subnet, String interfaceName) {
        InterfaceTableRowImpl interfaceRow = this.getInterfaceTableRowByName(interfaceName);
        for (IPRouteTableRowImpl row : this.getIPRouteTable()) {
            String rowSubnet = NetUtil.getSubnet((String)row.getDestIPAdress(), (String)row.getDestIPMask());
            if (!rowSubnet.equals(subnet) || !row.getInterface().equals(interfaceRow)) continue;
            return row;
        }
        return null;
    }

    public IPRouteTableRowImpl getIPRouteTableRow(String destIp, String gateway, String interfaceName) {
        InterfaceTableRowImpl interfaceRow = this.getInterfaceTableRowByName(interfaceName);
        for (IPRouteTableRowImpl row : this.getIPRouteTable()) {
            if (!row.getDestIPAdress().equals(destIp) || !row.getGateway().equals(gateway) || !row.getInterface().equals(interfaceRow)) continue;
            return row;
        }
        return null;
    }

    public PortalTableRowImpl getPortalTableRow(String ip, int port) {
        for (PortalTableRowImpl row : this.getPortalTable()) {
            if (!row.getIPAddress().equals(ip) || !row.getRole().equals((Object)IscsiPortalRolesConstant.TARGET) || row.getPort() != port) continue;
            return row;
        }
        return null;
    }

    public InterfaceTableRowImpl getInterfaceTableRowByName(String interfaceName) {
        for (InterfaceTableRowImpl row : this.getInterfaceTable()) {
            if (row.getName() == null) {
                theLogger.error(SrLogCategories.LEGACY, new Object[]{">>>> InterfaceTableRow name is null: row = ", row.getCommKeyClassId()});
                continue;
            }
            if (!row.getName().equals(interfaceName)) continue;
            return row;
        }
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{ClassID.INTERFACE, " ", interfaceName, " not found"});
        return null;
    }

    public Vector<IPTableRowImpl> getIPsOfInterfaceAndSameSubnet(InterfaceTableRowImpl interfaceRow, IPTableRowImpl ipRow) {
        Vector<IPTableRowImpl> ips = this.getIPsOfInterface(interfaceRow);
        String ipMask = ipRow.getIPMask();
        String ipSubnet = NetUtil.getSubnet((String)ipRow.getIPAddress(), (String)ipMask);
        Iterator<IPTableRowImpl> iter = ips.iterator();
        while (iter.hasNext()) {
            IPTableRowImpl ip = iter.next();
            String mask = ip.getIPMask();
            String subnet = NetUtil.getSubnet((String)ip.getIPAddress(), (String)mask);
            if (ipSubnet.equals(subnet)) continue;
            iter.remove();
        }
        return ips;
    }

    public Vector<IPTableRowImpl> getIPsOfInterface(InterfaceTableRowImpl interfaceRow) {
        Vector<IPTableRowImpl> ips = new Vector<IPTableRowImpl>();
        for (IPTableRowImpl ip : this.getIPTable()) {
            if (!ip.getInterface().getName().equals(interfaceRow.getName())) continue;
            ips.addElement(ip);
        }
        return ips;
    }

    @Override
    public String getWWNN() {
        if (this.myFCNode == null) {
            return null;
        }
        return this.myFCNode.getWWNN();
    }

    @Override
    public String getFunctions() {
        if (this.myFCNode == null) {
            return null;
        }
        return this.myFCNode.getFunctions();
    }

    public SrFuture<Void> setAllIPsActive() {
        final SrFuture retFuture = new SrFuture("VSwitchImpl.setAllIPsActivate");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        for (IPTableRowImpl ipTableRow : this.getIPTable()) {
            if (ipTableRow.getActivity().equals(NetConfigActivityConstant.NET_CONFIG_ACTIVITY_ACTIVE.getDescriptionName())) continue;
            midFutures.add(ipTableRow.setActive());
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    @Override
    public SrFuture<Void> createIPRouteTableRow(String destIp, String destMask, String gateway, String interfaceName) throws RemoteException, IllegalValueException {
        IPRouteTableRowValidator validator = new IPRouteTableRowValidator(this, destIp, destMask, gateway, interfaceName);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ConfigElementData element = new ConfigElementData(ClassID.IP_ROUTE);
        element.addParameter(new Parameter(ParameterCode.IP_ROUTE_DESTINATION_IP, (Object)new SrIpAddress(destIp)));
        element.addParameter(new Parameter(ParameterCode.IP_ROUTE_DESTINATION_IP_MASK, (Object)new SrIpAddress(destMask)));
        element.addParameter(new Parameter(ParameterCode.IP_ROUTE_GATEWAY, (Object)new SrIpAddress(gateway)));
        CommKeyClassId interfaceCommKeyClassId = this.getInterfaceTableRow(interfaceName);
        InterfaceTableRowImpl ifRow = this.getInterfaceTableRowByName(interfaceName);
        element.addParameter(new Parameter(ParameterCode.IP_ROUTE_INTERFACE, (Object)interfaceCommKeyClassId));
        CommKey[] ifKeys = interfaceCommKeyClassId.getCommKeys();
        if (ifKeys.length == 0) {
            throw new IllegalStateException("Interface " + interfaceName + " [ " + interfaceCommKeyClassId + " ] contains no CommKeys");
        }
        String ifIndicesStr = ifKeys[0].toString();
        int tosVal = (Integer.parseInt(ifIndicesStr) << 16) + 1;
        element.addParameter(new Parameter(ParameterCode.IP_ROUTE_TOS, (Object)new SrInteger(tosVal)));
        return this.createElement(element, ClassID.IP_ROUTE, destIp + " for " + this.getName());
    }

    @Override
    public SrFuture<Void> createPortalTableRow(String ip, int port) throws RemoteException, IllegalValueException {
        PortalTableRowValidator validator = new PortalTableRowValidator(this, ip, port);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ConfigElementData element = new ConfigElementData(ClassID.PORTAL);
        element.addParameter(new Parameter(ParameterCode.ISCSI_PORTAL_IP_ADDRESS, (Object)new SrIpAddress(ip)));
        element.addParameter(new Parameter(ParameterCode.ISCSI_PORTAL_PORT, (Object)new SrGauge(port)));
        return this.createElement(element, ClassID.PORTAL, ip + ":" + port + " for " + this.getName());
    }

    private SrFuture<Void> createElement(ConfigElementData element, String details) {
        if (this.isConnected()) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{details});
            CommKeyClassId[] vSwitchCommKeyClassId = new CommKeyClassId[]{new CommKeyClassId(this.getCommKeys(), this.getClassId())};
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, (Object)vSwitchCommKeyClassId));
            return DataMgrAdapter.getInstance().createElement(element);
        }
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{this.getClassId(), " ", this.getName(), " is not connected - ignor element creation (", details, ")"});
        return new CompleteFuture("VSwitchImpl.createElement");
    }

    private SrFuture<Void> createElement(ConfigElementData element, ClassID classId, String details) {
        return this.createElement(element, "Trying to create " + classId + " " + details);
    }

    public void removeTableRow(TableRowImpl row) throws RemoteException {
        if (row instanceof IPTableRowImpl) {
            this.removeIPTableRow((IPTableRowImpl)row);
        } else if (row instanceof InterfaceTableRowImpl) {
            this.removeInterfaceTableRow((InterfaceTableRowImpl)row);
        } else if (row instanceof IPRouteTableRowImpl) {
            this.removeIPRouteTableRow((IPRouteTableRowImpl)row);
        } else if (row instanceof PortalTableRowImpl) {
            this.removePortalTableRow((PortalTableRowImpl)row);
        } else if (row instanceof NeighborImpl) {
            this.removeNeighbor((NeighborImpl)row);
        } else if (row instanceof ManagerImpl) {
            this.removeManager((ManagerImpl)row);
        } else if (row instanceof ISCSIInstanceImpl) {
            this.removeISCSIInstance((ISCSIInstanceImpl)row);
        } else if (row instanceof ISCSISessionImpl) {
            this.removeISCSISession((ISCSISessionImpl)row);
        } else if (row instanceof ISCSIRemoteInitiatorImpl) {
            this.removeISCSIRemoteInitiator((ISCSIRemoteInitiatorImpl)row);
        } else if (row instanceof ISCSIRemoteInitiatorStatisticsImpl) {
            this.removeISCSIRemoteInitiatorStatistics((ISCSIRemoteInitiatorStatisticsImpl)row);
        } else if (row instanceof ISCSISessionStatisticsImpl) {
            this.removeISCSISessionStatistics((ISCSISessionStatisticsImpl)row);
        } else if (row instanceof TCPConnectionStatisticsTableRowImpl) {
            this.removeTCPConnectionStatisticsTableRow((TCPConnectionStatisticsTableRowImpl)row);
        } else if (row instanceof UDPListenerStatisticsTableRowImpl) {
            this.removeUDPListenerStatisticsTableRow((UDPListenerStatisticsTableRowImpl)row);
        } else {
            theLogger.error(SrLogCategories.ERROR, new Object[]{row.getClassId(), " not found in ", this.getClass(), "::removeTableRow()"});
        }
    }

    public ConfigElementData getCEDForAddNeighbor(VSwitch neighbor) {
        try {
            if (this.isDiscoverCompleted() && !this.getName().equals(neighbor.getName())) {
                ConfigElementData element = new ConfigElementData(ClassID.NEIGHBORE, ConfigOperation.CREATE);
                element.addParameter(new Parameter(ParameterCode.NEIGHBOR_IP_ADDRESS, (Object)new SrIpAddress(neighbor.getMgmIPAddr())));
                String nbrName = ((VSwitchImpl)neighbor).isRealNameSet() ? neighbor.getName() : neighbor.getMgmIPAddr();
                element.addParameter(new Parameter(ParameterCode.NEIGHBOR_NAME, (Object)new SrString(nbrName)));
                element.addParameter(new Parameter(ParameterCode.NEIGHBOR_PORT, (Object)new SrInteger(neighbor.getSnmpPort())));
                element.addParameter(new Parameter(ParameterCode.NEIGHBOR_RETRIES, (Object)new SrInteger(neighbor.getNumberOfRetries())));
                element.addParameter(new Parameter(ParameterCode.NEIGHBOR_TIMEOUT, (Object)new SrInteger(new Long(neighbor.getTimeout()).intValue())));
                element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, (Object)this.getCommKeyClassId()));
                return element;
            }
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    private boolean isRowExist(TableRowImpl row) {
        if (this.myIPTable.contains(row)) {
            return true;
        }
        if (this.myInterfaceTable.contains(row)) {
            return true;
        }
        if (this.myIPRouteTable.contains(row)) {
            return true;
        }
        if (this.myPortalTable.contains(row)) {
            return true;
        }
        if (this.myNeighborTable.contains(row)) {
            return true;
        }
        if (this.myManagerTable.contains(row)) {
            return true;
        }
        if (this.myIscsiInstances.contains(row)) {
            return true;
        }
        if (this.myIscsiSessions.contains(row)) {
            return true;
        }
        if (this.mIscsiRemoteInitiators.contains(row)) {
            return true;
        }
        if (this.myIscsiRemoteInitiatorsStatistics.contains(row)) {
            return true;
        }
        if (this.mIscsiSessionsStatistics.contains(row)) {
            return true;
        }
        if (this.myTcpConnectionStatisticsTable.contains(row)) {
            return true;
        }
        return this.myUdpListenerStatisticsTable.contains(row);
    }

    public void addTableRow(TableRowImpl row) {
        if (!this.isRowExist(row)) {
            if (row instanceof HardwareImpl) {
                this.setHardware((HardwareImpl)row);
            } else if (row instanceof TCPStatisticsImpl) {
                this.setTCPStatistics((TCPStatisticsImpl)row);
            } else if (row instanceof UDPStatisticsImpl) {
                this.setUDPStatistics((UDPStatisticsImpl)row);
            } else if (row instanceof ICMPStatisticsImpl) {
                this.setICMPStatistics((ICMPStatisticsImpl)row);
            } else if (row instanceof IPStatisticsImpl) {
                this.setIPStatistics((IPStatisticsImpl)row);
            } else if (row instanceof EthernetStatisticsImpl) {
                this.setEthernetStatistics((EthernetStatisticsImpl)row);
            } else if (row instanceof IPTableRowImpl) {
                this.addIPTableRow((IPTableRowImpl)row);
            } else if (row instanceof InterfaceTableRowImpl) {
                this.addInterfaceTableRow((InterfaceTableRowImpl)row);
            } else if (row instanceof InterfaceStatisticsTableRowImpl) {
                this.addInterfaceStatisticsTableRow((InterfaceStatisticsTableRowImpl)row);
            } else if (row instanceof IPRouteTableRowImpl) {
                this.addIPRouteTableRow((IPRouteTableRowImpl)row);
            } else if (row instanceof PortalTableRowImpl) {
                this.addPortalTableRow((PortalTableRowImpl)row);
            } else if (row instanceof NeighborImpl) {
                this.addNeighbor((NeighborImpl)row);
            } else if (row instanceof ManagerImpl) {
                this.addManager((ManagerImpl)row);
            } else if (row instanceof ISCSIInstanceImpl) {
                this.addISCSIInstance((ISCSIInstanceImpl)row);
            } else if (row instanceof ISCSISessionImpl) {
                this.addISCSISession((ISCSISessionImpl)row);
            } else if (row instanceof ISCSISessionStatisticsImpl) {
                this.addISCSISessionStatistics((ISCSISessionStatisticsImpl)row);
            } else if (row instanceof ISCSIRemoteInitiatorImpl) {
                this.addISCSIRemoteInitiator((ISCSIRemoteInitiatorImpl)row);
            } else if (row instanceof ISCSIRemoteInitiatorStatisticsImpl) {
                this.addISCSIRemoteInitiatorStatistics((ISCSIRemoteInitiatorStatisticsImpl)row);
            } else if (row instanceof TCPConnectionStatisticsTableRowImpl) {
                this.addTCPConnectionStatisticsTableRow((TCPConnectionStatisticsTableRowImpl)row);
            } else if (row instanceof UDPListenerStatisticsTableRowImpl) {
                this.addUDPListenerStatisticsTableRow((UDPListenerStatisticsTableRowImpl)row);
            } else {
                theLogger.trace(SrLogCategories.LEGACY, new Object[]{row.getClassId(), " not found in ", this.getClass(), "::addTableRow()"});
            }
        } else {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Table row ", row.getClassId(), " ", row, " already exists in ", ClassID.VSWITCH, " ", this.getMgmIPAddr()});
        }
    }

    private void addNeighbor(NeighborImpl neighbor) {
        this.myNeighborTable.addElement(neighbor);
    }

    private void removeNeighbor(NeighborImpl neighbor) {
        this.myNeighborTable.removeElement(neighbor);
    }

    private void addManager(ManagerImpl manager) {
        this.myManagerTable.addElement(manager);
    }

    private void removeManager(ManagerImpl manager) {
        this.myManagerTable.removeElement(manager);
    }

    private void addIPTableRow(IPTableRowImpl row) {
        this.myIPTable.addElement(row);
    }

    private void removeIPTableRow(IPTableRowImpl row) {
        this.myIPTable.removeElement(row);
    }

    private void addInterfaceTableRow(InterfaceTableRowImpl row) {
        this.myInterfaceTable.addElement(row);
    }

    private void addInterfaceStatisticsTableRow(InterfaceStatisticsTableRowImpl row) {
        this.getInterfacesStatisticsTable().addElement(row);
    }

    public void setFCNode(FCNodeImpl fcNode) {
        this.myFCNode = fcNode;
    }

    private void removeInterfaceTableRow(InterfaceTableRowImpl row) {
        Iterator<InterfaceStatisticsTableRowImpl> i = this.getInterfacesStatisticsTable().iterator();
        while (i.hasNext()) {
            InterfaceStatisticsTableRowImpl currIface = i.next();
            if (!currIface.getParentInterface().equals(row)) continue;
            i.remove();
        }
        this.myInterfaceTable.removeElement(row);
    }

    public Vector<InterfaceStatisticsTableRowImpl> getInterfacesStatisticsTable() {
        return this.myInterfaceStatisticsTable;
    }

    public Vector<UDPListenerStatisticsTableRowImpl> getUDPListenerStatisticsTable() {
        return this.myUdpListenerStatisticsTable;
    }

    public Vector<TCPConnectionStatisticsTableRowImpl> getTCPConnectionStatisticsTable() {
        return this.myTcpConnectionStatisticsTable;
    }

    @Override
    public InterfacesGroupStatisticsImpl getInterfacesGroupStatistics() {
        return (InterfacesGroupStatisticsImpl)this.myClassIdToStatisticsMap.get(ClassID.STATISTIC_INTERFACES_GROUP);
    }

    @Override
    public IPStatisticsImpl getIPStatistics() {
        return (IPStatisticsImpl)this.myClassIdToStatisticsMap.get(ClassID.STATISTIC_IP);
    }

    public EthernetStatistics getEthernetStatistics() {
        return (EthernetStatistics)((Object)this.myClassIdToStatisticsMap.get(ClassID.STATISTIC_ETHERNET));
    }

    @Override
    public ICMPStatistics getICMPStatistics() {
        return (ICMPStatistics)((Object)this.myClassIdToStatisticsMap.get(ClassID.STATISTIC_ICMP));
    }

    @Override
    public TCPStatistics getTCPStatistics() {
        return (TCPStatistics)((Object)this.myClassIdToStatisticsMap.get(ClassID.STATISTIC_TCP));
    }

    @Override
    public UDPStatistics getUDPStatistics() {
        return (UDPStatistics)((Object)this.myClassIdToStatisticsMap.get(ClassID.STATISTIC_UDP));
    }

    @Override
    public ISCSIRemoteInitiatorsGroupStatistics getISCSIRemoteInitiatorsGroupStatistics() {
        return (ISCSIRemoteInitiatorsGroupStatistics)((Object)this.myClassIdToStatisticsMap.get(ClassID.REMOTE_INITIATORS_STATISTICS_GROUP));
    }

    @Override
    public ISCSISessionsGroupStatistics getISCSISessionsGroupStatistics() {
        return (ISCSISessionsGroupStatistics)((Object)this.myClassIdToStatisticsMap.get(ClassID.SESSIONS_STATISTICS_GROUP));
    }

    private void removeInterfaceStatisticsTableRow(InterfaceStatisticsTableRowImpl row) {
        this.myInterfaceStatisticsTable.removeElement(row);
    }

    private void addUDPListenerStatisticsTableRow(UDPListenerStatisticsTableRowImpl row) {
        this.myUdpListenerStatisticsTable.addElement(row);
    }

    private void removeUDPListenerStatisticsTableRow(UDPListenerStatisticsTableRowImpl row) {
        this.myUdpListenerStatisticsTable.removeElement(row);
    }

    private void addTCPConnectionStatisticsTableRow(TCPConnectionStatisticsTableRowImpl row) {
        this.myTcpConnectionStatisticsTable.addElement(row);
    }

    private void removeTCPConnectionStatisticsTableRow(TCPConnectionStatisticsTableRowImpl row) {
        this.myTcpConnectionStatisticsTable.removeElement(row);
    }

    private void addPortalTableRow(PortalTableRowImpl row) {
        this.myPortalTable.addElement(row);
    }

    private void removePortalTableRow(PortalTableRowImpl row) {
        this.myPortalTable.removeElement(row);
    }

    private void addIPRouteTableRow(IPRouteTableRowImpl row) {
        this.myIPRouteTable.addElement(row);
    }

    private void removeIPRouteTableRow(IPRouteTableRowImpl row) {
        this.myIPRouteTable.removeElement(row);
    }

    public Vector<NeighborImpl> getNeighborTable() {
        return this.myNeighborTable;
    }

    public Vector<ManagerImpl> getManagerTable() {
        return this.myManagerTable;
    }

    public Vector<IPTableRowImpl> getIPTable() {
        return this.myIPTable;
    }

    public Vector<InterfaceTableRowImpl> getInterfaceTable() {
        return this.myInterfaceTable;
    }

    public Vector<PortalTableRowImpl> getPortalTable() {
        return this.myPortalTable;
    }

    public Vector<IPRouteTableRowImpl> getIPRouteTable() {
        return this.myIPRouteTable;
    }

    @Override
    public boolean isConnected() {
        return this.myIsConnected;
    }

    public void setConnected(boolean connected) throws RemoteException {
        if (this.myIsConnected != connected) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{this.getClassId(), " ", this.getMgmIPAddr(), " connection status is ", connected});
            this.myIsConnected = connected;
            if (this.getCluster() != null) {
                AlarmMgrImpl.getInstance().generateAlarms(this.getCluster(), 2, (GeneralLogicObjectImpl)this, this);
            }
            if (this.cluster.isDiscoverCompleted()) {
                if (connected || SDTakeOverStateConstant.SD_TAKE_OVER_STATE_UNDER_TAKE_OVER.equals((Object)this.cluster.getTakeoverState())) {
                    SrFuture<Void> rediscoverFuture = this.cluster.rediscover();
                    Runnable updateRaidCtrlRun = new Runnable(){

                        @Override
                        public void run() {
                            VSwitchImpl.this.updateRaidControl();
                        }
                    };
                    DefaultFutureListener.listenTo((Runnable)updateRaidCtrlRun, (IFuture[])new IFuture[]{rediscoverFuture});
                }
            } else {
                this.fireConnectivityChanged(this.isConnected());
            }
            ElementEventImpl event = new ElementEventImpl((Object)this, this);
            HashMap<ClientParameterCode, Boolean> parameterList = new HashMap<ClientParameterCode, Boolean>();
            parameterList.put(ClientParameterCode.VSWITCH_CONNECTED, new Boolean(connected));
            event.setParameterList(parameterList);
            LogicMgrAOImpl.getInstance().__elementChanged(event);
        }
    }

    private void setMgmIPAddr(String ip) {
        if (ip == null) {
            throw new IllegalArgumentException("Initializing " + ClassID.VSWITCH + "'s mgmt IP with null value, m_ipAddr: " + this.myIPAddr + ".");
        }
        theLogger.info(SrLogCategories.LEGACY, new Object[]{ClassID.VSWITCH, " ", ip, " changed, old IP: ", this.myIPAddr, "; new IP: ", ip});
        this.myIPAddr = ip;
    }

    @Override
    public String getMgmIPAddr() {
        return this.myIPAddr;
    }

    @Override
    public String getMgmMask() {
        return this.getDisplayStringOf(this, ParameterCode.VSWITCH_IP_MASK);
    }

    @Override
    public int getSnmpPort() {
        return ((SrInteger)this.getSrValueOf(this, ParameterCode.VSWITCH_SNMP_UDP_PORT)).intValue();
    }

    @Override
    public Integer getTrapPort() {
        SrInteger trapPort = (SrInteger)this.getSrValueOf(this, ParameterCode.VSWITCH_TRAP_UDP_PORT);
        if (trapPort == null) {
            return null;
        }
        return new Integer(trapPort.intValue());
    }

    @Override
    public String getReadCommunity() {
        String readCommunity = (String)this.getValueOf(this, ParameterCode.VSWITCH_READ_COMMUNITY);
        if (readCommunity == null || readCommunity.equals("")) {
            String debugMsg = "Read Community of " + this + " is empty (" + readCommunity + ") !!!! (class: " + this.getClass() + ")";
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{debugMsg});
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{debugMsg});
            Thread.dumpStack();
        }
        return readCommunity;
    }

    @Override
    public String getWriteCommunity() {
        String writeCommunity = (String)this.getValueOf(this, ParameterCode.VSWITCH_WRITE_COMMUNITY);
        if (writeCommunity == null || writeCommunity.equals("")) {
            String debugMsg = "Write Community of " + this + " is empty (" + writeCommunity + ") !!!! (class: " + this.getClass() + ")";
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{debugMsg});
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{debugMsg});
            Thread.dumpStack();
        }
        return writeCommunity;
    }

    @Override
    public long getTimeout() {
        return ((SrLong)this.getSrValueOf(this, ParameterCode.VSWITCH_TIMEOUT)).longValue();
    }

    @Override
    public int getNumberOfRetries() {
        return ((SrInteger)this.getSrValueOf(this, ParameterCode.VSWITCH_MAX_RETRIES)).intValue();
    }

    @Override
    public SnmpVersion getSnmpVersion() {
        return (SnmpVersion)this.getSrValueOf(this, ParameterCode.VSWITCH_SNMP_VERSION);
    }

    @Override
    public String getDescription() {
        return (String)this.getValueOf(this, ParameterCode.VSWITCH_DESCRIPTION);
    }

    @Override
    public String getContact() {
        return (String)this.getValueOf(this, ParameterCode.VSWITCH_CONTACT);
    }

    @Override
    public String getLocation() {
        return (String)this.getValueOf(this, ParameterCode.VSWITCH_LOCATION);
    }

    @Override
    public Long getLastReset() {
        return (Long)this.getValueOf(this, ParameterCode.VSWITCH_LAST_RESET);
    }

    @Override
    public Long getLastKeepAlive() {
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.VSWITCH_LAST_KEEPALIVE));
        ErrorAssertingListener.listenTo(this.refreshFields(element));
        Object value = this.getValueOf(this, ParameterCode.VSWITCH_LAST_KEEPALIVE);
        if (value instanceof BigInteger) {
            return new Long(((BigInteger)value).longValue());
        }
        return (Long)value;
    }

    @Override
    public Long getPreviousDateAndTime() {
        return (Long)this.getValueOf(this, ParameterCode.VSWITCH_DATE_AND_TIME);
    }

    @Override
    public BigInteger getTelnetPort() {
        Object obj = this.getValueOf(this, ParameterCode.VSWITCH_TELNET_PORT);
        if (obj != null) {
            return (BigInteger)this.getValueOf(this, ParameterCode.VSWITCH_TELNET_PORT);
        }
        return null;
    }

    @Override
    public Long getDateAndTime() {
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.VSWITCH_DATE_AND_TIME));
        ErrorAssertingListener.listenTo(this.refreshFields(element));
        return (Long)this.getValueOf(this, ParameterCode.VSWITCH_DATE_AND_TIME);
    }

    public IscsiTgtQosActivityConstant getQosState() {
        return (IscsiTgtQosActivityConstant)this.getSrValueOf(ParameterCode.VSWITCH_TGT_QOS_ACTIVITY);
    }

    public VSwitchStatusConstant getVSwitchStatus() {
        return (VSwitchStatusConstant)this.getSrValueOf(ParameterCode.VSWITCH_STATUS);
    }

    @Override
    public VSwitchSysOID getVSwitchType() {
        return (VSwitchSysOID)this.getSrValueOf(this, ParameterCode.VSWITCH_SYS_OID);
    }

    private boolean is2000() {
        return VSwitchSysOID.VSWITCH_SYS_OID_2000.equals((Object)this.getVSwitchType());
    }

    private boolean is3000() {
        return VSwitchSysOID.VSWITCH_SYS_OID_3000.equals((Object)this.getVSwitchType());
    }

    public boolean isSupportSFP() {
        return !this.is2000() && !this.is3000();
    }

    @Override
    public SrFuture<Void> reset() throws RemoteException {
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.VSWITCH_RESET, (Object)ResetConstant.RESET_HW));
        theLogger.info(SrLogCategories.LEGACY, new Object[]{"Start reset ", ClassID.VSWITCH, " ", this.toString()});
        ElementEventImpl elementEvent = new ElementEventImpl((Object)this, this);
        elementEvent.setVSwitchIp(this.getMgmIPAddr());
        LogicMgrAOImpl.getInstance().__startReset(elementEvent);
        return DataMgrAdapter.getInstance().changeElement(element);
    }

    @Override
    public SrFuture<Void> shutdown() {
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.VSWITCH_RESET, (Object)ResetConstant.SHUTDOWN));
        theLogger.info(SrLogCategories.LEGACY, new Object[]{"Shutdown VSwitch ", this.toString()});
        return DataMgrAdapter.getInstance().changeElement(element);
    }

    @Override
    public SrFuture<Void> wakeOnLAN() throws IllegalValueException {
        int i;
        String mgmtName = Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.MGMT_INTERFACE_PORT_NAME);
        InterfaceTableRowImpl mgntInterface = this.getInterfaceTableRowByName(mgmtName);
        if (mgntInterface == null) {
            throw new IllegalValueException("Mgnt interface not found");
        }
        String ipStr = this.getMgmIPAddr();
        IPTableRowImpl mgntIp = this.getIPTableRow(ipStr);
        InterfaceTableRowImpl mgntIpInterface = mgntIp.getInterface();
        if (!mgntInterface.equals(mgntIpInterface)) {
            throw new IllegalValueException("Mgnt IP is not configured on Mgnt interface");
        }
        String macStr = mgntInterface.getPhysicalAddress();
        byte[] macBytes = null;
        try {
            macBytes = NetUtil.getMacBytes((String)macStr);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalValueException(iae.getMessage(), iae);
        }
        byte[] bytes = new byte[6 + 16 * macBytes.length];
        for (i = 0; i < 6; ++i) {
            bytes[i] = -1;
        }
        for (i = 6; i < bytes.length; i += macBytes.length) {
            System.arraycopy(macBytes, 0, bytes, i, macBytes.length);
        }
        try {
            InetAddress address = InetAddress.getByName(ipStr);
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length, address, 9);
            DatagramSocket socket = new DatagramSocket();
            socket.send(packet);
            socket.close();
        }
        catch (IOException ioe) {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{ioe});
            throw new IllegalValueException(ioe.getMessage(), ioe);
        }
        theLogger.info(SrLogCategories.LEGACY, new Object[]{"Wake-on-LAN packet sent to ip ", ipStr});
        return new CompleteFuture("VSwitchImpl.wakeOnLAN");
    }

    @Override
    public SrFuture<Void> manualDiscover() throws RemoteException {
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.PHYSICAL_STORAGE_MANUAL_DISCOVERY, (Object)StorageDiscoveryOperationConstant.MANUAL_DISCOVERY_STATUS_ON));
        theLogger.info(SrLogCategories.LEGACY, new Object[]{"Start manual discovery on ", this.getClassId(), " ", this.toString()});
        ElementEventImpl elementEvent = new ElementEventImpl((Object)this, this);
        elementEvent.setVSwitchIp(this.getMgmIPAddr());
        LogicMgrAOImpl.getInstance().__startManualDiscovering(elementEvent);
        return DataMgrAdapter.getInstance().changeElement(element);
    }

    protected void removePropagationStateDependentObject() {
    }

    @Override
    public SrFuture<Void> rediscover() {
        if (!this.myDiscoveryFuture.isDone()) {
            return this.myDiscoveryFuture;
        }
        if (this.myDiscoveryFuture.isDone()) {
            this.setStateSeverity(AlarmSeverity.OK);
            this.myDiscoveryFuture = DataMgrAdapter.getInstance().discover(this.getCommKeyClassId());
            theLogger.trace(SrLogCategories.INFORMATIVE, new Object[]{"Starting discover for ", this.getClassId(), " ", this.getMgmIPAddr()});
        }
        return this.myDiscoveryFuture;
    }

    private boolean isRealNameSet() {
        return this.getValueOf(this, ParameterCode.VSWITCH_NAME) != null;
    }

    public SrFuture<Void> readIPsState() {
        final SrFuture retFuture = new SrFuture("VSwitchImpl.readIPsState");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        for (IPTableRowImpl ipRow : this.getIPTable()) {
            midFutures.add(ipRow.readState());
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    @Override
    public String getName() {
        String name = (String)this.getValueOf(this, ParameterCode.VSWITCH_NAME);
        if (name == null) {
            return this.getMgmIPAddr();
        }
        return name;
    }

    @Override
    public void clear() throws RemoteException {
        this.myIPTable.clear();
        this.myInterfaceTable.clear();
        this.myIPRouteTable.clear();
        this.myPortalTable.clear();
        this.myNeighborTable.clear();
        this.myManagerTable.clear();
        this.myHardwareObj = null;
        this.myInterfaceStatisticsTable.clear();
        this.myUdpListenerStatisticsTable.clear();
        this.myTcpConnectionStatisticsTable.clear();
        this.myIscsiInstances.clear();
        this.myIscsiSessions.clear();
        this.mIscsiRemoteInitiators.clear();
        this.myIscsiRemoteInitiatorsStatistics.clear();
        this.mIscsiSessionsStatistics.clear();
        this.myIscsiInitiators.clear();
        if (this.myClassIdToStatisticsMap.get(ClassID.SESSIONS_STATISTICS_GROUP) != null) {
            this.myClassIdToStatisticsMap.get(ClassID.SESSIONS_STATISTICS_GROUP).clear();
        }
        if (this.myClassIdToStatisticsMap.get(ClassID.STATISTIC_INTERFACES_GROUP) != null) {
            this.myClassIdToStatisticsMap.get(ClassID.STATISTIC_INTERFACES_GROUP).clear();
        }
        if (this.myClassIdToStatisticsMap.get(ClassID.STATISTIC_ICMP) != null) {
            this.myClassIdToStatisticsMap.get(ClassID.STATISTIC_ICMP).clear();
        }
        if (this.myClassIdToStatisticsMap.get(ClassID.STATISTIC_UDP) != null) {
            this.myClassIdToStatisticsMap.get(ClassID.STATISTIC_UDP).clear();
        }
        if (this.myClassIdToStatisticsMap.get(ClassID.REMOTE_INITIATORS_STATISTICS_GROUP) != null) {
            this.myClassIdToStatisticsMap.get(ClassID.REMOTE_INITIATORS_STATISTICS_GROUP).clear();
        }
        this.addParameterCode(ParameterCode.VSWITCH_CONTACT);
        this.addParameterCode(ParameterCode.VSWITCH_DATE_AND_TIME);
        this.addParameterCode(ParameterCode.VSWITCH_DESCRIPTION);
        this.addParameterCode(ParameterCode.VSWITCH_LAST_RESET);
        this.addParameterCode(ParameterCode.VSWITCH_LOCATION);
        this.addParameterCode(ParameterCode.VSWITCH_NAME);
        this.addParameterCode(ParameterCode.VSWITCH_CONNECTIVITY_STATUS);
        this.addParameterCode(ParameterCode.VSWITCH_TELNET_PORT);
        this.addParameterCode(ParameterCode.VSWITCH_LAST_KEEPALIVE);
        this.addParameterCode(ParameterCode.VSWITCH_KEEPALIVE_INTERVAL);
        this.addParameterCode(ParameterCode.VSWITCH_SUSPICIOUS_INTERVAL);
        this.addParameterCode(ParameterCode.VSWITCH_FAULTY_INTERVAL);
        this.addParameterCode(ParameterCode.VSWITCH_TAKE_OVER_STATE);
        this.addParameterCode(ParameterCode.VSWITCH_FAILOVER_ENABLE);
        this.addParameterCode(ParameterCode.VSWITCH_SWITCH_ID);
        this.addParameterCode(ParameterCode.VSWITCH_REPORT_LUN_DISCOVERY);
        this.addParameterCode(ParameterCode.VSWITCH_STATUS);
        this.addParameterCode(ParameterCode.VSWITCH_TGT_QOS_ACTIVITY);
        this.addParameterCode(ParameterCode.VSWITCH_TGT_QOS_MAX_RATE_LIMIT);
        this.addParameterCode(ParameterCode.VSWITCH_TGT_QOS_RATE_TYPE);
    }

    public boolean isDiscoverCompleted() {
        return this.myIsDiscoverCompleted;
    }

    public void setDiscoverCompleted(boolean aIsComplete) {
        this.myIsDiscoverCompleted = aIsComplete;
    }

    public Integer getKeepAliveInterval() {
        return (Integer)this.getValueOf(this, ParameterCode.VSWITCH_KEEPALIVE_INTERVAL);
    }

    public Integer getSuspiciousInterval() {
        return (Integer)this.getValueOf(this, ParameterCode.VSWITCH_SUSPICIOUS_INTERVAL);
    }

    public Integer getFaultyInterval() {
        return (Integer)this.getValueOf(this, ParameterCode.VSWITCH_FAULTY_INTERVAL);
    }

    public SrFuture<Void> removeNeighbor(String neighborIp) throws RemoteException {
        final SrFuture retFuture = new SrFuture("Site.disasterOccured_DRActivate[]");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        for (NeighborImpl neighbor : this.myNeighborTable) {
            if (!neighbor.getIPAddress().equals(neighborIp)) continue;
            try {
                midFutures.add(neighbor.deleteElement());
            }
            catch (IllegalValueException ive) {
                theLogger.warn(SrLogCategories.LEGACY, new Object[]{ive});
            }
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof VSwitch) {
            if (super.equals(obj)) {
                return true;
            }
            if (this.myIPAddr == null || ((VSwitchImpl)obj).myIPAddr == null) {
                return false;
            }
            return this.myIPAddr.equals(((VSwitchImpl)obj).myIPAddr);
        }
        return false;
    }

    @Override
    public void registerToPropagatedStateChange() {
        this.cluster.addPropagationStateDependentObjectAndListener(this);
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return VSwitchAlarmGenerator.getInstance();
    }

    @Override
    public boolean isUnderTakeover() {
        SDTakeOverStateConstant takeOver = this.getTakeOverState();
        return takeOver == null ? true : takeOver.equals((Object)SDTakeOverStateConstant.SD_TAKE_OVER_STATE_UNDER_TAKE_OVER);
    }

    @Override
    public SDTakeOverStateConstant getTakeOverState() {
        SDTakeOverStateConstant takeover = (SDTakeOverStateConstant)this.getSrValueOf(this, ParameterCode.VSWITCH_TAKE_OVER_STATE);
        return takeover;
    }

    public void setNeighborInvalid(String neighborIp) {
        this.myIsNeighborValid = neighborIp;
    }

    public boolean isNeighborValid() {
        return this.myIsNeighborValid == null;
    }

    public String getInvalidNeighborIp() {
        return this.myIsNeighborValid;
    }

    public Boolean isFailoverEnable() {
        SrInteger value = (SrInteger)this.getSrValueOf(this, ParameterCode.VSWITCH_FAILOVER_ENABLE);
        if (value != null) {
            return value.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    @Override
    public Integer getSwitchID() {
        return (Integer)this.getValueOf(this, ParameterCode.VSWITCH_SWITCH_ID);
    }

    @Override
    public Boolean isReportLUNsDiscoveryEnable() {
        return (Boolean)this.getValueOf(this, ParameterCode.VSWITCH_REPORT_LUN_DISCOVERY);
    }

    public SrFuture<Void> deleteFromDatabase() throws RemoteException, IllegalValueException {
        this.enableDeleteFromDatabaseOnly();
        return this.deleteElement();
    }

    public SrFuture<Void> moveToCluster(Integer clusterVSwitchGroupId) throws RemoteException, IllegalValueException {
        ClusterImpl dstCluster = (ClusterImpl)SystemRootImpl.getInstance().getVSwitchGroup(clusterVSwitchGroupId);
        this.setWatingMovingCluster(dstCluster);
        return this.deleteFromDatabase();
    }

    private Vector<ManagerImpl> getThisMachineManagers() {
        Vector<ManagerImpl> managers = new Vector<ManagerImpl>();
        Integer trapPort = this.getTrapPort();
        String[] ips = Server.getHostAddressListAsStringArray();
        for (ManagerImpl manager : this.getManagerTable()) {
            if (!manager.isEqualTo(ips, trapPort)) continue;
            managers.addElement(manager);
        }
        return managers;
    }

    public boolean isPendingMovingToCluster() {
        return this.myWatingMovingCluster != null;
    }

    public Cluster getWatingMovingCluster() {
        return this.myWatingMovingCluster;
    }

    public void setWatingMovingCluster(Cluster moveToCluster) {
        this.myWatingMovingCluster = moveToCluster;
    }

    private boolean isManagerDefined() {
        if (this.getManagerTable().isEmpty()) {
            return false;
        }
        String managerIP = null;
        try {
            managerIP = DataMgrAdapter.getInstance().getSnmpManagerIp(this.getCommKeyClassId());
        }
        catch (SrCommException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)exp, new Object[]{"Could not get the snmp manager from VS ", this});
        }
        if (managerIP != null) {
            for (ManagerImpl manager : this.getManagerTable()) {
                if (!manager.getIPAddress().equals(managerIP) || manager.getTrapPort().compareTo(this.getTrapPort()) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public List<InterfaceTableRowImpl> getLinkDownInterfaces() {
        ArrayList<InterfaceTableRowImpl> interfaces = new ArrayList<InterfaceTableRowImpl>();
        for (InterfaceTableRowImpl inter : this.getInterfaceTable()) {
            if (!inter.isLinkDown()) continue;
            interfaces.add(inter);
        }
        return interfaces;
    }

    public List<SFPConnectedInterfaceImpl> getTooHighSpeedSFPInterfaces() {
        return this.getExceedingSpeedSFPInterfaces(true);
    }

    public List<SFPConnectedInterfaceImpl> getTooLowSpeedSFPInterfaces() {
        return this.getExceedingSpeedSFPInterfaces(false);
    }

    private List<SFPConnectedInterfaceImpl> getExceedingSpeedSFPInterfaces(boolean aExceeding) {
        ArrayList<SFPConnectedInterfaceImpl> interfaces = new ArrayList<SFPConnectedInterfaceImpl>();
        for (InterfaceTableRowImpl inter : this.getInterfaceTable()) {
            if (!(inter instanceof SFPConnectedInterfaceImpl) || inter.isManagementInterface()) continue;
            SFPConnectedInterfaceImpl sfpConnectedInterface = (SFPConnectedInterfaceImpl)inter;
            BigInteger ifSpeed = sfpConnectedInterface.getHighSpeedMbits();
            Integer sfpSpeed = sfpConnectedInterface.getConnectedSFPSpeedMbits();
            if (ifSpeed == null || sfpSpeed == null || sfpConnectedInterface.isConnctorTypeUnknown()) continue;
            if (aExceeding) {
                double newSpfSpeed = 0.9 * (double)sfpSpeed.intValue();
                if (!(ifSpeed.doubleValue() < newSpfSpeed)) continue;
                interfaces.add(sfpConnectedInterface);
                continue;
            }
            if (!(ifSpeed.doubleValue() > (double)sfpSpeed.intValue())) continue;
            interfaces.add(sfpConnectedInterface);
        }
        return interfaces;
    }

    public Vector<InterfaceTableRowImpl> getUnknownInterfacesInterfaces() {
        Vector<InterfaceTableRowImpl> interfaces = new Vector<InterfaceTableRowImpl>();
        for (InterfaceTableRowImpl inter : this.getInterfaceTable()) {
            if (!inter.isUnknown()) continue;
            interfaces.addElement(inter);
        }
        return interfaces;
    }

    @Override
    public SrInteger getIntervalValue(ParameterCode pollIntervalParam, VSwitchImpl vSwitch) {
        SrInteger interval;
        Parameter pollInterval = this.getParameter(this, pollIntervalParam);
        if (pollInterval != null && (interval = (SrInteger)pollInterval.getValue()) != null && !interval.equals(0)) {
            return interval;
        }
        return this.cluster.getIntervalValue(pollIntervalParam, this);
    }

    public Vector<ISCSIRemoteInitiatorImpl> getRemoteInitiators() throws RemoteException {
        Vector<ISCSIRemoteInitiatorImpl> initiators = new Vector<ISCSIRemoteInitiatorImpl>();
        ArrayList<ISCSITargetImpl> targets = new ArrayList<ISCSITargetImpl>(this.getCluster().getStorage().getTargetList());
        for (ISCSITargetImpl target : targets) {
            ISCSIRemoteInitiator[] targetInitiators;
            boolean isTargetConnectedToOneVSwitchInCluster;
            boolean bl = isTargetConnectedToOneVSwitchInCluster = target.getConnectedVSwitches().length == 1;
            if (!target.getExposedOnVSwitch().equals(this.getName()) && !isTargetConnectedToOneVSwitchInCluster || (targetInitiators = target.getISCSIRemoteInitiators()).length <= 0) continue;
            for (int index = 0; index < targetInitiators.length; ++index) {
                initiators.add((ISCSIRemoteInitiatorImpl)targetInitiators[index]);
            }
        }
        return initiators;
    }

    public ISCSIRemoteInitiatorImpl getRemoteInitiatorByName(String aRemoteInitiatorName) {
        try {
            Vector<ISCSIRemoteInitiatorImpl> knownRemoteInitiators = this.getRemoteInitiators();
            for (ISCSIRemoteInitiatorImpl remoteInitiator : knownRemoteInitiators) {
                if (remoteInitiator.getInitiatorName() == null) {
                    theLogger.warn(SrLogCategories.LEGACY, new Object[]{"ISCSIRemoteInitiator without a name value. remoteInitiator: ", remoteInitiator});
                    theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Calling 'continue' instead of returning 'null', this is the correct implementation but might cause a problem, since used to return null here."});
                    continue;
                }
                if (!remoteInitiator.getInitiatorName().equals(aRemoteInitiatorName)) continue;
                return remoteInitiator;
            }
            theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Couldn't find a remote initiator by the name: ", aRemoteInitiatorName, "; remote initiators: ", knownRemoteInitiators});
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)re, new Object[]{"A remote exception has been thrown inside a server context."});
        }
        return null;
    }

    private void addISCSIInstance(ISCSIInstanceImpl iscsiInstance) {
        this.myIscsiInstances.addElement(iscsiInstance);
    }

    private void removeISCSIInstance(ISCSIInstanceImpl iscsiInstance) {
        this.myIscsiInstances.removeElement(iscsiInstance);
    }

    private void addISCSISession(ISCSISessionImpl iscsiSession) {
        this.myIscsiSessions.addElement(iscsiSession);
    }

    private void removeISCSISession(ISCSISessionImpl iscsiSession) {
        this.myIscsiSessions.removeElement(iscsiSession);
    }

    public void addISCSIInitiator(ISCSIInitiatorImpl iscsiInitiator) {
        this.myIscsiInitiators.add(iscsiInitiator);
    }

    public void removeISCSIInitiator(ISCSIInitiatorImpl iscsiInitiator) {
        this.myIscsiInitiators.remove(iscsiInitiator);
    }

    private void addISCSIRemoteInitiator(ISCSIRemoteInitiatorImpl iscsiRemoteInitiator) {
        this.mIscsiRemoteInitiators.addElement(iscsiRemoteInitiator);
    }

    private void removeISCSIRemoteInitiator(ISCSIRemoteInitiatorImpl iscsiRemoteInitiator) {
        this.mIscsiRemoteInitiators.removeElement(iscsiRemoteInitiator);
    }

    public Vector<ISCSIInstanceImpl> getISCSIInstancesTable() {
        return this.myIscsiInstances;
    }

    public Vector<ISCSISessionImpl> getISCSISessionsTable() {
        return this.myIscsiSessions;
    }

    public Vector<ISCSIRemoteInitiatorImpl> getISCSIRemoteInitiatorsTable() {
        return this.mIscsiRemoteInitiators;
    }

    public Vector<ISCSIRemoteInitiatorStatisticsImpl> getISCSIRemoteInitiatorsStatisticsTable() {
        return this.myIscsiRemoteInitiatorsStatistics;
    }

    @Override
    public ISCSIInitiator[] getISCSIInitiators() {
        ISCSIInitiator[] initiators = new ISCSIInitiator[this.myIscsiInitiators.size()];
        return this.myIscsiInitiators.toArray(initiators);
    }

    private void addISCSIRemoteInitiatorStatistics(ISCSIRemoteInitiatorStatisticsImpl iscsiRemoteInitiatorStatistics) {
        this.myIscsiRemoteInitiatorsStatistics.addElement(iscsiRemoteInitiatorStatistics);
    }

    private void removeISCSIRemoteInitiatorStatistics(ISCSIRemoteInitiatorStatisticsImpl iscsiRemoteInitiatorStatistics) {
        this.myIscsiRemoteInitiatorsStatistics.removeElement(iscsiRemoteInitiatorStatistics);
    }

    public Vector<ISCSISessionStatisticsImpl> getISCSISessionsStatisticsTable() {
        return this.mIscsiSessionsStatistics;
    }

    private void addISCSISessionStatistics(ISCSISessionStatisticsImpl iscsiSessionStatistics) {
        this.mIscsiSessionsStatistics.addElement(iscsiSessionStatistics);
    }

    private void removeISCSISessionStatistics(ISCSISessionStatisticsImpl iscsiSessionStatistics) {
        this.mIscsiSessionsStatistics.removeElement(iscsiSessionStatistics);
    }

    public boolean hasJournal() {
        return true;
    }

    public boolean hasPortalTarget() {
        ArrayList<PortalTableRowImpl> portals = new ArrayList<PortalTableRowImpl>(this.getPortalTable());
        for (PortalTableRowImpl portal : portals) {
            if (!portal.isTargetRole()) continue;
            return true;
        }
        return false;
    }

    @Override
    public SrFuture<Void> refreshRemoteDiscoveryPortalsTable() throws RemoteException {
        ConfigElementData element = new ConfigElementData(ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL);
        element.setValue(ParameterCode.REMOTE_PORTAL_DISC_LAST_FAILURE, (SrType)null);
        element.setValue(ParameterCode.REMOTE_PORTAL_DISC_LAST_DISCOVERY_SUCCESS_TIME, (SrType)null);
        element.setValue(ParameterCode.REMOTE_PORTAL_DISC_NEXT_PLANNED_DISCOVERY, (SrType)null);
        element.setValue(ParameterCode.REMOTE_PORTAL_DISC_STATE, (SrType)null);
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, (Object)this.getCommKeyClassId()));
        return DataMgrAdapter.getInstance().refreshTableFields(element);
    }

    public boolean isIPExistedAsLocalIP(String ip) {
        for (IPTableRowImpl vswitchIP : this.getIPTable()) {
            if (!vswitchIP.getIPAddress().equals(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsRoutIP(String ip) {
        for (IPRouteTableRowImpl routIP : this.getIPRouteTable()) {
            if (!routIP.getDestIPAdress().equals(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsLocalPortal(String ip) {
        for (PortalTableRowImpl portal : this.getPortalTable()) {
            if (!portal.getIPAddress().equals(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsLocalPortal(String ip, int port) {
        for (PortalTableRowImpl portal : this.getPortalTable()) {
            if (!portal.getIPAddress().equals(ip) || portal.getPort() != port) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsSNMPManager(String ip) {
        for (ManagerImpl manager : this.getManagerTable()) {
            if (manager.getIPAddress() == null) {
                theLogger.logAndAssert(SrLogCategories.ILLEGAL_STATE, new Object[]{"When validating the ip ", ip, " we found the snmp manager ", manager, " which does not have an ip address. This is a legal state if caused by alarm calculation after the VS has been removed, otherwise it is an illegal state."});
                return false;
            }
            if (!manager.getIPAddress().equals(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsNeighbor(String ip) {
        Vector<NeighborImpl> neigborsTable = this.getNeighborTable();
        for (NeighborImpl neighbor : neigborsTable) {
            if (!neighbor.getIPAddress().equals(ip)) continue;
            return true;
        }
        return false;
    }

    public SrFuture<Void> changeRemotetargetPortalsIfNeeded() {
        final SrFuture retFuture = new SrFuture("VSwitchImpl.changeRemotetargetPortalsIfNeeded");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        Vector<PortalTableRowImpl> portalTable = this.getPortalTable();
        ArrayList<ClusterImpl> clustersInOtherSites = SystemRootImpl.getInstance().getClustersInOtherSites(this.getCluster().getParentSite());
        for (ClusterImpl remoteCluster : clustersInOtherSites) {
            for (PortalTableRowImpl portal : portalTable) {
                midFutures.add(portal.synchronizeNewElementOnRemoteCluster(remoteCluster));
            }
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    @Override
    public SrFuture<Void> refreshFields(ConfigElementData element) {
        if (this.isConnected()) {
            return super.refreshFields(element);
        }
        return new CompleteFuture("VSwitchImpl.refreshFields");
    }

    private SrBITSConstant getCapability() {
        return (SrBITSConstant)this.getSrValueOf(ParameterCode.VSWITCH_CAPABILITY);
    }

    private SrBITSConstant getLicensePack() {
        return (SrBITSConstant)this.getSrValueOf(ParameterCode.VSWITCH_LICENSE_PACK);
    }

    public SrBITSConstant getActualCapability() {
        SrBITSConstant capability = this.getCapability();
        SrBITSConstant license = this.getLicensePack();
        if (capability != null && license != null) {
            if (VSwitchCapabilityConstant.compare((SrBITSConstant)capability, (SrBITSConstant)license) < 0) {
                return capability;
            }
            return license;
        }
        return capability != null ? capability : license;
    }

    @Override
    public VSwitchImpl getDominantVswitch() {
        return this;
    }

    public synchronized boolean isAlwaysEnableDeletion() {
        return this.isAlwaysEnableDeletion;
    }

    public synchronized void setAlwaysEnableDeletion(boolean aAlwaysEnableDeletion) {
        this.isAlwaysEnableDeletion = aAlwaysEnableDeletion;
    }

    public String getDiscoveryFutureFinished() {
        if (this.myDiscoveryFuture == null) {
            return "No discovery future";
        }
        if (this.myDiscoveryFuture.isDone()) {
            return "Discovery future is done.";
        }
        return "Discovery future is not done.";
    }

    public void unregisterBean() {
        this.myBean.unregister();
        this.myBean = null;
    }

    public void updateRaidControl() {
        if (this.isConnected()) {
            VSwitchSysOID type = this.getVSwitchType();
            if (type == null) {
                theLogger.logAndAssert(SrLogCategories.BUG, (Throwable)new IllegalStateException("VSwitchImpl.updateRaidControl() called but the V-Switch type was null, discovery state - " + this.cluster.isDiscoverCompleted()));
                return;
            }
            List<AttachedRaidImpl> raids = this.cluster.getAttachedRaidsMgr().getAllAttachedRaids();
            if (raids.isEmpty()) {
                return;
            }
            ConfigElementDataList raidsCeds = new ConfigElementDataList(ConfigOperation.CHANGE);
            for (AttachedRaidImpl raid : raids) {
                String vendorName = this.cluster.getAttachedRaidsMgr().getVendorNameForRaid(raid);
                if (vendorName == null) continue;
                ConfigElementData raidCed = new ConfigElementData(raid.getCommKeyClassId(), ConfigOperation.CHANGE);
                String raidName = raid.getName();
                SrIpAddress ip1 = raid.getCtrlIp1();
                SrIpAddress ip2 = raid.getCtrlIp2();
                if (raidName != null) {
                    raidCed.setValue(ParameterCode.ATTACHED_RAID_NAME, (SrType)new SrString(raidName));
                }
                raidCed.setValue(ParameterCode.ATTACHED_RAID_CTRL_IP1, (SrType)ip1);
                raidCed.setValue(ParameterCode.ATTACHED_RAID_CTRL_IP2, (SrType)ip2);
                raidCed.setValue(ParameterCode.PHYSICAL_STORAGE_VENDOR_NAME, (SrType)new SrString(vendorName));
                raidsCeds.add((ElementData)raidCed);
            }
            ErrorAssertingListener.listenTo(DataMgrAdapter.getInstance().configureElements(raidsCeds));
        }
    }

    public boolean isVStor() {
        VSwitchSysOID vsOID = this.getVSwitchType();
        if (vsOID == null) {
            return false;
        }
        return vsOID.isVStor();
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap params = super.getClientParameterList();
        params.put(ClientParameterCode.VSWITCH_NAME, this.getName());
        return params;
    }

    @Override
    public boolean isKnownByVSwitch(VSwitchImpl vSwitch) {
        return this.equals(vSwitch);
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_IP_MASK, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_GROUP_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_READ_COMMUNITY, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_WRITE_COMMUNITY, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_IP_ADDRESS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_SNMP_UDP_PORT, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_TRAP_UDP_PORT, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_SNMP_VERSION, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_MAX_RETRIES, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_TIMEOUT, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_TGT_QOS_ACTIVITY, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_TGT_QOS_MAX_RATE_LIMIT, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.GENERAL_POLL_INTERVAL, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_POLL_INTERVAL, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VIRTUALIZATION_POLL_INTERVAL, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ACL_POLL_INTERVAL, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.NET_POLL_INTERVAL, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.STATISTIC_POLL_INTERVAL, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_MGM_IP_ADDRESS, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_SYS_OID, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_CONTACT, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_DATE_AND_TIME, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_DESCRIPTION, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_LAST_RESET, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_LOCATION, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_NAME, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_CONNECTIVITY_STATUS, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_TELNET_PORT, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_LAST_KEEPALIVE, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_KEEPALIVE_INTERVAL, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_SUSPICIOUS_INTERVAL, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_FAULTY_INTERVAL, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_TAKE_OVER_STATE, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_FAILOVER_ENABLE, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_SWITCH_ID, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_REPORT_LUN_DISCOVERY, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_STATUS, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.TEMPERATURE_UNITS, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_CAPABILITY, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_LICENSE_PACK, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_TARGETS_COUNT, new ParameterCode.Flags(false, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        theEntityNameComparator = new Comparator<DirectAccessDeviceImpl>(){

            @Override
            public int compare(DirectAccessDeviceImpl o1, DirectAccessDeviceImpl o2) {
                return o1.getEntityName().compareTo(o2.getEntityName());
            }
        };
    }
}

