/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.BasicLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.TableRow;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class TableRowImpl
extends BasicLogicObjectImpl
implements TableRow {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private VSwitchImpl parentVSwitch = null;
    private static SrLogger theLogger;

    protected TableRowImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        CommKeyClassId vSwitchCommKeyClassId = (CommKeyClassId)aCED.getValue((ParameterCodes)ParameterCode.VSWITCH_ID);
        VSwitchImpl vSwitch = (VSwitchImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(vSwitchCommKeyClassId);
        this.setParentVSwitch(vSwitch);
        return changedValues;
    }

    protected void setParentVSwitch(VSwitchImpl vSwitch) {
        if (this.parentVSwitch == null && vSwitch != null) {
            this.parentVSwitch = vSwitch;
            this.parentVSwitch.addTableRow(this);
        }
    }

    @Override
    public VSwitchImpl getParentVSwitch() {
        return this.parentVSwitch;
    }

    @Override
    public int decrementConnectedVSwitchCounter(CommKey[] vSwitchCommKeys) throws RemoteException {
        int vSwitchCounter = super.decrementConnectedVSwitchCounter(vSwitchCommKeys);
        if (vSwitchCounter == 0) {
            this.parentVSwitch.removeTableRow(this);
        }
        return vSwitchCounter;
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_ID, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        theLogger = SrLogger.getLogger();
    }
}

