/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.SFPConnectedInterface;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.InterfaceSFPConnectorConstant;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class SFPConnectedInterfaceImpl
extends InterfaceTableRowImpl
implements SFPConnectedInterface {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    protected SFPConnectedInterfaceImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public InterfaceSFPConnectorConstant getConnectedSFPType() {
        return (InterfaceSFPConnectorConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.IF_CONNECTED_SFP_CONNECTOR);
    }

    @Override
    public String getConnectedSFPVendorName() {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.IF_CONNECTED_SFP_VENDOR_NAME);
    }

    @Override
    public Integer getConnectedSFPSpeedMbits() {
        Integer value = (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.IF_CONNECTED_SFP_SPEED);
        return value != null ? Integer.valueOf(value * 100) : null;
    }

    @Override
    public String getConnectedSFPVendorOUI() {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.IF_CONNECTED_SFP_VENDOR_OUI);
    }

    public boolean isConnctorTypeReserved() {
        InterfaceSFPConnectorConstant connectorType = this.getConnectedSFPType();
        return connectorType.isReserved();
    }

    public boolean isConnctorTypeUnknown() {
        InterfaceSFPConnectorConstant connectorType = this.getConnectedSFPType();
        if (connectorType == null) {
            return true;
        }
        return connectorType.isUnknown();
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.IF_CONNECTED_SFP_CONNECTOR, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_CONNECTED_SFP_VENDOR_NAME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_CONNECTED_SFP_SPEED, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_CONNECTED_SFP_VENDOR_OUI, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

